/*
 * Decompiled with CFR 0.152.
 */
package se.sics.mspsim.platform;

import java.awt.Color;
import java.awt.Dimension;
import java.io.File;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import se.sics.mspsim.ui.ManagedWindow;
import se.sics.mspsim.ui.WindowManager;
import se.sics.mspsim.util.ComponentRegistry;
import se.sics.mspsim.util.ServiceComponent;

public abstract class AbstractNodeGUI
extends JComponent
implements ServiceComponent {
    private static final long serialVersionUID = 1435276301923987019L;
    private final String windowName;
    private final String nodeImageName;
    private String name;
    private ComponentRegistry registry;
    private ImageIcon nodeImage;
    private ManagedWindow window;
    private ServiceComponent.Status status = ServiceComponent.Status.STOPPED;

    protected AbstractNodeGUI(String windowName, String imageName) {
        this.windowName = windowName;
        this.nodeImageName = imageName;
        this.setBackground(Color.black);
        this.setOpaque(true);
    }

    @Override
    public ServiceComponent.Status getStatus() {
        return this.status;
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected ImageIcon getNodeImage() {
        return this.nodeImage;
    }

    protected ComponentRegistry getRegistry() {
        return this.registry;
    }

    @Override
    public final void init(String name, ComponentRegistry registry) {
        this.name = name;
        this.registry = registry;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final void start() {
        File fp = new File(this.nodeImageName);
        if (!fp.canRead()) {
            URL imageURL = this.getImageURL(this.nodeImageName);
            if (imageURL == null && !this.nodeImageName.startsWith("images/") && !this.nodeImageName.startsWith("/images/")) {
                imageURL = this.getImageURL("images/" + this.nodeImageName);
            }
            if (imageURL == null) throw new IllegalStateException("image not found: " + this.nodeImageName);
            this.nodeImage = new ImageIcon(imageURL);
        } else {
            this.nodeImage = new ImageIcon(this.nodeImageName);
        }
        if (this.nodeImage.getIconWidth() == 0 || this.nodeImage.getIconHeight() == 0) {
            throw new IllegalStateException("image not found: " + this.nodeImageName);
        }
        this.setPreferredSize(new Dimension(this.nodeImage.getIconWidth(), this.nodeImage.getIconHeight()));
        WindowManager wm = (WindowManager)this.registry.getComponent("windowManager");
        this.window = wm.createWindow(this.windowName);
        this.window.add(this);
        this.startGUI();
        this.status = ServiceComponent.Status.STARTED;
        this.window.setVisible(true);
    }

    private URL getImageURL(String image) {
        URL imageURL = this.getClass().getResource(image);
        if (imageURL == null && !image.startsWith("/")) {
            imageURL = this.getClass().getResource("/" + image);
        }
        return imageURL;
    }

    @Override
    public final void stop() {
        this.status = ServiceComponent.Status.STOPPED;
        this.stopGUI();
    }

    protected abstract void startGUI();

    protected abstract void stopGUI();
}

