/*
 * Decompiled with CFR 0.152.
 */
package se.sics.mspsim.net;

import java.io.PrintStream;
import se.sics.jipv6.core.AbstractPacketHandler;
import se.sics.jipv6.core.Packet;
import se.sics.mspsim.chip.RFListener;
import se.sics.mspsim.core.MSP430Core;
import se.sics.mspsim.core.TimeEvent;
import se.sics.mspsim.util.Utils;

public class CC2420PacketHandler
extends AbstractPacketHandler
implements RFListener {
    public static final String CC2420_LEN = "cc2420.len";
    private static final int SFD_SEARCH = 1;
    private static final int LEN = 2;
    private static final int PACKET = 3;
    private static final byte[] PREAMBLE = new byte[]{0, 0, 0, 0, 122};
    private PrintStream out;
    byte[] packetBuffer = new byte[256];
    int mode = 1;
    int pos;
    int packetLen;
    int sfdSearch = 0;
    MSP430Core cpu;

    public CC2420PacketHandler(MSP430Core cpu) {
        this.cpu = cpu;
    }

    @Override
    public void receivedByte(byte data) {
        this.packetBuffer[this.pos++] = data;
        switch (this.mode) {
            case 1: {
                if (this.sfdSearch < 4 && data == 0) {
                    ++this.sfdSearch;
                }
                if (this.sfdSearch != 4 || data != 122) break;
                this.mode = 2;
                this.sfdSearch = 0;
                break;
            }
            case 2: {
                this.mode = 3;
                this.packetLen = data & 0xFF;
                System.out.println("Packet len: " + this.packetLen);
                break;
            }
            case 3: {
                if (this.pos != this.packetLen + PREAMBLE.length + 1) break;
                Packet packet = new Packet();
                packet.setBytes(this.packetBuffer, PREAMBLE.length + 1, this.packetLen - 2);
                packet.setAttribute(CC2420_LEN, packet.getTotalLength());
                this.dispatch(-1, packet);
                System.out.println("CC2420: Packet received");
                this.mode = 1;
                this.pos = 0;
            }
        }
    }

    public void printPacket(PrintStream out, Packet packet) {
        int payloadLen = packet.getAttributeAsInt(CC2420_LEN);
        out.print("CC2420 | len:" + payloadLen + " | ");
        for (int i = 0; i < payloadLen; ++i) {
            out.print(Utils.hex8(packet.getData(i) & 0xFF));
            if ((i & 3) != 3) continue;
            out.print(" ");
        }
        out.println();
    }

    public void sendPacket(Packet packet) {
        final Packet sendPacket = packet;
        byte[] size = new byte[1];
        byte[] crc = new byte[2];
        size[0] = (byte)(packet.getTotalLength() + 2 & 0xFF);
        packet.prependBytes(size);
        packet.prependBytes(PREAMBLE);
        packet.appendBytes(crc);
        byte[] data = packet.getBytes();
        System.out.println("Should send packet to radio!!!! " + packet.getTotalLength());
        TimeEvent te = new TimeEvent(0L){

            @Override
            public void execute(long t) {
                System.out.println("CC2420: Packet to send: ");
                byte[] buffer = sendPacket.getBytes();
                for (int i = 0; i < buffer.length; ++i) {
                    System.out.print(Utils.hex8(buffer[i]));
                    CC2420PacketHandler.this.out.print(Utils.hex8(buffer[i]));
                }
                CC2420PacketHandler.this.out.println();
            }
        };
        this.cpu.scheduleTimeEventMillis(te, 10.0);
    }

    public void setOutput(PrintStream out) {
        this.out = out;
    }

    public void packetReceived(Packet container) {
    }
}

