/*
 * Decompiled with CFR 0.152.
 */
package se.sics.mspsim.extutil.jfreechart;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.DefaultXYItemRenderer;
import org.jfree.data.general.Series;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import se.sics.mspsim.extutil.jfreechart.JFreeWindowDataHandler;

public class LineSampleChart
extends JFreeWindowDataHandler {
    private JPanel panel;
    private XYSeriesCollection dataset;
    private XYSeries dataSeries;
    private JFreeChart chart;
    private DefaultXYItemRenderer renderer;

    public LineSampleChart() {
        NumberAxis domain = new NumberAxis("Index");
        NumberAxis range = new NumberAxis("Value");
        XYPlot xyplot = new XYPlot();
        xyplot.setDomainAxis(domain);
        xyplot.setRangeAxis(range);
        this.dataset = new XYSeriesCollection();
        xyplot.setDataset(this.dataset);
        this.renderer = new DefaultXYItemRenderer();
        this.renderer.setSeriesPaint(0, Color.black);
        this.renderer.setSeriesShapesVisible(0, false);
        xyplot.setRenderer(this.renderer);
        domain.setAutoRange(true);
        domain.setLowerMargin(0.0);
        domain.setUpperMargin(0.0);
        domain.setTickLabelsVisible(true);
        range.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        this.chart = new JFreeChart("Test", JFreeChart.DEFAULT_TITLE_FONT, xyplot, true);
        ChartPanel chartPanel = new ChartPanel(this.chart);
        this.panel = new JPanel();
        this.panel.setLayout(new BorderLayout());
        this.panel.setPreferredSize(new Dimension(400, 200));
        this.panel.add((Component)chartPanel, "Center");
        this.dataSeries = new XYSeries((Comparable)((Object)"-"));
        this.dataSeries.setMaximumItemCount(200);
        this.dataset.addSeries(this.dataSeries);
    }

    @Override
    public JComponent getComponent() {
        return this.panel;
    }

    @Override
    public void lineRead(String line) {
        String[] parts = line.trim().split(" ");
        this.dataSeries.clear();
        for (int i = 0; i < parts.length; ++i) {
            this.dataSeries.add((double)i, LineSampleChart.atod(parts[i], 0.0));
        }
        this.panel.repaint();
    }

    @Override
    public void setProperty(String param, String[] args) {
        if ("title".equals(param)) {
            this.chart.setTitle(args[0]);
        }
    }

    @Override
    public int getDataSeriesCount() {
        return 1;
    }

    @Override
    public Series getDataSeries(int index) {
        return this.dataSeries;
    }

    @Override
    public void setProperty(int index, String param, String[] args) {
        super.setProperty(index, param, args);
        if ("color".equals(param)) {
            this.renderer.setSeriesPaint(index, Color.decode(args[0]));
            this.panel.repaint();
        }
    }
}

