/*
 * Decompiled with CFR 0.152.
 */
package se.sics.mspsim.extutil.jfreechart;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.DefaultXYItemRenderer;
import org.jfree.data.general.Series;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import se.sics.mspsim.extutil.jfreechart.JFreeWindowDataHandler;

public class LineChart
extends JFreeWindowDataHandler {
    private JPanel panel;
    private JFreeChart chart;
    private XYSeriesCollection dataset;
    private DefaultXYItemRenderer renderer = new DefaultXYItemRenderer();
    int point = 0;

    public LineChart() {
        NumberAxis domain = new NumberAxis("Time");
        NumberAxis range = new NumberAxis("Value");
        XYPlot xyplot = new XYPlot();
        xyplot.setDomainAxis(domain);
        xyplot.setRangeAxis(range);
        this.dataset = new XYSeriesCollection();
        xyplot.setDataset(this.dataset);
        xyplot.setRenderer(this.renderer);
        domain.setAutoRange(true);
        domain.setAutoRangeIncludesZero(false);
        domain.setLowerMargin(0.0);
        domain.setUpperMargin(0.0);
        domain.setTickLabelsVisible(true);
        range.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        this.chart = new JFreeChart("Data", JFreeChart.DEFAULT_TITLE_FONT, xyplot, true);
        ChartPanel chartPanel = new ChartPanel(this.chart);
        this.panel = new JPanel();
        this.panel.setLayout(new BorderLayout());
        this.panel.setPreferredSize(new Dimension(400, 200));
        this.panel.add((Component)chartPanel, "Center");
    }

    @Override
    public JComponent getComponent() {
        return this.panel;
    }

    @Override
    public int getDataSeriesCount() {
        return this.dataset.getSeriesCount();
    }

    @Override
    public Series getDataSeries(int index) {
        while (index >= this.dataset.getSeriesCount()) {
            this.addSeries();
        }
        return this.dataset.getSeries(index);
    }

    @Override
    public void setProperty(String param, String[] args) {
        if ("title".equals(param)) {
            this.chart.setTitle(args[0]);
        }
    }

    private void addSeries() {
        XYSeries dataSeries = new XYSeries((Comparable)((Object)("series " + (this.getDataSeriesCount() + 1))));
        dataSeries.setMaximumItemCount(200);
        this.renderer.setSeriesShapesVisible(this.getDataSeriesCount(), false);
        this.dataset.addSeries(dataSeries);
    }

    @Override
    public void lineRead(String line) {
        String[] parts = line.trim().split(" ");
        while (parts.length > this.getDataSeriesCount()) {
            this.addSeries();
        }
        for (int i = 0; i < parts.length; ++i) {
            this.dataset.getSeries(i).add((double)this.point, LineChart.atod(parts[i], 0.0));
        }
        ++this.point;
        this.panel.repaint();
    }

    @Override
    public void setProperty(int index, String param, String[] args) {
        super.setProperty(index, param, args);
        if ("color".equals(param)) {
            this.renderer.setSeriesPaint(index, Color.decode(args[0]));
            this.panel.repaint();
        }
    }
}

