/*
 * Decompiled with CFR 0.152.
 */
package se.sics.mspsim.extutil.jfreechart;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.Timer;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import se.sics.mspsim.core.MSP430Core;
import se.sics.mspsim.util.DataSource;

public class DataSourceSampler
implements ActionListener {
    private MSP430Core cpu;
    private int interval = 100;
    private Timer timer;
    private ArrayList<TimeSource> sources = new ArrayList();

    public DataSourceSampler(MSP430Core cpu) {
        this.cpu = cpu;
        this.timer = new Timer(this.interval, this);
        this.timer.start();
    }

    public void stop() {
        this.timer.stop();
    }

    public void start() {
        this.timer.start();
    }

    public TimeSource addDataSource(DataSource source, TimeSeries ts) {
        TimeSource times = new TimeSource(this.cpu, source, ts);
        this.sources.add(times);
        return times;
    }

    public void removeDataSource(TimeSource source) {
        this.sources.remove(source);
    }

    public void setInterval(int intMsek) {
        this.interval = intMsek;
        this.timer.setDelay(this.interval);
    }

    private void sampleAll() {
        if (this.sources.size() > 0) {
            TimeSource[] srcs = this.sources.toArray(new TimeSource[0]);
            for (int i = 0; i < srcs.length; ++i) {
                if (srcs[i] == null) continue;
                srcs[i].update();
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        this.sampleAll();
    }

    private static class TimeSource {
        private MSP430Core cpu;
        private DataSource dataSource;
        private TimeSeries timeSeries;
        private long lastUpdate;

        TimeSource(MSP430Core cpu, DataSource ds, TimeSeries ts) {
            this.cpu = cpu;
            this.dataSource = ds;
            this.timeSeries = ts;
        }

        public void update() {
            long time = this.cpu.cycles / 2L;
            if (time > this.lastUpdate) {
                this.lastUpdate = time;
                this.timeSeries.add((RegularTimePeriod)new Millisecond(new Date(time)), this.dataSource.getValue());
            }
        }
    }
}

