/*
 * Decompiled with CFR 0.152.
 */
package se.sics.mspsim.extutil.jfreechart;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JPanel;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.DefaultXYItemRenderer;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import se.sics.mspsim.core.MSP430;
import se.sics.mspsim.extutil.jfreechart.DataSourceSampler;
import se.sics.mspsim.ui.ManagedWindow;
import se.sics.mspsim.ui.WindowManager;
import se.sics.mspsim.util.ComponentRegistry;
import se.sics.mspsim.util.DataSource;
import se.sics.mspsim.util.ServiceComponent;
import se.sics.mspsim.util.StackMonitor;

public class DataChart
extends JPanel
implements ServiceComponent {
    private Mode mode = Mode.NONE;
    private TimeSeriesCollection dataset;
    private ComponentRegistry registry;
    private ManagedWindow jw;
    private MSP430 cpu;
    private DataSourceSampler dss;
    private ServiceComponent.Status status = ServiceComponent.Status.STOPPED;
    private String name = null;

    public DataChart(ComponentRegistry registry, String title, String yaxis) {
        DateAxis domain = new DateAxis("Time");
        NumberAxis range = new NumberAxis(yaxis);
        XYPlot xyplot = new XYPlot();
        xyplot.setDomainAxis(domain);
        xyplot.setRangeAxis(range);
        this.dataset = new TimeSeriesCollection();
        xyplot.setDataset(this.dataset);
        DefaultXYItemRenderer renderer = new DefaultXYItemRenderer();
        renderer.setSeriesPaint(0, Color.red);
        renderer.setSeriesPaint(1, Color.green);
        renderer.setSeriesPaint(2, Color.blue);
        renderer.setSeriesPaint(3, Color.black);
        renderer.setSeriesShapesVisible(0, false);
        renderer.setSeriesShapesVisible(1, false);
        renderer.setSeriesShapesVisible(2, false);
        renderer.setSeriesShapesVisible(3, false);
        xyplot.setRenderer(renderer);
        domain.setAutoRange(true);
        domain.setLowerMargin(0.0);
        domain.setUpperMargin(0.0);
        domain.setTickLabelsVisible(true);
        range.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        JFreeChart chart = new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, xyplot, true);
        ChartPanel chartPanel = new ChartPanel(chart);
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(400, 200));
        this.add((Component)chartPanel, "Center");
    }

    public void addTimeSeries(TimeSeries ts) {
        this.dataset.addSeries(ts);
    }

    private ManagedWindow openFrame(String name) {
        WindowManager wm = (WindowManager)this.registry.getComponent("windowManager");
        ManagedWindow jw = wm.createWindow(name);
        jw.add(this);
        return jw;
    }

    public void setupStackFrame(MSP430 cpu) {
        this.mode = Mode.STACK;
        this.cpu = cpu;
    }

    private void openStackFrame() {
        if (this.jw == null) {
            this.jw = this.openFrame("Stack Monitor");
            StackMonitor sm = new StackMonitor(this.cpu);
            DataSourceSampler dss = new DataSourceSampler(this.cpu);
            TimeSeries ts = new TimeSeries((Comparable)((Object)"Max Stack"), Millisecond.class);
            ts.setMaximumItemCount(200);
            this.addTimeSeries(ts);
            dss.addDataSource(sm.getMaxSource(), ts);
            ts = new TimeSeries((Comparable)((Object)"Stack"), Millisecond.class);
            ts.setMaximumItemCount(200);
            this.addTimeSeries(ts);
            dss.addDataSource(sm.getSource(), ts);
        }
    }

    public DataSourceSampler setupChipFrame(MSP430 cpu) {
        this.mode = Mode.DUTY;
        this.cpu = cpu;
        this.jw = this.openFrame("Duty-Cycle Monitor");
        this.dss = new DataSourceSampler(cpu);
        this.dss.setInterval(50);
        return this.dss;
    }

    public void addDataSource(DataSourceSampler dss, String name, DataSource src) {
        TimeSeries ts = new TimeSeries((Comparable)((Object)name), Millisecond.class);
        ts.setMaximumItemCount(200);
        this.addTimeSeries(ts);
        dss.addDataSource(src, ts);
    }

    @Override
    public ServiceComponent.Status getStatus() {
        return this.status;
    }

    @Override
    public void init(String name, ComponentRegistry registry) {
        this.registry = registry;
        this.name = name;
    }

    @Override
    public void start() {
        if (this.mode == Mode.STACK) {
            this.openStackFrame();
        } else {
            this.dss.start();
        }
        this.jw.setVisible(true);
        this.status = ServiceComponent.Status.STARTED;
    }

    @Override
    public void stop() {
        this.jw.setVisible(false);
        if (this.mode != Mode.STACK) {
            this.dss.stop();
        }
        this.status = ServiceComponent.Status.STOPPED;
    }

    @Override
    public String getName() {
        return this.name;
    }

    private static enum Mode {
        NONE,
        STACK,
        DUTY;

    }
}

