/*
 * Decompiled with CFR 0.152.
 */
package se.sics.mspsim.extutil.highlight;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.Reader;
import javax.swing.JTextPane;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Element;
import javax.swing.text.Segment;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import se.sics.mspsim.extutil.highlight.Scanner;
import se.sics.mspsim.extutil.highlight.Token;
import se.sics.mspsim.extutil.highlight.TokenTypes;

public class SyntaxHighlighter
extends JTextPane
implements DocumentListener,
TokenTypes {
    private static final long serialVersionUID = -1801145479677890566L;
    private StyledDocument doc;
    private Scanner scanner;
    private int rows;
    private int columns;
    private int currentY;
    private int currentHeight = -1;
    private Style[] styles;
    private Segment text = new Segment();
    private int firstRehighlightToken;
    private int smallAmount = 100;
    private Color highlightColor = new Color(0, 240, 0, 255);

    public SyntaxHighlighter(int rows, int columns, Scanner scanner) {
        super(new DefaultStyledDocument());
        this.doc = (StyledDocument)this.getDocument();
        this.rows = rows;
        this.columns = columns;
        this.scanner = scanner;
        this.doc.addDocumentListener(this);
        Font font = new Font("Monospaced", 0, this.getFont().getSize());
        this.changeFont(font);
        this.initStyles();
        this.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                int caret = SyntaxHighlighter.this.getCaretPosition();
                if (caret >= 0) {
                    try {
                        Rectangle r = SyntaxHighlighter.this.getUI().modelToView(SyntaxHighlighter.this, caret);
                        if (SyntaxHighlighter.this.currentHeight > 0) {
                            SyntaxHighlighter.this.repaint(0, SyntaxHighlighter.this.currentY, SyntaxHighlighter.this.getWidth(), SyntaxHighlighter.this.currentHeight);
                        }
                        if (r != null && r.height > 0) {
                            SyntaxHighlighter.this.currentY = r.y;
                            SyntaxHighlighter.this.currentHeight = r.height;
                            SyntaxHighlighter.this.repaint(0, r.y, SyntaxHighlighter.this.getWidth(), r.height);
                        } else {
                            SyntaxHighlighter.this.currentHeight = -1;
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }
        });
        this.setOpaque(false);
    }

    public int getColumns() {
        return this.columns;
    }

    public int getRows() {
        return this.rows;
    }

    public void changeFont(Font font) {
        int borderOfJTextPane = 3;
        this.setFont(font);
        FontMetrics metrics = this.getFontMetrics(font);
        int paneWidth = this.columns * metrics.charWidth('m') + 2 * borderOfJTextPane;
        int paneHeight = this.rows * metrics.getHeight() + 2 * borderOfJTextPane;
        Dimension size = new Dimension(paneWidth, paneHeight);
        this.setMinimumSize(size);
        this.setPreferredSize(size);
        this.invalidate();
    }

    @Override
    public void read(Reader in, Object desc) throws IOException {
        int oldLength = this.getDocument().getLength();
        this.doc.removeDocumentListener(this);
        super.read(in, desc);
        this.doc = (StyledDocument)this.getDocument();
        this.doc.addDocumentListener(this);
        int newLength = this.getDocument().getLength();
        this.firstRehighlightToken = this.scanner.change(0, oldLength, newLength);
        this.repaint();
    }

    private void initStyles() {
        this.styles = new Style[typeNames.length];
        this.changeStyle(0, Color.black);
        this.changeStyle(1, Color.black);
        this.changeStyle(2, Color.black);
        this.changeStyle(3, Color.black);
        this.changeStyle(4, Color.blue);
        this.changeStyle(5, new Color(178, 34, 34), 2);
        this.changeStyle(6, new Color(178, 34, 34), 2);
        this.changeStyle(7, new Color(178, 34, 34), 2);
        this.changeStyle(8, new Color(178, 34, 34), 2);
        this.changeStyle(9, Color.blue, 1);
        this.changeStyle(10, Color.blue, 1);
        this.changeStyle(11, new Color(160, 32, 240));
        this.changeStyle(12, new Color(160, 32, 240));
        this.changeStyle(13, Color.black);
        this.changeStyle(14, Color.green.darker());
        this.changeStyle(15, new Color(188, 143, 143));
        this.changeStyle(16, new Color(188, 143, 143));
        this.changeStyle(17, Color.black, 1);
        this.changeStyle(18, Color.black);
        this.changeStyle(19, Color.black);
        this.changeStyle(20, Color.blue.darker());
        for (int i = 0; i < this.styles.length; ++i) {
            if (this.styles[i] != null) continue;
            this.styles[i] = this.styles[1];
        }
    }

    public void changeStyle(int type, Color color) {
        Style style = this.addStyle(typeNames[type], null);
        StyleConstants.setForeground(style, color);
        this.styles[type] = style;
    }

    public void changeStyle(int type, Color color, int fontStyle) {
        Style style = this.addStyle(typeNames[type], null);
        StyleConstants.setForeground(style, color);
        if ((fontStyle & 1) != 0) {
            StyleConstants.setBold(style, true);
        }
        if ((fontStyle & 2) != 0) {
            StyleConstants.setItalic(style, true);
        }
        this.styles[type] = style;
    }

    public int getLineCount() {
        return this.getDocument().getDefaultRootElement().getElementCount();
    }

    public int getLineStartOffset(int line) {
        Element root = this.getDocument().getDefaultRootElement();
        if (line < 0 || line >= root.getElementCount()) {
            throw new IndexOutOfBoundsException("illegal line");
        }
        return root.getElement(line).getStartOffset();
    }

    public int getLineEndOffset(int line) {
        Element root = this.getDocument().getDefaultRootElement();
        if (line < 0 || line >= root.getElementCount()) {
            throw new IndexOutOfBoundsException("illegal line");
        }
        return root.getElement(line).getEndOffset();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        int offset = e.getOffset();
        int length = e.getLength();
        this.firstRehighlightToken = this.scanner.change(offset, 0, length);
        this.repaint();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        int offset = e.getOffset();
        int length = e.getLength();
        this.firstRehighlightToken = this.scanner.change(offset, length, 0);
        this.repaint();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.currentHeight > 0) {
            g.setColor(this.highlightColor);
            g.fillRect(0, this.currentY, this.getWidth(), this.currentHeight);
        }
        super.paintComponent(g);
        int offset = this.scanner.position();
        if (offset < 0) {
            return;
        }
        int tokensToRedo = 0;
        int amount = this.smallAmount;
        while (tokensToRedo == 0 && offset >= 0) {
            int length = this.doc.getLength() - offset;
            if (length > amount) {
                length = amount;
            }
            try {
                this.doc.getText(offset, length, this.text);
            }
            catch (BadLocationException e) {
                return;
            }
            tokensToRedo = this.scanner.scan(this.text.array, this.text.offset, this.text.count);
            offset = this.scanner.position();
            amount = 2 * amount;
        }
        for (int i = 0; i < tokensToRedo; ++i) {
            Token t = this.scanner.getToken(this.firstRehighlightToken + i);
            int length = t.symbol.name.length();
            int type = t.symbol.type;
            if (type < 0) {
                type = 0;
            }
            this.doc.setCharacterAttributes(t.position, length, this.styles[type], false);
        }
        this.firstRehighlightToken += tokensToRedo;
        if (offset >= 0) {
            this.repaint(2L);
        }
    }

    public void viewLine(int line) {
        if (line >= 0 && line < this.getLineCount()) {
            try {
                int pos = this.getLineStartOffset(line);
                Rectangle r = this.getUI().modelToView(this, pos);
                if (r != null && r.height > 0) {
                    Rectangle vr = this.getVisibleRect();
                    vr.y = r.y - vr.height / 2;
                    if (vr.y < 0) {
                        vr.y = 0;
                    }
                    this.scrollRectToVisible(vr);
                }
                this.setCaretPosition(pos);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }
}

