/*
 * Decompiled with CFR 0.152.
 */
package se.sics.mspsim.extutil.highlight;

import java.util.HashMap;
import se.sics.mspsim.extutil.highlight.Symbol;
import se.sics.mspsim.extutil.highlight.Token;
import se.sics.mspsim.extutil.highlight.TokenTypes;

public class Scanner
implements TokenTypes {
    protected char[] buffer;
    protected int start;
    protected int end;
    protected int state = 1;
    private Token[] tokens;
    private int gap = 0;
    private int endgap = 0;
    private int textLength = 0;
    private boolean scanning;
    private int position;
    protected HashMap<Symbol, Symbol> symbolTable;
    private Symbol symbol = new Symbol(0, null);

    protected int read() {
        int type;
        char c = this.buffer[this.start];
        if (Character.isWhitespace(c)) {
            type = 1;
            while (++this.start < this.end && Character.isWhitespace(this.buffer[this.start])) {
            }
        } else if (Character.isLetter(c)) {
            type = 2;
            while (++this.start < this.end && (Character.isLetter(c = this.buffer[this.start]) || Character.isDigit(c) || c == '-' || c == '\'' || c == '_')) {
            }
        } else if (Character.isDigit(c)) {
            type = 3;
            while (++this.start < this.end && (Character.isDigit(c = this.buffer[this.start]) || c == '.')) {
            }
        } else if (c >= '!' || c <= '~') {
            type = 4;
            ++this.start;
        } else {
            type = 0;
            ++this.start;
        }
        return type;
    }

    public Scanner() {
        this.tokens = new Token[1];
        this.symbolTable = new HashMap();
        this.initSymbolTable();
        Symbol endOfText = new Symbol(1, "");
        this.tokens[0] = new Token(endOfText, 0);
        this.scanning = false;
        this.position = 0;
    }

    private void moveGap(int newgap) {
        block5: {
            block4: {
                if (this.scanning) {
                    throw new Error("moveGap called while scanning");
                }
                if (newgap < 0 || newgap > this.gap + this.tokens.length - this.endgap) {
                    throw new Error("bad argument to moveGap");
                }
                if (this.gap >= newgap) break block4;
                while (this.gap < newgap) {
                    this.tokens[this.endgap].position += this.textLength;
                    this.tokens[this.gap++] = this.tokens[this.endgap++];
                }
                break block5;
            }
            if (this.gap <= newgap) break block5;
            while (this.gap > newgap) {
                this.tokens[--this.endgap] = this.tokens[--this.gap];
                this.tokens[this.endgap].position -= this.textLength;
            }
        }
    }

    public int size() {
        if (this.scanning) {
            return this.gap;
        }
        return this.gap + this.tokens.length - this.endgap;
    }

    public Token getToken(int n) {
        if (n < 0 || n >= this.gap && this.scanning) {
            return null;
        }
        if (n >= this.gap) {
            this.moveGap(n + 1);
        }
        return this.tokens[n];
    }

    public int find(int p) {
        int start = 0;
        if (!this.scanning) {
            this.moveGap(this.gap + this.tokens.length - this.endgap);
        }
        int end = this.gap - 1;
        if (p > this.tokens[end].position) {
            return end;
        }
        while (end > start + 1) {
            int mid = (start + end) / 2;
            int midpos = this.tokens[mid].position;
            if (p > midpos) {
                start = mid;
                continue;
            }
            end = mid;
        }
        return start;
    }

    public int change(int start, int len, int newLen) {
        if (start < 0 || len < 0 || newLen < 0 || start + len > this.textLength) {
            throw new Error("change(" + start + "," + len + "," + newLen + ")");
        }
        this.textLength += newLen - len;
        int end = start + newLen;
        if (this.scanning) {
            while (this.gap > 0 && this.tokens[this.gap - 1].position > start) {
                --this.gap;
            }
            if (this.gap > 0) {
                --this.gap;
            }
            if (this.gap > 0) {
                --this.gap;
                this.position = this.tokens[this.gap].position;
                this.state = this.tokens[this.gap].symbol.type;
            } else {
                this.position = 0;
                this.state = 1;
            }
            while (this.tokens[this.endgap].position + this.textLength < end) {
                ++this.endgap;
            }
            return this.gap;
        }
        if (this.endgap == this.tokens.length) {
            this.moveGap(this.gap - 1);
        }
        this.scanning = true;
        while (this.tokens[this.endgap].position + this.textLength < start) {
            this.tokens[this.endgap].position += this.textLength;
            this.tokens[this.gap++] = this.tokens[this.endgap++];
        }
        while (this.gap > 0 && this.tokens[this.gap - 1].position > start) {
            this.tokens[--this.endgap] = this.tokens[--this.gap];
            this.tokens[this.endgap].position -= this.textLength;
        }
        if (this.gap > 0) {
            --this.gap;
        }
        if (this.gap > 0) {
            --this.gap;
            this.position = this.tokens[this.gap].position;
            this.state = this.tokens[this.gap].symbol.type;
        } else {
            this.position = 0;
            this.state = 1;
        }
        while (this.tokens[this.endgap].position + this.textLength < end) {
            ++this.endgap;
        }
        return this.gap;
    }

    public int position() {
        if (!this.scanning) {
            return -1;
        }
        return this.position;
    }

    protected void initSymbolTable() {
    }

    protected Symbol lookup(int type, String name) {
        this.symbol.type = type;
        this.symbol.name = name;
        Symbol sym = this.symbolTable.get(this.symbol);
        if (sym != null) {
            return sym;
        }
        sym = new Symbol(type, name);
        this.symbolTable.put(sym, sym);
        return sym;
    }

    public int scan(char[] array, int offset, int length) {
        if (!this.scanning) {
            throw new Error("scan called when not scanning");
        }
        if (this.position + length > this.textLength) {
            throw new Error("scan too much");
        }
        boolean all = this.position + length == this.textLength;
        this.end = this.start + length;
        int startGap = this.gap;
        this.buffer = array;
        this.start = offset;
        this.end = this.start + length;
        while (this.start < this.end) {
            int tokenStart = this.start;
            int type = this.read();
            if (this.start == this.end && !all) break;
            if (type != 1) {
                String name = new String(this.buffer, tokenStart, this.start - tokenStart);
                Symbol sym = this.lookup(type, name);
                Token t = new Token(sym, this.position);
                if (this.gap >= this.endgap) {
                    this.checkCapacity(this.gap + this.tokens.length - this.endgap + 1);
                }
                this.tokens[this.gap++] = t;
            }
            while (this.tokens[this.endgap].position + this.textLength < this.position) {
                ++this.endgap;
            }
            if (this.position + this.start - tokenStart == this.textLength) {
                this.scanning = false;
            } else if (this.gap > 0 && this.tokens[this.endgap].position + this.textLength == this.position && this.tokens[this.endgap].symbol.type == type) {
                ++this.endgap;
                this.scanning = false;
                break;
            }
            this.position += this.start - tokenStart;
        }
        this.checkCapacity(this.gap + this.tokens.length - this.endgap);
        return this.gap - startGap;
    }

    private void checkCapacity(int capacity) {
        int newCapacity;
        int oldCapacity = this.tokens.length;
        if (capacity <= oldCapacity && 4 * capacity >= oldCapacity) {
            return;
        }
        Token[] oldTokens = this.tokens;
        if (capacity > oldCapacity) {
            newCapacity = oldCapacity * 2;
            if (newCapacity < capacity) {
                newCapacity = capacity;
            }
        } else {
            newCapacity = capacity * 2;
        }
        this.tokens = new Token[newCapacity];
        System.arraycopy(oldTokens, 0, this.tokens, 0, this.gap);
        int n = oldCapacity - this.endgap;
        System.arraycopy(oldTokens, this.endgap, this.tokens, newCapacity - n, n);
        this.endgap = newCapacity - n;
    }

    void print() {
        for (int i = 0; i < this.tokens.length; ++i) {
            if (i >= this.gap && i < this.endgap) continue;
            if (i == this.endgap) {
                System.out.print("... ");
            }
            System.out.print("" + i + ":" + this.tokens[i].position);
            System.out.print("-" + (this.tokens[i].position + this.tokens[i].symbol.name.length()));
            System.out.print(" ");
        }
        System.out.println();
    }
}

