/*
 * Decompiled with CFR 0.152.
 */
package se.sics.mspsim.extutil.highlight;

import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.border.AbstractBorder;
import se.sics.mspsim.extutil.highlight.SyntaxHighlighter;

public class LineNumberedBorder
extends AbstractBorder {
    private static final long serialVersionUID = -3812536735962506061L;
    public static int LEFT_SIDE = -2;
    public static int RIGHT_SIDE = -1;
    public static int RIGHT_JUSTIFY = 0;
    public static int LEFT_JUSTIFY = 1;
    private int lineNumberJustification = RIGHT_JUSTIFY;
    private int location = LEFT_SIDE;
    private Color separatorColor = null;

    public LineNumberedBorder(int location, int justify) {
        this.setLocation(location);
        this.setLineNumberJustification(justify);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        if (c instanceof SyntaxHighlighter) {
            int width = this.lineNumberWidth((SyntaxHighlighter)c);
            if (this.location == LEFT_SIDE) {
                insets.left = width;
            } else {
                insets.right = width;
            }
        }
        return insets;
    }

    public int getLineNumberJustification() {
        return this.lineNumberJustification;
    }

    public void setLineNumberJustification(int justify) {
        if (justify == RIGHT_JUSTIFY || justify == LEFT_JUSTIFY) {
            this.lineNumberJustification = justify;
        }
    }

    public int getLocation() {
        return this.location;
    }

    public void setLocation(int loc) {
        if (loc == RIGHT_SIDE || loc == LEFT_SIDE) {
            this.location = loc;
        }
    }

    public Color getSeparatorColor() {
        return this.separatorColor;
    }

    public void setSeparatorColor(Color c) {
        this.separatorColor = c;
    }

    private int lineNumberWidth(SyntaxHighlighter textArea) {
        int lineCount = Math.max(textArea.getRows(), textArea.getLineCount() + 1);
        return textArea.getFontMetrics(textArea.getFont()).stringWidth(lineCount + " ");
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        int yend;
        Rectangle clip = g.getClipBounds();
        FontMetrics fm = g.getFontMetrics();
        int fontHeight = fm.getHeight();
        int ybaseline = y + fm.getAscent();
        int startingLineNumber = clip.y / fontHeight + 1;
        if (ybaseline < clip.y) {
            ybaseline = y + startingLineNumber * fontHeight - (fontHeight - fm.getAscent());
        }
        if ((yend = ybaseline + height) > y + height) {
            yend = y + height;
        }
        SyntaxHighlighter jta = (SyntaxHighlighter)c;
        int lineWidth = this.lineNumberWidth(jta);
        int lnxstart = x;
        lnxstart = this.location == LEFT_SIDE ? (this.lineNumberJustification == LEFT_JUSTIFY ? x : x + lineWidth) : (this.lineNumberJustification == LEFT_JUSTIFY ? y + width - lineWidth : y + width);
        g.setColor(c.getForeground());
        int length = ("" + Math.max(jta.getRows(), jta.getLineCount() + 1)).length();
        while (ybaseline < yend) {
            if (this.lineNumberJustification == LEFT_JUSTIFY) {
                g.drawString(startingLineNumber + " ", lnxstart, ybaseline);
            } else {
                String label = LineNumberedBorder.padLabel(startingLineNumber, length, true);
                g.drawString(label, lnxstart - fm.stringWidth(label), ybaseline);
            }
            ybaseline += fontHeight;
            ++startingLineNumber;
        }
        if (this.separatorColor != null) {
            g.setColor(this.separatorColor);
            lnxstart = this.location == LEFT_SIDE ? x + lineWidth - 1 : width - lineWidth;
            g.drawLine(lnxstart, 0, lnxstart, height);
        }
    }

    private static String padLabel(int lineNumber, int length, boolean addSpace) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(lineNumber);
        for (int count = length - buffer.length(); count > 0; --count) {
            buffer.insert(0, ' ');
        }
        if (addSpace) {
            buffer.append(' ');
        }
        return buffer.toString();
    }
}

