/*
 * Decompiled with CFR 0.152.
 */
package se.sics.mspsim.extutil.highlight;

import java.awt.Color;
import java.awt.Container;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import se.sics.mspsim.extutil.highlight.CScanner;
import se.sics.mspsim.extutil.highlight.LineNumberedBorder;
import se.sics.mspsim.extutil.highlight.SyntaxHighlighter;
import se.sics.mspsim.ui.SourceViewer;
import se.sics.mspsim.ui.WindowUtils;

public class HighlightSourceViewer
implements SourceViewer {
    private JFrame window;
    private SyntaxHighlighter highlighter;
    private String currentFile;
    private ArrayList<File> path = null;
    private JFileChooser fileChooser;

    private void setup() {
        if (this.window == null) {
            this.window = new JFrame("Source Viewer");
            this.window.setDefaultCloseOperation(2);
            LineNumberedBorder border = new LineNumberedBorder(LineNumberedBorder.LEFT_SIDE, LineNumberedBorder.RIGHT_JUSTIFY);
            border.setSeparatorColor(Color.lightGray);
            CScanner scanner = new CScanner();
            this.highlighter = new SyntaxHighlighter(24, 120, scanner);
            this.highlighter.setEditable(false);
            this.highlighter.setBorder(border);
            JScrollPane scroller = new JScrollPane(this.highlighter);
            scroller.setVerticalScrollBarPolicy(22);
            Container pane = this.window.getContentPane();
            pane.add(scroller);
            WindowUtils.restoreWindowBounds("SourceViewer", this.window);
            WindowUtils.addSaveOnShutdown("SourceViewer", this.window);
            String searchPath = System.getProperty("CONTIKI_PATH");
            if (searchPath != null) {
                this.addEnvPath(searchPath);
            }
            if ((searchPath = System.getenv("CONTIKI_PATH")) != null) {
                this.addEnvPath(searchPath);
            }
        }
    }

    private void addEnvPath(String searchPath) {
        String[] p = searchPath.split(File.pathSeparator);
        if (p != null) {
            int n = p.length;
            for (int i = 0; i < n; ++i) {
                this.addSearchPath(new File(p[i]));
            }
        }
    }

    @Override
    public boolean isVisible() {
        return this.window != null && this.window.isVisible();
    }

    public void setVisible(boolean isVisible) {
        this.setup();
        this.window.setVisible(isVisible);
    }

    @Override
    public void viewFile(final String path, final String filename) {
        if (filename.equals(this.currentFile)) {
            return;
        }
        this.currentFile = filename;
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block6: {
                    try {
                        HighlightSourceViewer.this.setup();
                        File file = HighlightSourceViewer.this.findSourceFile(path, filename);
                        if (file == null) break block6;
                        FileReader reader = new FileReader(file);
                        try {
                            HighlightSourceViewer.this.highlighter.read(reader, null);
                            HighlightSourceViewer.this.highlighter.setCaretPosition(1);
                            HighlightSourceViewer.this.highlighter.setCaretPosition(0);
                            HighlightSourceViewer.this.window.setTitle("Source Viewer (" + file.getAbsolutePath() + ')');
                            if (!HighlightSourceViewer.this.window.isVisible()) {
                                HighlightSourceViewer.this.window.setVisible(true);
                            }
                        }
                        finally {
                            reader.close();
                        }
                    }
                    catch (IOException err) {
                        err.printStackTrace();
                        JOptionPane.showMessageDialog(HighlightSourceViewer.this.window, "Failed to read the file '" + filename + '\'', "Could not read file", 0);
                    }
                }
            }
        });
    }

    @Override
    public void viewLine(final int line) {
        if (this.highlighter != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    HighlightSourceViewer.this.highlighter.viewLine(line - 1);
                    if (!HighlightSourceViewer.this.window.isVisible()) {
                        HighlightSourceViewer.this.window.setVisible(true);
                    }
                }
            });
        }
    }

    public void addSearchPath(File directory) {
        if (this.path == null) {
            this.path = new ArrayList();
        }
        this.path.add(directory);
    }

    public void removeSearchPath(File directory) {
        if (this.path != null) {
            this.path.remove(directory);
        }
    }

    private File findSourceFile(String fPath, String filename) {
        File d;
        File fp = new File(fPath, filename);
        if (fp.exists()) {
            return fp;
        }
        fp = new File(filename);
        if (fp.exists()) {
            return fp;
        }
        if (this.path != null) {
            for (File p : this.path) {
                File nfp = new File(p, filename);
                if (!nfp.exists()) continue;
                return nfp;
            }
        } else {
            this.path = new ArrayList();
        }
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser("./");
            this.fileChooser.setFileSelectionMode(1);
            this.fileChooser.setDialogTitle("Select compilation directory");
        }
        if (!this.window.isVisible()) {
            this.window.setVisible(true);
        }
        if (this.fileChooser.showOpenDialog(this.window) == 0 && (d = this.fileChooser.getSelectedFile()) != null) {
            this.path.add(d);
            return this.findSourceFile(fPath, filename);
        }
        return null;
    }

    public static void main(String[] args) {
        HighlightSourceViewer sv = new HighlightSourceViewer();
        sv.setVisible(true);
        sv.viewFile(".", args[0]);
    }
}

