/*
 * Decompiled with CFR 0.152.
 */
package se.sics.mspsim.core;

import se.sics.mspsim.core.IOUnit;
import se.sics.mspsim.core.MSP430Core;
import se.sics.mspsim.core.TimeEvent;

public class Watchdog
extends IOUnit {
    private static final boolean DEBUG = false;
    private static final int WDTCTL = 288;
    private static final int WDTHOLD = 128;
    private static final int WDTCNTCL = 8;
    private static final int WDTSSEL = 4;
    private static final int WDTISx = 3;
    private static final int RESET_VECTOR = 15;
    private static final int[] DELAY = new int[]{32768, 8192, 512, 64};
    private int wdtctl;
    private boolean wdtOn = true;
    private boolean hold = false;
    private MSP430Core cpu;
    private int delay;
    private long targetTime;
    private boolean sourceACLK = false;
    private TimeEvent wdtTrigger = new TimeEvent(0L, "Watchdog"){

        @Override
        public void execute(long t) {
            Watchdog.this.triggerWDT(t);
        }
    };

    public Watchdog(MSP430Core cpu) {
        super(cpu.memory, 288);
        this.cpu = cpu;
    }

    @Override
    public String getName() {
        return "Watchdog";
    }

    @Override
    public void interruptServiced(int vector) {
        this.cpu.flagInterrupt(15, this, false);
    }

    private void triggerWDT(long time) {
        System.out.println("WDT trigger - will reset node!");
        this.cpu.generateTrace(System.out);
        this.cpu.flagInterrupt(15, this, true);
    }

    @Override
    public int read(int address, boolean word, long cycles) {
        if (address == 288) {
            return this.wdtctl | 0x6900;
        }
        return 0;
    }

    @Override
    public void write(int address, int value, boolean word, long cycles) {
        if (address == 288) {
            if (value >> 8 == 90) {
                this.wdtctl = value & 0xFF;
                this.wdtOn = (value & 0x80) == 0;
                boolean lastACLK = this.sourceACLK;
                boolean bl = this.sourceACLK = (value & 4) != 0;
                if ((value & 8) != 0) {
                    this.delay = DELAY[value & 3];
                }
                if (this.wdtOn) {
                    if (this.sourceACLK) {
                        this.targetTime = this.cpu.scheduleTimeEventMillis(this.wdtTrigger, 1000.0 * (double)this.delay / (double)this.cpu.aclkFrq);
                    } else {
                        this.targetTime = this.cpu.cycles + (long)this.delay;
                        this.cpu.scheduleCycleEvent(this.wdtTrigger, this.targetTime);
                    }
                } else {
                    this.wdtTrigger.remove();
                }
            } else {
                this.cpu.flagInterrupt(15, this, true);
            }
        }
    }
}

