/*
 * Decompiled with CFR 0.152.
 */
package se.sics.mspsim.core;

import se.sics.mspsim.core.IOUnit;
import se.sics.mspsim.core.MSP430Core;
import se.sics.mspsim.core.SFR;
import se.sics.mspsim.core.SFRModule;
import se.sics.mspsim.core.TimeEvent;
import se.sics.mspsim.core.USARTListener;

public class USART
extends IOUnit
implements SFRModule {
    public static final boolean DEBUG = false;
    public static final int UCTL = 0;
    public static final int UTCTL = 1;
    public static final int URCTL = 2;
    public static final int UMCTL = 3;
    public static final int UBR0 = 4;
    public static final int UBR1 = 5;
    public static final int URXBUF = 6;
    public static final int UTXBUF = 7;
    public static final int UTXIFG0 = 128;
    public static final int URXIFG0 = 64;
    public static final int UTXIFG1 = 32;
    public static final int URXIFG1 = 16;
    public static final int ME1 = 4;
    public static final int IE1 = 0;
    public static final int IFG1 = 2;
    private int uartID = 0;
    public static final int USART0_RX_VEC = 9;
    public static final int USART0_TX_VEC = 8;
    public static final int USART0_RX_BIT = 6;
    public static final int USART0_TX_BIT = 7;
    public static final int USART1_RX_VEC = 3;
    public static final int USART1_TX_VEC = 2;
    public static final int USART1_RX_BIT = 4;
    public static final int USART1_TX_BIT = 5;
    public static final int UTCTL_TXEMPTY = 1;
    private USARTListener listener;
    private int utxifg;
    private int urxifg;
    private int rxVector;
    private int clockSource = 0;
    private int baudRate = 0;
    private int tickPerByte = 1000;
    private long nextTXReady = -1L;
    private int nextTXByte = -1;
    private int txShiftReg = -1;
    private boolean transmitting = false;
    private MSP430Core cpu;
    private SFR sfr;
    private int uctl;
    private int utctl;
    private int urctl;
    private int umctl;
    private int ubr0;
    private int ubr1;
    private int urxbuf;
    private int utxbuf;
    private int txbit;
    private boolean txEnabled = false;
    private boolean rxEnabled = false;
    private boolean spiMode = false;
    private TimeEvent txTrigger = new TimeEvent(0L){

        @Override
        public void execute(long t) {
            USART.this.handleTransmit(t);
        }
    };

    public USART(MSP430Core cpu, int[] memory, int offset) {
        super(memory, offset);
        this.cpu = cpu;
        this.sfr = cpu.getSFR();
        if (offset == 120) {
            this.uartID = 1;
        }
        if (this.uartID == 0) {
            this.sfr.registerSFDModule(0, 6, this, 9);
            this.sfr.registerSFDModule(0, 7, this, 8);
            this.utxifg = 128;
            this.urxifg = 64;
            this.txbit = 7;
            this.rxVector = 9;
        } else {
            this.sfr.registerSFDModule(1, 4, this, 3);
            this.sfr.registerSFDModule(1, 5, this, 2);
            this.utxifg = 32;
            this.urxifg = 16;
            this.txbit = 5;
            this.rxVector = 3;
        }
        this.reset(0);
    }

    @Override
    public void reset(int type) {
        this.nextTXReady = this.cpu.cycles + 100L;
        this.nextTXByte = -1;
        this.txShiftReg = -1;
        this.transmitting = false;
        this.clrBitIFG(this.utxifg | this.urxifg);
        this.utctl |= 1;
        this.cpu.scheduleCycleEvent(this.txTrigger, this.nextTXReady);
        this.txEnabled = false;
        this.rxEnabled = false;
    }

    @Override
    public void enableChanged(int reg, int bit, boolean enabled) {
        if (bit == this.txbit) {
            this.txEnabled = enabled;
        } else {
            this.rxEnabled = enabled;
        }
    }

    private void setBitIFG(int bits) {
        this.sfr.setBitIFG(this.uartID, bits);
    }

    private void clrBitIFG(int bits) {
        this.sfr.clrBitIFG(this.uartID, bits);
    }

    private int getIFG() {
        return this.sfr.getIFG(this.uartID);
    }

    private boolean isIEBitsSet(int bits) {
        return this.sfr.isIEBitsSet(this.uartID, bits);
    }

    public void setUSARTListener(USARTListener listener) {
        this.listener = listener;
    }

    @Override
    public void write(int address, int data, boolean word, long cycles) {
        switch (address -= this.offset) {
            case 0: {
                this.uctl = data;
                this.spiMode = (data & 4) > 0;
                break;
            }
            case 1: {
                this.utctl = data;
                this.clockSource = (data >> 4 & 3) == 1 ? 1 : 2;
                this.updateBaudRate();
                break;
            }
            case 2: {
                this.urctl = data;
                break;
            }
            case 3: {
                this.umctl = data;
                break;
            }
            case 4: {
                this.ubr0 = data;
                this.updateBaudRate();
                break;
            }
            case 5: {
                this.ubr1 = data;
                this.updateBaudRate();
                break;
            }
            case 7: {
                if (this.txEnabled || this.spiMode && this.rxEnabled) {
                    this.clrBitIFG(this.utxifg);
                    this.utctl &= 0xFFFFFFFE;
                    this.nextTXByte = data;
                    if (!this.transmitting) {
                        this.nextTXReady = cycles + 3L;
                        this.cpu.scheduleCycleEvent(this.txTrigger, this.nextTXReady);
                    }
                } else {
                    System.out.println("Ignoring UTXBUF data since TX not active...");
                }
                this.utxbuf = data;
            }
        }
    }

    @Override
    public int read(int address, boolean word, long cycles) {
        switch (address -= this.offset) {
            case 0: {
                return this.uctl;
            }
            case 1: {
                return this.utctl;
            }
            case 2: {
                return this.urctl;
            }
            case 3: {
                return this.umctl;
            }
            case 4: {
                return this.ubr0;
            }
            case 5: {
                return this.ubr1;
            }
            case 7: {
                return this.utxbuf;
            }
            case 6: {
                int tmp = this.urxbuf;
                this.clrBitIFG(this.urxifg);
                if (this.listener != null) {
                    this.listener.stateChanged(1);
                }
                return tmp;
            }
        }
        return 0;
    }

    private void updateBaudRate() {
        int div = this.ubr0 + (this.ubr1 << 8);
        if (div == 0) {
            div = 1;
        }
        this.baudRate = this.clockSource == 1 ? this.cpu.aclkFrq / div : this.cpu.smclkFrq / div;
        if (this.baudRate == 0) {
            this.baudRate = 1;
        }
        this.tickPerByte = 8 * this.cpu.smclkFrq / this.baudRate;
    }

    @Override
    public String getName() {
        return "USART " + this.uartID;
    }

    @Override
    public void interruptServiced(int vector) {
    }

    private void handleTransmit(long cycles) {
        if (this.cpu.getMode() >= 4) {
            System.out.println(this.getName() + " Warning: USART transmission during LPM!!! " + this.nextTXByte);
        }
        if (this.transmitting) {
            if (this.listener != null && this.txShiftReg != -1) {
                this.listener.dataReceived(this, this.txShiftReg);
            }
            if (this.nextTXByte == -1) {
                this.utctl |= 1;
                this.transmitting = false;
                this.txShiftReg = -1;
            }
        }
        if (this.nextTXByte != -1) {
            this.txShiftReg = this.nextTXByte;
            this.nextTXByte = -1;
            this.transmitting = true;
            this.nextTXReady = cycles + (long)this.tickPerByte + 1L;
            this.cpu.scheduleCycleEvent(this.txTrigger, this.nextTXReady);
        }
        this.setBitIFG(this.utxifg);
    }

    public boolean isReceiveFlagCleared() {
        return (this.getIFG() & this.urxifg) == 0;
    }

    public void byteReceived(int b) {
        if (!this.rxEnabled) {
            return;
        }
        this.urxbuf = b & 0xFF;
        this.setBitIFG(this.urxifg);
        if (this.isIEBitsSet(this.urxifg)) {
            // empty if block
        }
    }
}

