/*
 * Decompiled with CFR 0.152.
 */
package se.sics.mspsim.core;

import se.sics.mspsim.core.IOPort;
import se.sics.mspsim.core.IOUnit;
import se.sics.mspsim.core.MSP430Core;
import se.sics.mspsim.core.TimeEvent;
import se.sics.mspsim.util.Utils;

public class Timer
extends IOUnit {
    public static final boolean DEBUG = false;
    public static final int TBIV = 286;
    public static final int TAIV = 302;
    public static final int TACCR0_VECTOR = 6;
    public static final int TACCR1_VECTOR = 5;
    public static final int TBCCR0_VECTOR = 13;
    public static final int TBCCR1_VECTOR = 12;
    public static final int TCTL = 0;
    public static final int TCCTL0 = 2;
    public static final int TCCTL1 = 4;
    public static final int TCCTL2 = 6;
    public static final int TCCTL3 = 8;
    public static final int TCCTL4 = 10;
    public static final int TCCTL5 = 12;
    public static final int TCCTL6 = 14;
    public static final int TR = 16;
    public static final int TCCR0 = 18;
    public static final int TCCR1 = 20;
    public static final int TCCR2 = 22;
    public static final int TCCR3 = 24;
    public static final int TCCR4 = 26;
    public static final int TCCR5 = 28;
    public static final int TCCR6 = 30;
    public static final int STOP = 0;
    public static final int UP = 1;
    public static final int CONTIN = 2;
    public static final int UPDWN = 3;
    public static final int CAP_NONE = 0;
    public static final int CAP_UP = 1;
    public static final int CAP_DWN = 2;
    public static final int CAP_BOTH = 3;
    public static final int TCLR = 4;
    public static final int SRC_ACLK = 0;
    public static final int SRC_MCLK = 1;
    public static final int SRC_SMCLK = 2;
    public static final int SRC_PORT = 256;
    public static final int SRC_GND = 512;
    public static final int SRC_VCC = 513;
    public static final int SRC_CAOUT = 514;
    public static final int CC_I = 8;
    public static final int CC_IFG = 1;
    public static final int CC_IE = 16;
    public static final int CC_TRIGGER_INT = 17;
    public static final int CM_NONE = 0;
    public static final int CM_RISING = 1;
    public static final int CM_FALLING = 2;
    public static final int CM_BOTH = 3;
    private final int timerOverflow;
    private long nextTimerTrigger = 0L;
    private long counterStart = 0L;
    private long counterAcc;
    private int counter = 0;
    private int counterPassed = 0;
    public static final int[] TIMER_Ax149 = new int[]{272, 0, 2, 289, 273, 290, 512, 513, 274, 514, 512, 513, 275, 0, 512, 513};
    public static final int[] TIMER_Bx149 = new int[]{327, 0, 2, 327, 320, 320, 512, 513, 321, 321, 512, 513, 322, 322, 512, 513, 323, 323, 512, 513, 324, 324, 512, 513, 325, 325, 512, 513, 326, 0, 512, 513};
    public static final String[] capNames = new String[]{"NONE", "RISING", "FALLING", "BOTH"};
    private final String name;
    private final int tiv;
    private int inputDivider = 1;
    private double cyclesMultiplicator = 1.0;
    private int clockSource;
    private int clockSpeed;
    private int mode;
    private int tctl;
    private boolean interruptEnable = false;
    private boolean interruptPending = false;
    private final int ccr1Vector;
    private final int ccr0Vector;
    private final MSP430Core core;
    private String triggerDesc = "";
    private final int noCompare;
    private CCR[] ccr = new CCR[7];
    private TimeEvent counterTrigger = new TimeEvent(0L, "Timer Counter Trigger"){

        @Override
        public void execute(long t) {
            long cycles = ((Timer)Timer.this).core.cycles;
            Timer.this.interruptPending = true;
            Timer.this.nextTimerTrigger = (long)((double)Timer.this.nextTimerTrigger + 65536.0 * Timer.this.cyclesMultiplicator);
            Timer.this.core.scheduleCycleEvent(this, Timer.this.nextTimerTrigger);
            Timer.this.triggerInterrupts(cycles);
        }
    };
    private int lastTIV;
    private final int[] srcMap;
    private long triggerTime;

    public Timer(MSP430Core core, int[] srcMap, int[] memory, int offset) {
        super(memory, offset);
        this.srcMap = srcMap;
        this.core = core;
        this.noCompare = srcMap.length / 4 - 1;
        String type = "";
        if (srcMap == TIMER_Ax149) {
            this.name = "Timer A";
            type = " A";
            this.tiv = 302;
            this.timerOverflow = 10;
            this.ccr0Vector = 6;
            this.ccr1Vector = 5;
        } else {
            type = " B";
            this.name = "Timer B";
            this.tiv = 286;
            this.timerOverflow = 14;
            this.ccr0Vector = 13;
            this.ccr1Vector = 12;
        }
        this.counterTrigger.name = this.counterTrigger.name + type;
        for (int i = 0; i < this.noCompare; ++i) {
            this.ccr[i] = new CCR(0L, "CCR" + i + type, i == 0 ? this.ccr0Vector : this.ccr1Vector, i);
        }
        this.reset(0);
    }

    @Override
    public void reset(int type) {
        int n = this.noCompare;
        for (int i = 0; i < n; ++i) {
            CCR reg = this.ccr[i];
            reg.expCompare = -1;
            reg.expCaptureTime = -1L;
            reg.expCapInterval = 0;
            reg.outMode = 0;
            reg.capMode = 0;
            reg.inputSel = 0;
            reg.inputSrc = 0;
            reg.captureOn = false;
            reg.tcctl = 0;
            reg.tccr = 0;
        }
        this.tctl = 0;
        this.lastTIV = 0;
        this.interruptEnable = false;
        this.interruptPending = false;
        this.counter = 0;
        this.counterPassed = 0;
        this.counterStart = 0L;
        this.counterAcc = 0L;
        this.clockSource = 0;
        this.cyclesMultiplicator = 1.0;
        this.mode = 0;
        this.nextTimerTrigger = 0L;
        this.inputDivider = 1;
    }

    @Override
    public int read(int address, boolean word, long cycles) {
        if (address == 302 || address == 286) {
            int val = this.lastTIV;
            this.resetTIV(cycles);
            return val;
        }
        int val = 0;
        int index = address - this.offset;
        switch (index) {
            case 16: {
                val = this.updateCounter(cycles);
                break;
            }
            case 0: {
                val = this.tctl;
                if (this.interruptPending) {
                    val |= 1;
                    break;
                }
                val &= 0xFFFE;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                int i = (index - 2) / 2;
                this.updateTCCTL(i, cycles);
                val = this.ccr[i].tcctl;
                break;
            }
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 30: {
                int i = (index - 18) / 2;
                val = this.ccr[i].tccr;
                break;
            }
            default: {
                System.out.println("Not supported read, returning zero!!!");
            }
        }
        return val & 0xFFFF;
    }

    private void updateTCCTL(int cctl, long cycles) {
        boolean input = false;
        if (this.ccr[cctl].inputSrc == 0) {
            int aTicks = this.clockSpeed / this.core.aclkFrq;
            this.updateCounter(cycles);
            if (aTicks > 0 && this.counter % aTicks > aTicks / 2) {
                input = true;
            }
        }
        this.ccr[cctl].tcctl = this.ccr[cctl].tcctl & 0xFFFFFFF7 | (input ? 8 : 0);
    }

    private void resetTIV(long cycles) {
        if (this.lastTIV == this.timerOverflow) {
            this.interruptPending = false;
            this.lastTIV = 0;
            this.triggerInterrupts(cycles);
        }
        if (this.lastTIV / 2 < this.noCompare) {
            this.ccr[this.lastTIV / 2].tcctl &= 0xFFFFFFFE;
            this.triggerInterrupts(cycles);
        }
    }

    @Override
    public void write(int address, int data, boolean word, long cycles) {
        if (address == 302 || address == 286) {
            this.resetTIV(cycles);
        }
        int iAddress = address - this.offset;
        switch (iAddress) {
            case 16: {
                this.setCounter(data, cycles);
                break;
            }
            case 0: {
                this.inputDivider = 1 << (data >> 6 & 3);
                this.clockSource = this.srcMap[data >> 8 & 3];
                this.updateCyclesMultiplicator();
                if ((data & 4) != 0) {
                    this.counter = 0;
                    this.resetCounter(cycles);
                    for (int i = 0; i < this.noCompare; ++i) {
                        this.ccr[i].updateCaptures(cycles);
                    }
                }
                int newMode = data >> 4 & 3;
                if (this.mode == 0 && newMode != 0) {
                    this.resetCounter(cycles);
                    this.nextTimerTrigger = (long)((double)cycles + this.cyclesMultiplicator * (double)(65535 - this.counter & 0xFFFF));
                    this.recalculateCompares(cycles);
                }
                this.mode = newMode;
                this.interruptEnable = (data & 2) > 0;
                this.tctl = data;
                this.tctl &= 0xFFFFFFFB;
                if ((data & 1) == 0) {
                    this.interruptPending = false;
                }
                for (int i = 0; i < this.noCompare; ++i) {
                    this.ccr[i].updateCaptures(cycles);
                }
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                int index = (iAddress - 2) / 2;
                CCR reg = this.ccr[index];
                reg.tcctl = data;
                reg.outMode = data >> 5 & 7;
                boolean oldCapture = reg.captureOn;
                reg.captureOn = (data & 0x100) > 0;
                reg.sync = (data & 0x800) > 0;
                reg.inputSel = data >> 12 & 3;
                int src = reg.inputSrc = this.srcMap[4 + index * 4 + reg.inputSel];
                reg.capMode = data >> 14 & 3;
                if (!oldCapture && reg.captureOn && (src & 0x100) != 0) {
                    int port = (src & 0xFF) >> 4;
                    int pin = src & 0xF;
                    IOPort ioPort = this.core.getIOPort(port);
                    System.out.println(this.getName() + " Assigning Port: " + port + " pin: " + pin + " for capture");
                    ioPort.setTimerCapture(this, pin);
                }
                this.updateCounter(cycles);
                this.triggerInterrupts(cycles);
                reg.updateCaptures(cycles);
                break;
            }
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 30: {
                int index = (iAddress - 18) / 2;
                this.updateCounter(cycles);
                if (index == 0) {
                    if (this.counter > data && (this.mode == 3 || this.mode == 1)) {
                        this.counter = 0;
                    }
                    this.resetCounter(cycles);
                }
                this.ccr[index].tccr = data;
                int diff = data - this.counter;
                if (diff < 0) {
                    diff += 65536;
                }
                this.ccr[index].expCaptureTime = cycles + (long)(this.cyclesMultiplicator * (double)diff + 1.0) - (long)this.counterPassed;
                this.counterPassed = 0;
                this.ccr[index].update();
            }
        }
    }

    void updateCyclesMultiplicator() {
        this.cyclesMultiplicator = this.inputDivider;
        if (this.clockSource == 0) {
            this.cyclesMultiplicator = this.cyclesMultiplicator * (double)this.core.smclkFrq / (double)this.core.aclkFrq;
        }
        this.clockSpeed = (int)((double)this.core.smclkFrq / this.cyclesMultiplicator);
    }

    void resetCounter(long cycles) {
        this.counterStart = cycles - (long)this.counterPassed;
        this.counterAcc = this.counter;
        this.updateCyclesMultiplicator();
        this.core.scheduleCycleEvent(this.counterTrigger, (long)((double)(0x100000 - this.counter) * this.cyclesMultiplicator));
    }

    private void setCounter(int newCtr, long cycles) {
        this.counter = newCtr;
        this.resetCounter(cycles);
    }

    private int updateCounter(long cycles) {
        if (this.mode == 0) {
            return this.counter;
        }
        double divider = 1.0;
        if (this.clockSource == 0) {
            divider = 1.0 * (double)this.core.smclkFrq / (double)this.core.aclkFrq;
        }
        long cycctr = cycles - this.counterStart;
        double tick = (double)cycctr / (divider *= (double)this.inputDivider);
        this.counterPassed = (int)(divider * (tick - (double)((long)tick)));
        long bigCounter = (long)(tick + (double)this.counterAcc);
        switch (this.mode) {
            case 2: {
                this.counter = (int)(bigCounter & 0xFFFFL);
                break;
            }
            case 1: {
                if (this.ccr[0].tccr == 0) {
                    this.counter = 0;
                    break;
                }
                this.counter = (int)(bigCounter % (long)this.ccr[0].tccr);
                break;
            }
            case 3: {
                if (this.ccr[0].tccr == 0) {
                    this.counter = 0;
                    break;
                }
                this.counter = (int)(bigCounter % (long)(this.ccr[0].tccr * 2));
                if (this.counter <= this.ccr[0].tccr) break;
                this.counter = 2 * this.ccr[0].tccr - this.counter;
            }
        }
        return this.counter;
    }

    private void recalculateCompares(long cycles) {
        for (int i = 0; i < this.noCompare; ++i) {
            CCR reg = this.ccr[i];
            if (reg.expCaptureTime == 0L) continue;
            int diff = reg.tccr - this.counter;
            if (diff < 0) {
                diff += 65536;
            }
            reg.expCaptureTime = cycles + (long)((double)diff * this.cyclesMultiplicator);
            reg.update();
        }
    }

    public void triggerInterrupts(long cycles) {
        boolean trigger = false;
        int tIndex = 0;
        int n = this.noCompare;
        for (int i = 0; i < n; ++i) {
            CCR reg = this.ccr[i];
            boolean newTrigger = (reg.tcctl & 0x11) == 17;
            trigger |= newTrigger;
            if (i == 0) {
                this.core.flagInterrupt(this.ccr0Vector, this, trigger);
                if (!trigger) continue;
                this.lastTIV = 0;
                this.triggerTime = cycles;
                return;
            }
            if (!newTrigger) continue;
            tIndex = i;
            break;
        }
        if (trigger) {
            this.lastTIV = this.memory[this.tiv] = tIndex * 2;
            this.triggerTime = cycles;
        }
        if (!trigger && this.interruptEnable && this.interruptPending) {
            trigger = true;
            this.lastTIV = this.memory[this.tiv] = this.timerOverflow;
        }
        this.core.flagInterrupt(this.ccr1Vector, this, trigger);
    }

    public String getSourceName(int source) {
        switch (source) {
            case 0: {
                return "ACLK";
            }
            case 513: {
                return "VCC";
            }
            case 512: {
                return "GND";
            }
            case 2: {
                return "SMCLK";
            }
        }
        if ((source & 0x100) == 256) {
            return "Port " + ((source & 0xF0) >> 4) + "." + (source & 0xF);
        }
        return "";
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void capture(int ccrIndex, int source, int value) {
        CCR reg = this.ccr[ccrIndex];
        if (ccrIndex < this.noCompare && reg.captureOn && reg.inputSel == source) {
            boolean fall;
            boolean rise = (reg.capMode & 1) != 0;
            boolean bl = fall = (reg.capMode & 2) != 0;
            if (value == 1 && rise || value == 0 && fall) {
                reg.tcctl |= 1;
                this.triggerInterrupts(this.core.cycles);
            }
        }
    }

    @Override
    public void interruptServiced(int vector) {
        if (vector == this.ccr0Vector) {
            this.core.flagInterrupt(this.ccr0Vector, this, false);
            this.ccr[0].tcctl &= 0xFFFFFFFE;
        }
        this.triggerInterrupts(this.core.cycles);
    }

    public int getModeMax() {
        return 0;
    }

    public String getName(int address) {
        int reg = address - this.offset;
        if (reg == 0) {
            return "TCTL";
        }
        if (reg < 16) {
            return "TCTL" + (reg - 2) / 2;
        }
        if (reg == 16) {
            return "TR";
        }
        if (reg < 32) {
            return "TCCR" + (reg - 18) / 2;
        }
        return " UNDEF(" + Utils.hex16(address) + ")";
    }

    private class CCR
    extends TimeEvent {
        int tcctl;
        int tccr;
        int expCompare;
        int expCapInterval;
        long expCaptureTime;
        int capMode;
        boolean captureOn;
        int inputSel;
        int inputSrc;
        boolean sync;
        int outMode;
        int interruptVector;
        int index;

        public CCR(long time, String name, int vector, int index) {
            super(time, name);
            this.captureOn = false;
            this.interruptVector = vector;
            this.index = index;
        }

        @Override
        public void execute(long t) {
            if (Timer.this.mode == 0) {
                return;
            }
            long cycles = ((Timer)Timer.this).core.cycles;
            Timer.this.updateCounter(cycles);
            if (this.expCaptureTime != -1L && cycles >= this.expCaptureTime) {
                this.tcctl |= 1;
                if (this.captureOn) {
                    this.tccr = this.expCompare;
                    this.expCompare = this.expCompare + this.expCapInterval & 0xFFFF;
                    this.expCaptureTime = (long)((double)this.expCaptureTime + (double)this.expCapInterval * Timer.this.cyclesMultiplicator);
                } else {
                    this.expCaptureTime += (long)(65536.0 * Timer.this.cyclesMultiplicator);
                }
                this.update();
                Timer.this.triggerInterrupts(cycles);
            }
        }

        public void updateCaptures(long cycles) {
            int divisor = 1;
            int frqClk = 1;
            boolean clkSource = false;
            if (Timer.this.clockSource == 2) {
                frqClk = ((Timer)Timer.this).core.smclkFrq / Timer.this.inputDivider;
            } else if (Timer.this.clockSource == 0) {
                frqClk = ((Timer)Timer.this).core.aclkFrq / Timer.this.inputDivider;
            }
            if (this.captureOn) {
                if (this.inputSrc == 0) {
                    divisor = ((Timer)Timer.this).core.aclkFrq;
                    clkSource = true;
                }
                this.expCapInterval = frqClk / divisor;
                this.expCompare = clkSource ? this.tccr + this.expCapInterval & 0xFFFF : Timer.this.counter + this.expCapInterval & 0xFFFF;
                this.expCaptureTime = cycles + (long)((double)this.expCapInterval * Timer.this.cyclesMultiplicator);
                this.update();
            }
        }

        public void update() {
            if (this.expCaptureTime != -1L && this.expCaptureTime != this.time) {
                Timer.this.core.scheduleCycleEvent(this, this.expCaptureTime);
            }
        }
    }
}

