/*
 * Decompiled with CFR 0.152.
 */
package se.sics.mspsim.core;

import se.sics.mspsim.core.IOUnit;
import se.sics.mspsim.core.MSP430Core;
import se.sics.mspsim.core.SFRModule;

public class SFR
extends IOUnit {
    private boolean DEBUG = false;
    public static final int IE1 = 0;
    public static final int IE2 = 1;
    public static final int IFG1 = 2;
    public static final int IFG2 = 3;
    public static final int ME1 = 4;
    public static final int ME2 = 5;
    private int ie1 = 0;
    private int ie2 = 0;
    private int ifg1 = 0;
    private int ifg2 = 0;
    private int me1 = 0;
    private int me2 = 0;
    private int[] memory;
    private MSP430Core cpu;
    private SFRModule[] sfrModule = new SFRModule[16];
    private int[] irqVector = new int[16];
    private boolean[] irqTriggered = new boolean[16];
    private int[] irqTriggeredPos = new int[16];

    public SFR(MSP430Core cpu, int[] memory) {
        super(memory, 0);
        this.cpu = cpu;
        this.memory = memory;
    }

    @Override
    public void reset(int type) {
        this.ie1 = 0;
        this.ie2 = 0;
        this.ifg1 = 0;
        this.ifg2 = 0;
        this.me1 = 0;
        this.me2 = 0;
        for (int i = 0; i < this.irqTriggered.length; ++i) {
            this.irqTriggered[i] = false;
        }
    }

    public void registerSFDModule(int reg, int bit, SFRModule module, int irqVec) {
        int pos = reg * 8 + bit;
        this.sfrModule[pos] = module;
        this.irqVector[pos] = irqVec;
    }

    @Override
    public void write(int address, int value, boolean word, long cycles) {
        if (this.DEBUG) {
            System.out.println(this.getName() + " write to: " + address + " = " + value);
        }
        switch (address) {
            case 0: 
            case 1: {
                this.updateIE(address - 0, value);
                break;
            }
            case 2: 
            case 3: {
                this.updateIFG(address - 2, value);
                break;
            }
            case 4: 
            case 5: {
                this.updateME(address - 4, value);
            }
            default: {
                this.memory[address] = value;
            }
        }
    }

    @Override
    public int read(int address, boolean word, long cycles) {
        if (this.DEBUG) {
            System.out.println(this.getName() + " read from: " + address);
        }
        switch (address) {
            case 0: {
                return this.ie1;
            }
            case 1: {
                return this.ie2;
            }
            case 2: {
                return this.ifg1;
            }
            case 3: {
                return this.ifg2;
            }
            case 4: {
                return this.me1;
            }
            case 5: {
                return this.me2;
            }
        }
        return this.memory[address];
    }

    private void updateIE(int pos, int value) {
        int oldVal = pos == 0 ? this.ie1 : this.ie2;
        int change = oldVal ^ value;
        if (pos == 0) {
            this.ie1 = value;
        } else {
            this.ie2 = value;
        }
        this.updateIRQ(pos, change);
    }

    private void updateIFG(int pos, int value) {
        int oldVal = pos == 0 ? this.ifg1 : this.ifg2;
        int change = oldVal ^ value;
        if (pos == 0) {
            this.ifg1 = value;
        } else {
            this.ifg2 = value;
        }
        this.updateIRQ(pos, change);
    }

    private void updateME(int pos, int value) {
        int oldVal = pos == 0 ? this.me1 : this.me2;
        int change = oldVal ^ value;
        if (pos == 0) {
            this.me1 = value;
        } else {
            this.me2 = value;
        }
        int reg = pos;
        pos *= 8;
        for (int i = 0; i < 8; ++i) {
            if ((change & 1) == 1 && this.sfrModule[pos] != null) {
                if (this.DEBUG) {
                    System.out.println("Calling enable changed on module: " + this.sfrModule[pos].getName() + " enabled = " + (value & 1) + " bit " + i);
                }
                this.sfrModule[pos].enableChanged(reg, i, (value & 1) > 0);
            }
            change >>= 1;
            value >>= 1;
            ++pos;
        }
    }

    private void updateIRQ(int pos, int change) {
        int ifg = pos == 0 ? this.ifg1 : this.ifg2;
        int ie = pos == 0 ? this.ie1 : this.ie2;
        pos *= 8;
        for (int i = 0; i < 8; ++i) {
            if ((change & 1) == 1 && this.sfrModule[pos] != null && !this.irqTriggered[this.irqVector[pos]]) {
                if (this.DEBUG) {
                    System.out.println("SFR: flagging interrupt: " + this.sfrModule[pos].getName() + " pos: " + pos + " " + (ie & ifg & 1) + " chg: " + change);
                }
                if ((ie & ifg & 1) > 0) {
                    int vector = this.irqVector[pos];
                    this.irqTriggered[vector] = true;
                    this.irqTriggeredPos[vector] = pos;
                    this.cpu.flagInterrupt(this.irqVector[pos], this, true);
                }
            }
            ++pos;
            change >>= 1;
            ifg >>= 1;
            ie >>= 1;
        }
    }

    public void setBitIFG(int index, int bits) {
        int value = index == 0 ? this.ifg1 : this.ifg2;
        int after = value | bits;
        int change = value ^ after;
        if (index == 0) {
            this.ifg1 = after;
        } else {
            this.ifg2 = after;
        }
        this.updateIRQ(index, change);
    }

    public void clrBitIFG(int index, int bits) {
        int value = index == 0 ? this.ifg1 : this.ifg2;
        int after = value & ~bits;
        int change = value ^ after;
        if (index == 0) {
            this.ifg1 = after;
        } else {
            this.ifg2 = after;
        }
        this.updateIRQ(index, change);
    }

    public boolean isIEBitsSet(int index, int flags) {
        if (index == 0) {
            return (this.ie1 & flags) == flags;
        }
        return (this.ie2 & flags) == flags;
    }

    public int getIFG(int index) {
        if (index == 0) {
            return this.ifg1;
        }
        return this.ifg2;
    }

    @Override
    public void interruptServiced(int vector) {
        this.irqTriggered[vector] = false;
        int pos = this.irqTriggeredPos[vector];
        int bit = pos & 7;
        if (pos > 8) {
            this.ifg1 &= ~(1 << bit);
        } else {
            this.ifg2 &= ~(1 << bit);
        }
        this.cpu.flagInterrupt(vector, this, false);
        if (this.sfrModule[pos] != null) {
            this.sfrModule[pos].interruptServiced(vector);
        }
    }

    @Override
    public String getName() {
        return "SpecialFunctionRegister, SFR";
    }
}

