/*
 * Decompiled with CFR 0.152.
 */
package se.sics.mspsim.core;

import se.sics.mspsim.core.IOUnit;
import se.sics.mspsim.core.MSP430Core;

public class Multiplier
extends IOUnit {
    public static final boolean DEBUG = false;
    public static final int MPY = 304;
    public static final int MPYS = 306;
    public static final int MAC = 308;
    public static final int MACS = 310;
    public static final int OP2 = 312;
    public static final int RESLO = 314;
    public static final int RESHI = 316;
    public static final int SUMEXT = 318;
    private int mpy;
    private int mpys;
    private int op2;
    private int resLo;
    private int resHi;
    private int mac;
    private int macs;
    private int sumext;
    private int op1;
    MSP430Core core;
    private boolean signed = false;
    private boolean accumulating = false;

    public Multiplier(MSP430Core core, int[] memory, int offset) {
        super(memory, offset);
        this.core = core;
    }

    @Override
    public int read(int address, boolean word, long cycles) {
        switch (address) {
            case 304: {
                return this.mpy;
            }
            case 306: {
                return this.mpys;
            }
            case 308: {
                return this.mac;
            }
            case 310: {
                return this.macs;
            }
            case 312: {
                return this.op2;
            }
            case 316: {
                return this.resHi;
            }
            case 314: {
                return this.resLo;
            }
            case 318: {
                return this.sumext;
            }
        }
        System.out.println(this.getName() + " read other address:" + address);
        return 0;
    }

    @Override
    public void write(int address, int data, boolean word, long cycles) {
        switch (address) {
            case 304: {
                this.op1 = this.mpy = data;
                this.signed = false;
                this.accumulating = false;
                break;
            }
            case 306: {
                this.op1 = this.mpys = data;
                this.signed = true;
                this.accumulating = false;
                break;
            }
            case 308: {
                this.op1 = this.mac = data;
                this.signed = false;
                this.accumulating = true;
                break;
            }
            case 310: {
                this.op1 = this.macs = data;
                this.signed = true;
                this.accumulating = true;
                break;
            }
            case 314: {
                this.resLo = data;
                break;
            }
            case 316: {
                this.resHi = data;
                break;
            }
            case 312: {
                this.sumext = 0;
                this.op2 = data;
                if (this.signed) {
                    if (!word) {
                        if (this.op1 > 128) {
                            this.op1 |= 0xFF00;
                        }
                        if (this.op2 > 128) {
                            this.op2 |= 0xFF00;
                        }
                    }
                    this.op1 = this.op1 > 32768 ? this.op1 - 65536 : this.op1;
                    this.op2 = this.op2 > 32768 ? this.op2 - 65536 : this.op2;
                }
                long res = (long)this.op1 * (long)this.op2;
                if (this.signed) {
                    int n = this.sumext = res < 0L ? 65535 : 0;
                }
                if (this.accumulating) {
                    res += ((long)this.resHi << 16) + (long)this.resLo;
                    if (!this.signed) {
                        this.sumext = res > 0xFFFFFFFFL ? 1 : 0;
                    }
                } else if (!this.signed) {
                    this.sumext = 0;
                }
                this.resHi = (int)(res >> 16 & 0xFFFFL);
                this.resLo = (int)(res & 0xFFFFL);
            }
        }
    }

    @Override
    public String getName() {
        return "Hardware Multiplier";
    }

    @Override
    public void interruptServiced(int vector) {
    }
}

