/*
 * Decompiled with CFR 0.152.
 */
package se.sics.mspsim.core;

import java.io.PrintStream;
import java.util.ArrayList;
import se.sics.mspsim.core.ADC12;
import se.sics.mspsim.core.BasicClockModule;
import se.sics.mspsim.core.CPUMonitor;
import se.sics.mspsim.core.Chip;
import se.sics.mspsim.core.EmulationException;
import se.sics.mspsim.core.EmulationLogger;
import se.sics.mspsim.core.EventQueue;
import se.sics.mspsim.core.Flash;
import se.sics.mspsim.core.FlashRange;
import se.sics.mspsim.core.IOPort;
import se.sics.mspsim.core.IOUnit;
import se.sics.mspsim.core.InterruptHandler;
import se.sics.mspsim.core.MSP430Constants;
import se.sics.mspsim.core.Multiplier;
import se.sics.mspsim.core.Profiler;
import se.sics.mspsim.core.SFR;
import se.sics.mspsim.core.TimeEvent;
import se.sics.mspsim.core.Timer;
import se.sics.mspsim.core.USART;
import se.sics.mspsim.core.Watchdog;
import se.sics.mspsim.util.ComponentRegistry;
import se.sics.mspsim.util.MapEntry;
import se.sics.mspsim.util.MapTable;
import se.sics.mspsim.util.Utils;

public class MSP430Core
extends Chip
implements MSP430Constants {
    public static final int RETURN = 16688;
    public static final boolean DEBUG = false;
    public static final boolean debugInterrupts = false;
    public static final boolean EXCEPTION_ON_BAD_OPERATION = true;
    public static final int MAX_MEM = 65536;
    public static final int MAX_MEM_IO = 512;
    public static final int PORTS = 6;
    public int[] reg = new int[16];
    public CPUMonitor[] regWriteMonitors = new CPUMonitor[16];
    public CPUMonitor[] regReadMonitors = new CPUMonitor[16];
    public CPUMonitor[] breakPoints = new CPUMonitor[65536];
    boolean breakpointActive = true;
    public int[] memory = new int[65536];
    public long cycles = 0L;
    public long cpuCycles = 0L;
    MapTable map;
    public IOUnit[] memOut = new IOUnit[512];
    public IOUnit[] memIn = new IOUnit[512];
    private IOUnit[] ioUnits;
    private SFR sfr;
    private InterruptHandler[] interruptSource = new IOUnit[16];
    protected int interruptMax = -1;
    private int op;
    public int instruction;
    int servicedInterrupt = -1;
    InterruptHandler servicedInterruptUnit = null;
    protected boolean interruptsEnabled = false;
    protected boolean cpuOff = false;
    protected int dcoFrq = 2500000;
    int aclkFrq = 32768;
    int smclkFrq = this.dcoFrq;
    long lastCyclesTime = 0L;
    long lastVTime = 0L;
    long currentTime = 0L;
    long lastMicrosDelta;
    double currentDCOFactor = 1.0;
    private int clkACaptureMode = 0;
    long nextEventCycles;
    private EventQueue vTimeEventQueue = new EventQueue();
    private long nextVTimeEventCycles;
    private EventQueue cycleEventQueue = new EventQueue();
    private long nextCycleEventCycles;
    private BasicClockModule bcs;
    private ArrayList<Chip> chips = new ArrayList();
    ComponentRegistry registry;
    Profiler profiler;
    private Flash flash;

    public MSP430Core(int type, ComponentRegistry registry) {
        int i;
        int i2;
        int i3;
        this.setModeNames(MODE_NAMES);
        this.registry = registry;
        int passIO = 0;
        this.ioUnits = new IOUnit[13];
        Timer ta = new Timer(this, Timer.TIMER_Ax149, this.memory, 352);
        Timer tb = new Timer(this, Timer.TIMER_Bx149, this.memory, 384);
        int n = 32;
        for (int i4 = 0; i4 < n; ++i4) {
            this.memOut[352 + i4] = ta;
            this.memOut[384 + i4] = tb;
            this.memIn[352 + i4] = ta;
            this.memIn[384 + i4] = tb;
        }
        Watchdog wdt = new Watchdog(this);
        this.memOut[288] = wdt;
        this.memIn[288] = wdt;
        this.flash = new Flash(this, this.memory, new FlashRange(16384, 65536, 512, 64), new FlashRange(4096, 4352, 128, 64));
        for (i3 = 296; i3 < 302; ++i3) {
            this.memOut[i3] = this.flash;
            this.memIn[i3] = this.flash;
        }
        this.sfr = new SFR(this, this.memory);
        int n2 = 16;
        for (i3 = 0; i3 < n2; ++i3) {
            this.memOut[i3] = this.sfr;
            this.memIn[i3] = this.sfr;
        }
        this.memIn[302] = ta;
        this.memOut[302] = ta;
        this.memIn[286] = tb;
        this.memOut[286] = tb;
        this.bcs = new BasicClockModule(this, this.memory, 0, new Timer[]{ta, tb});
        n2 = 89;
        for (i3 = 86; i3 < n2; ++i3) {
            this.memOut[i3] = this.bcs;
        }
        Multiplier mp = new Multiplier(this, this.memory, 0);
        int n3 = 319;
        for (int i5 = 304; i5 < n3; ++i5) {
            this.memOut[i5] = mp;
            this.memIn[i5] = mp;
        }
        USART usart0 = new USART(this, this.memory, 112);
        USART usart1 = new USART(this, this.memory, 120);
        int n4 = 8;
        for (i2 = 0; i2 < n4; ++i2) {
            this.memOut[112 + i2] = usart0;
            this.memIn[112 + i2] = usart0;
            this.memOut[120 + i2] = usart1;
            this.memIn[120 + i2] = usart1;
        }
        this.ioUnits[0] = new IOPort(this, "1", 4, this.memory, 32);
        this.ioUnits[1] = new IOPort(this, "2", 1, this.memory, 40);
        n4 = 8;
        for (i2 = 0; i2 < n4; ++i2) {
            this.memOut[32 + i2] = this.ioUnits[0];
            this.memOut[40 + i2] = this.ioUnits[1];
        }
        n4 = 2;
        for (i2 = 0; i2 < n4; ++i2) {
            this.ioUnits[i2 + 2] = new IOPort(this, "" + (3 + i2), 0, this.memory, 24 + i2 * 4);
            this.memOut[24 + i2 * 4] = this.ioUnits[i2 + 2];
            this.memOut[25 + i2 * 4] = this.ioUnits[i2 + 2];
            this.memOut[26 + i2 * 4] = this.ioUnits[i2 + 2];
            this.memOut[27 + i2 * 4] = this.ioUnits[i2 + 2];
            this.ioUnits[i2 + 4] = new IOPort(this, "" + (5 + i2), 0, this.memory, 48 + i2 * 4);
            this.memOut[48 + i2 * 4] = this.ioUnits[i2 + 4];
            this.memOut[49 + i2 * 4] = this.ioUnits[i2 + 4];
            this.memOut[50 + i2 * 4] = this.ioUnits[i2 + 4];
            this.memOut[51 + i2 * 4] = this.ioUnits[i2 + 4];
        }
        passIO = 6;
        this.ioUnits[passIO++] = this.bcs;
        this.ioUnits[passIO++] = usart0;
        this.ioUnits[passIO++] = usart1;
        this.ioUnits[passIO++] = ta;
        this.ioUnits[passIO++] = tb;
        ADC12 adc12 = new ADC12(this);
        this.ioUnits[passIO++] = adc12;
        this.ioUnits[passIO++] = this.sfr;
        int n5 = 16;
        for (i = 0; i < n5; ++i) {
            this.memOut[128 + i] = adc12;
            this.memIn[128 + i] = adc12;
            this.memOut[320 + i] = adc12;
            this.memIn[320 + i] = adc12;
            this.memOut[336 + i] = adc12;
            this.memIn[336 + i] = adc12;
        }
        n5 = 8;
        for (i = 0; i < n5; ++i) {
            this.memOut[416 + i] = adc12;
            this.memIn[416 + i] = adc12;
        }
    }

    public Profiler getProfiler() {
        return this.profiler;
    }

    public void setProfiler(Profiler prof) {
        this.registry.registerComponent("profiler", prof);
        this.profiler = prof;
        this.profiler.setCPU(this);
    }

    public IOPort getIOPort(int portID) {
        if (portID > 0 && portID < 7) {
            return (IOPort)this.ioUnits[portID - 1];
        }
        return null;
    }

    public SFR getSFR() {
        return this.sfr;
    }

    public void addChip(Chip chip) {
        this.chips.add(chip);
        chip.setEmulationLogger(this.logger);
    }

    public Chip getChip(String name) {
        for (Chip chip : this.chips) {
            if (!name.equals(chip.getName())) continue;
            return chip;
        }
        return null;
    }

    public Chip getChip(Class<? extends Chip> type) {
        for (Chip chip : this.chips) {
            if (!type.isInstance(chip)) continue;
            return chip;
        }
        return null;
    }

    public Chip[] getChips() {
        return this.chips.toArray(new Chip[this.chips.size()]);
    }

    public void setBreakPoint(int address, CPUMonitor mon) {
        this.breakPoints[address] = mon;
    }

    public boolean hasBreakPoint(int address) {
        return this.breakPoints[address] != null;
    }

    public void clearBreakPoint(int address) {
        this.breakPoints[address] = null;
    }

    public void setRegisterWriteMonitor(int r, CPUMonitor mon) {
        this.regWriteMonitors[r] = mon;
    }

    public void setRegisterReadMonitor(int r, CPUMonitor mon) {
        this.regReadMonitors[r] = mon;
    }

    public int[] getMemory() {
        return this.memory;
    }

    public void writeRegister(int r, int value) {
        if (this.regWriteMonitors[r] != null) {
            this.regWriteMonitors[r].cpuAction(4, r, value);
        }
        this.reg[r] = value;
        if (r == 2) {
            boolean oldCpuOff = this.cpuOff;
            boolean oldIE = this.interruptsEnabled;
            boolean bl = this.interruptsEnabled = (value & 8) == 8;
            if (!oldIE && this.interruptsEnabled && this.servicedInterrupt >= 0) {
                this.handlePendingInterrupts();
            }
            boolean bl2 = this.cpuOff = (value & 0x10) == 16;
            if (this.cpuOff != oldCpuOff) {
                // empty if block
            }
            if (this.cpuOff) {
                boolean oscoff;
                boolean scg0 = (value & 0x40) == 64;
                boolean scg1 = (value & 0x80) == 128;
                boolean bl3 = oscoff = (value & 0x20) == 32;
                if (oscoff && scg1 && scg0) {
                    this.setMode(5);
                } else if (scg1 && scg0) {
                    this.setMode(4);
                } else if (scg1) {
                    this.setMode(3);
                } else if (scg0) {
                    this.setMode(2);
                } else {
                    this.setMode(1);
                }
            } else {
                this.setMode(0);
            }
        }
    }

    public int readRegister(int r) {
        if (this.regReadMonitors[r] != null) {
            this.regReadMonitors[r].cpuAction(3, r, this.reg[r]);
        }
        return this.reg[r];
    }

    public int readRegisterCG(int r, int m) {
        if (r == 2 && m != 0 || r == 3) {
            return CREG_VALUES[r - 2][m];
        }
        if (this.regReadMonitors[r] != null) {
            this.regReadMonitors[r].cpuAction(3, r, this.reg[r]);
        }
        return this.reg[r];
    }

    public int incRegister(int r, int value) {
        if (this.regReadMonitors[r] != null) {
            this.regReadMonitors[r].cpuAction(3, r, this.reg[r]);
        }
        if (this.regWriteMonitors[r] != null) {
            this.regWriteMonitors[r].cpuAction(4, r, this.reg[r] + value);
        }
        int n = r;
        this.reg[n] = this.reg[n] + value;
        return this.reg[r];
    }

    public void setACLKFrq(int frequency) {
        this.aclkFrq = frequency;
    }

    public void setDCOFrq(int frequency, int smclkFrq) {
        this.dcoFrq = frequency;
        this.smclkFrq = smclkFrq;
        this.lastVTime = this.getTime();
        this.lastCyclesTime = this.cycles;
        this.lastMicrosDelta = 0L;
        this.currentDCOFactor = 4915200.0 / (double)frequency;
        this.dcoReset();
    }

    protected void dcoReset() {
    }

    public long getTime() {
        long diff = this.cycles - this.lastCyclesTime;
        return this.lastVTime + (long)((double)diff * this.currentDCOFactor);
    }

    private long convertVTime(long vTime) {
        long tmpTime = this.lastCyclesTime + (long)((double)(vTime - this.lastVTime) / this.currentDCOFactor);
        return tmpTime;
    }

    public double getTimeMillis() {
        return 1000.0 * (double)this.getTime() / 4915200.0;
    }

    private void executeEvents() {
        TimeEvent te;
        if (this.cycles >= this.nextVTimeEventCycles) {
            if (this.vTimeEventQueue.eventCount == 0) {
                this.nextVTimeEventCycles = this.cycles + 10000L;
            } else {
                te = this.vTimeEventQueue.popFirst();
                long now = this.getTime();
                te.execute(now);
                this.nextVTimeEventCycles = this.vTimeEventQueue.eventCount > 0 ? this.convertVTime(this.vTimeEventQueue.nextTime) : this.cycles + 10000L;
            }
        }
        if (this.cycles >= this.nextCycleEventCycles) {
            if (this.cycleEventQueue.eventCount == 0) {
                this.nextCycleEventCycles = this.cycles + 10000L;
            } else {
                te = this.cycleEventQueue.popFirst();
                te.execute(this.cycles);
                this.nextCycleEventCycles = this.cycleEventQueue.eventCount > 0 ? this.cycleEventQueue.nextTime : this.cycles + 10000L;
            }
        }
        this.nextEventCycles = this.nextCycleEventCycles < this.nextVTimeEventCycles ? this.nextCycleEventCycles : this.nextVTimeEventCycles;
    }

    public void scheduleCycleEvent(TimeEvent event, long cycles) {
        long currentNext = this.cycleEventQueue.nextTime;
        this.cycleEventQueue.addEvent(event, cycles);
        if (currentNext != this.cycleEventQueue.nextTime) {
            this.nextCycleEventCycles = this.cycleEventQueue.nextTime;
            if (this.nextEventCycles > this.nextCycleEventCycles) {
                this.nextEventCycles = this.nextCycleEventCycles;
            }
        }
    }

    public void scheduleTimeEvent(TimeEvent event, long time) {
        long currentNext = this.vTimeEventQueue.nextTime;
        this.vTimeEventQueue.addEvent(event, time);
        if (currentNext != this.vTimeEventQueue.nextTime) {
            this.nextVTimeEventCycles = this.convertVTime(this.vTimeEventQueue.nextTime);
            if (this.nextEventCycles > this.nextVTimeEventCycles) {
                this.nextEventCycles = this.nextVTimeEventCycles;
            }
            if (this.cycles > this.nextVTimeEventCycles) {
                this.logger.warning(this, "Scheduling time event backwards in time!!!");
                throw new IllegalStateException("Cycles are passed desired future time...");
            }
        }
    }

    public long scheduleTimeEventMillis(TimeEvent event, double msec) {
        long time = (long)((double)this.getTime() + msec / 1000.0 * 4915200.0);
        this.scheduleTimeEvent(event, time);
        return time;
    }

    public void printEventQueues(PrintStream out) {
        out.println("Current cycles: " + this.cycles + "  virtual time:" + this.getTime());
        out.println("Cycle event queue: (next time: " + this.nextCycleEventCycles + ")");
        this.cycleEventQueue.print(out);
        out.println("Virtual time event queue: (next time: " + this.nextVTimeEventCycles + ")");
        this.vTimeEventQueue.print(out);
    }

    public IOUnit getIOUnit(String name) {
        int n = this.ioUnits.length;
        for (int i = 0; i < n; ++i) {
            if (!name.equals(this.ioUnits[i].getName())) continue;
            return this.ioUnits[i];
        }
        return null;
    }

    private void resetIOUnits() {
        int n = this.ioUnits.length;
        for (int i = 0; i < n; ++i) {
            this.ioUnits[i].reset(1);
        }
    }

    private void internalReset() {
        int n = 16;
        for (int i = 0; i < n; ++i) {
            this.interruptSource[i] = null;
        }
        this.servicedInterruptUnit = null;
        this.servicedInterrupt = -1;
        this.interruptMax = -1;
        this.writeRegister(2, 0);
        this.cycleEventQueue.removeAll();
        this.vTimeEventQueue.removeAll();
        this.bcs.reset();
        this.resetIOUnits();
        if (this.profiler != null) {
            this.profiler.clearProfile();
        }
    }

    public void setWarningMode(EmulationLogger.WarningMode mode) {
        if (this.logger != null) {
            this.logger.setWarningMode(mode);
        }
    }

    public void reset() {
        this.flagInterrupt(15, null, true);
    }

    public void flagInterrupt(int interrupt, InterruptHandler source, boolean triggerIR) {
        if (triggerIR) {
            this.interruptSource[interrupt] = source;
            if (interrupt > this.interruptMax) {
                this.interruptMax = interrupt;
                if (this.interruptMax == 15) {
                    this.interruptsEnabled = true;
                }
            }
        } else if (this.interruptSource[interrupt] == source) {
            this.interruptSource[interrupt] = null;
            this.reevaluateInterrupts();
        }
    }

    private void reevaluateInterrupts() {
        this.interruptMax = -1;
        for (int i = 0; i < this.interruptSource.length; ++i) {
            if (this.interruptSource[i] == null) continue;
            this.interruptMax = i;
        }
    }

    public int getServicedInterrupt() {
        return this.servicedInterrupt;
    }

    public void handlePendingInterrupts() {
        this.reevaluateInterrupts();
        this.servicedInterrupt = -1;
        this.servicedInterruptUnit = null;
    }

    public int read(int address, boolean word) throws EmulationException {
        int val = 0;
        if (address < 511 && this.memIn[address] != null) {
            val = this.memIn[address].read(address, word, this.cycles);
        } else {
            if (this.flash.addressInFlash(address &= 0xFFFF)) {
                this.flash.notifyRead(address);
            }
            val = this.memory[address] & 0xFF;
            if (word) {
                val |= this.memory[address + 1 & 0xFFFF] << 8;
                if ((address & 1) != 0) {
                    this.printWarning(0, address);
                }
            }
        }
        if (this.breakPoints[address] != null) {
            this.breakPoints[address].cpuAction(1, address, val);
        }
        return val;
    }

    public void write(int dstAddress, int dst, boolean word) throws EmulationException {
        if (this.breakPoints[dstAddress] != null) {
            this.breakPoints[dstAddress].cpuAction(2, dstAddress, dst);
        }
        if (dstAddress < 511 && this.memOut[dstAddress] != null) {
            if (!word) {
                dst &= 0xFF;
            }
            this.memOut[dstAddress].write(dstAddress, dst, word, this.cycles);
        } else if (this.flash.addressInFlash(dstAddress)) {
            this.flash.flashWrite(dstAddress, dst, word);
        } else {
            this.memory[dstAddress] = dst & 0xFF;
            if (word) {
                this.memory[dstAddress + 1] = dst >> 8 & 0xFF;
                if ((dstAddress & 1) != 0) {
                    this.printWarning(1, dstAddress);
                }
            }
        }
    }

    void printWarning(int type, int address) throws EmulationException {
        String message = null;
        switch (type) {
            case 0: {
                message = "**** Illegal read - misaligned word from $" + Utils.hex16(address) + " at $" + Utils.hex16(this.reg[0]);
                break;
            }
            case 1: {
                message = "**** Illegal write - misaligned word to $" + Utils.hex16(address) + " at $" + Utils.hex16(this.reg[0]);
            }
        }
        if (this.logger != null && message != null) {
            this.logger.warning(this, message);
        }
    }

    public void generateTrace(PrintStream out) {
    }

    private int serviceInterrupt(int pc) {
        int spBefore;
        int pcBefore = pc;
        int sp = spBefore = this.readRegister(1);
        int sr = this.readRegister(2);
        if (this.profiler != null) {
            this.profiler.profileInterrupt(this.interruptMax, this.cycles);
        }
        if (this.flash.blocksCPU()) {
            throw new IllegalStateException("Got interrupt while flash controller blocks CPU. CPU CRASHED.");
        }
        if (this.interruptMax < 15) {
            sp = spBefore - 2;
            this.writeRegister(1, sp);
            this.memory[sp] = pc & 0xFF;
            this.memory[sp + 1] = pc >> 8 & 0xFF;
            this.writeRegister(1, sp -= 2);
            this.memory[sp] = sr & 0xFF;
            this.memory[sp + 1] = sr >> 8 & 0xFF;
        }
        this.writeRegister(2, 0);
        pc = this.memory[65504 + this.interruptMax * 2] + (this.memory[65504 + this.interruptMax * 2 + 1] << 8);
        this.writeRegister(0, pc);
        this.servicedInterrupt = this.interruptMax;
        this.servicedInterruptUnit = this.interruptSource[this.servicedInterrupt];
        this.reevaluateInterrupts();
        if (this.servicedInterrupt == 15) {
            this.internalReset();
        }
        this.cycles += 6L;
        if (this.servicedInterruptUnit != null) {
            this.servicedInterruptUnit.interruptServiced(this.servicedInterrupt);
        }
        return pc;
    }

    public boolean emulateOP(long maxCycles) throws EmulationException {
        int pc = this.readRegister(0);
        long startCycles = this.cycles;
        if (this.interruptsEnabled && this.servicedInterrupt == -1 && this.interruptMax >= 0) {
            pc = this.serviceInterrupt(pc);
        }
        if (this.cpuOff || this.flash.blocksCPU()) {
            while (this.cycles >= this.nextEventCycles) {
                this.executeEvents();
            }
            this.cycles = maxCycles >= 0L && maxCycles < this.nextEventCycles ? (this.cycles < maxCycles ? maxCycles : this.cycles) : this.nextEventCycles;
            return false;
        }
        if (this.breakPoints[pc] != null) {
            if (this.breakpointActive) {
                this.breakPoints[pc].cpuAction(5, pc, 0);
                this.breakpointActive = false;
                return false;
            }
            this.breakpointActive = true;
        }
        this.instruction = this.memory[pc] + (this.memory[pc + 1] << 8);
        this.op = this.instruction >> 12;
        int sp = 0;
        int sr = 0;
        boolean word = (this.instruction & 0x40) == 0;
        int dstRegister = 0;
        int dstAddress = -1;
        boolean dstRegMode = false;
        int dst = 0;
        boolean write = false;
        boolean updateStatus = true;
        this.writeRegister(0, pc += 2);
        block0 : switch (this.op) {
            case 1: {
                dstRegister = this.instruction & 0xF;
                int ad = this.instruction >> 4 & 3;
                int nxtCarry = 0;
                this.op = this.instruction & 0xFF80;
                if (this.op == 4608 || this.op == 4736) {
                    sp = this.readRegister(1) - 2;
                    this.writeRegister(1, sp);
                }
                if (dstRegister == 2 && ad > 1 || dstRegister == 3) {
                    dstRegMode = true;
                    ++this.cycles;
                } else {
                    switch (ad) {
                        case 0: {
                            dstRegMode = true;
                            ++this.cycles;
                            break;
                        }
                        case 1: {
                            dstAddress = this.readRegisterCG(dstRegister, ad) + this.memory[pc] + (this.memory[pc + 1] << 8);
                            this.writeRegister(0, pc += 2);
                            this.cycles += 4L;
                            break;
                        }
                        case 2: {
                            dstAddress = this.readRegister(dstRegister);
                            this.cycles += 3L;
                            break;
                        }
                        case 3: {
                            if (dstRegister == 0) {
                                dstAddress = this.readRegister(0);
                                this.writeRegister(0, pc += 2);
                            } else {
                                dstAddress = this.readRegister(dstRegister);
                                this.writeRegister(dstRegister, dstAddress + (word ? 2 : 1));
                            }
                            this.cycles += 3L;
                        }
                    }
                }
                if (dstRegMode) {
                    dst = this.readRegisterCG(dstRegister, ad);
                    if (!word) {
                        dst &= 0xFF;
                    }
                } else {
                    dst = this.read(dstAddress, word);
                }
                switch (this.op) {
                    case 4096: {
                        nxtCarry = (dst & 1) > 0 ? 1 : 0;
                        dst >>= 1;
                        dst = word ? (dst |= (this.readRegister(2) & 1) > 0 ? 32768 : 0) : (dst |= (this.readRegister(2) & 1) > 0 ? 128 : 0);
                        write = true;
                        this.writeRegister(2, this.readRegister(2) & 0xFFFFFEFE | nxtCarry);
                        break block0;
                    }
                    case 4224: {
                        int tmp = dst;
                        dst = (tmp >> 8 & 0xFF) + (tmp << 8 & 0xFF00);
                        write = true;
                        break block0;
                    }
                    case 4352: {
                        nxtCarry = (dst & 1) > 0 ? 1 : 0;
                        dst = word ? dst & 0x8000 | dst >> 1 : dst & 0x80 | dst >> 1;
                        write = true;
                        this.writeRegister(2, this.readRegister(2) & 0xFFFFFEFE | nxtCarry);
                        break block0;
                    }
                    case 4480: {
                        sr = this.readRegister(2);
                        dst = (dst & 0x80) > 0 ? dst | 0xFF00 : dst & 0x7F;
                        write = true;
                        sr &= 0xFFFFFEFE;
                        if (dst != 0) {
                            sr |= 1;
                        }
                        this.writeRegister(2, sr);
                        break block0;
                    }
                    case 4608: {
                        if (word) {
                            this.memory[sp] = dst & 0xFF;
                            this.memory[sp + 1] = dst >> 8;
                        } else {
                            this.memory[sp] = dst & 0xFF;
                            this.memory[sp + 1] = 0;
                        }
                        this.cycles += ad == 0 || ad == 3 ? 2L : 1L;
                        write = false;
                        updateStatus = false;
                        break block0;
                    }
                    case 4736: {
                        pc = this.readRegister(0);
                        this.memory[sp] = pc & 0xFF;
                        this.memory[sp + 1] = pc >> 8;
                        this.writeRegister(0, dst);
                        this.cycles += ad == 0 ? 3L : (ad == 3 ? 2L : 1L);
                        if (this.profiler != null) {
                            MapEntry function = this.map.getEntry(dst);
                            if (function == null) {
                                function = this.getFunction(this.map, dst);
                            }
                            this.profiler.profileCall(function, this.cpuCycles);
                        }
                        write = false;
                        updateStatus = false;
                        break block0;
                    }
                    case 4864: {
                        this.servicedInterrupt = -1;
                        sp = this.readRegister(1);
                        this.writeRegister(2, this.memory[sp++] + (this.memory[sp++] << 8));
                        this.writeRegister(0, this.memory[sp++] + (this.memory[sp++] << 8));
                        this.writeRegister(1, sp);
                        write = false;
                        updateStatus = false;
                        this.cycles += 4L;
                        if (this.profiler != null) {
                            this.profiler.profileRETI(this.cycles);
                        }
                        this.handlePendingInterrupts();
                        break block0;
                    }
                }
                System.out.println("Error: Not implemented instruction:" + this.instruction);
                break;
            }
            case 2: 
            case 3: {
                int jmpOffset = this.instruction & 0x3FF;
                jmpOffset = (jmpOffset & 0x200) == 0 ? 2 * jmpOffset : -(2 * (512 - (jmpOffset & 0x1FF)));
                boolean jump = false;
                this.cycles += 2L;
                sr = this.readRegister(2);
                switch (this.instruction & 0xFC00) {
                    case 8192: {
                        jump = (sr & 2) == 0;
                        break;
                    }
                    case 9216: {
                        jump = (sr & 2) > 0;
                        break;
                    }
                    case 10240: {
                        jump = (sr & 1) == 0;
                        break;
                    }
                    case 11264: {
                        jump = (sr & 1) > 0;
                        break;
                    }
                    case 12288: {
                        jump = (sr & 4) > 0;
                        break;
                    }
                    case 13312: {
                        jump = (sr & 4) > 0 == (sr & 0x100) > 0;
                        break;
                    }
                    case 14336: {
                        jump = (sr & 4) > 0 != (sr & 0x100) > 0;
                        break;
                    }
                    case 15360: {
                        jump = true;
                        break;
                    }
                    default: {
                        System.out.println("Not implemented instruction: " + Utils.binary16(this.instruction));
                    }
                }
                if (jump) {
                    this.writeRegister(0, pc + jmpOffset);
                }
                updateStatus = false;
                break;
            }
            default: {
                dstRegister = this.instruction & 0xF;
                int srcRegister = this.instruction >> 8 & 0xF;
                int as = this.instruction >> 4 & 3;
                dstRegMode = (this.instruction >> 7 & 1) == 0;
                dstAddress = -1;
                int srcAddress = -1;
                int src = 0;
                if (srcRegister == 2 && as > 1 || srcRegister == 3) {
                    src = CREG_VALUES[srcRegister - 2][as];
                    if (!word) {
                        src &= 0xFF;
                    }
                    this.cycles += dstRegMode ? 1L : 4L;
                } else {
                    switch (as) {
                        case 0: {
                            src = this.readRegister(srcRegister);
                            if (!word) {
                                src &= 0xFF;
                            }
                            this.cycles += dstRegMode ? 1L : 4L;
                            if (dstRegister != 0) break;
                            ++this.cycles;
                            break;
                        }
                        case 1: {
                            srcAddress = this.readRegisterCG(srcRegister, as) + this.memory[pc] + (this.memory[pc + 1] << 8);
                            this.incRegister(0, 2);
                            this.cycles += dstRegMode ? 3L : 6L;
                            break;
                        }
                        case 2: {
                            srcAddress = this.readRegister(srcRegister);
                            this.cycles += dstRegMode ? 2L : 5L;
                            break;
                        }
                        case 3: {
                            if (srcRegister == 0) {
                                srcAddress = this.readRegister(0);
                                pc += 2;
                                this.incRegister(0, 2);
                                this.cycles += dstRegMode ? 2L : 5L;
                            } else {
                                srcAddress = this.readRegister(srcRegister);
                                this.incRegister(srcRegister, word ? 2 : 1);
                                this.cycles += dstRegMode ? 2L : 5L;
                            }
                            if (dstRegister != 0) break;
                            ++this.cycles;
                        }
                    }
                }
                if (dstRegMode) {
                    if (this.op != 4) {
                        dst = this.readRegister(dstRegister);
                        if (!word) {
                            dst &= 0xFF;
                        }
                    }
                } else {
                    pc = this.readRegister(0);
                    dstAddress = dstRegister == 2 ? this.memory[pc] + (this.memory[pc + 1] << 8) : this.readRegister(dstRegister) + this.memory[pc] + (this.memory[pc + 1] << 8);
                    if (this.op != 4) {
                        dst = this.read(dstAddress, word);
                    }
                    pc += 2;
                    this.incRegister(0, 2);
                }
                if (srcAddress != -1) {
                    src = this.read(srcAddress &= 0xFFFF, word);
                }
                int tmp = 0;
                int tmpAdd = 0;
                switch (this.op) {
                    case 4: {
                        dst = src;
                        write = true;
                        updateStatus = false;
                        if (this.instruction != 16688 || this.profiler == null) break block0;
                        this.profiler.profileReturn(this.cpuCycles);
                        break block0;
                    }
                    case 8: {
                        tmpAdd = 1;
                    }
                    case 7: {
                        src = (src ^ 0xFFFF) & 0xFFFF;
                    }
                    case 6: {
                        if (this.op == 6 || this.op == 7) {
                            tmpAdd = (this.readRegister(2) & 1) > 0 ? 1 : 0;
                        }
                    }
                    case 5: {
                        sr = this.readRegister(2);
                        sr &= 0xFFFFFEFE;
                        tmp = (src ^ dst) & (word ? 32768 : 128);
                        dst = dst + src + tmpAdd;
                        if (dst > (word ? 65535 : 255)) {
                            sr |= 1;
                        }
                        if (tmp == 0 && ((src ^ dst) & (word ? 32768 : 128)) != 0) {
                            sr |= 0x100;
                        }
                        this.writeRegister(2, sr);
                        write = true;
                        break block0;
                    }
                    case 9: {
                        int b = word ? 32768 : 128;
                        sr = this.readRegister(2);
                        sr = sr & 0xFFFFFEFE | (dst >= src ? 1 : 0);
                        tmp = dst - src;
                        if (((src ^ tmp) & b) == 0 && ((src ^ dst) & b) != 0) {
                            sr |= 0x100;
                        }
                        this.writeRegister(2, sr);
                        dst = tmp;
                        break block0;
                    }
                    case 10: {
                        dst = dst + src + ((this.readRegister(2) & 1) > 0 ? 1 : 0);
                        write = true;
                        break block0;
                    }
                    case 11: {
                        dst = src & dst;
                        sr = this.readRegister(2);
                        sr &= 0xFFFFFEFE;
                        if (dst != 0) {
                            sr |= 1;
                        }
                        this.writeRegister(2, sr);
                        break block0;
                    }
                    case 12: {
                        dst = ~src & dst;
                        write = true;
                        updateStatus = false;
                        break block0;
                    }
                    case 13: {
                        dst = src | dst;
                        write = true;
                        updateStatus = false;
                        break block0;
                    }
                    case 14: {
                        sr = this.readRegister(2);
                        sr &= 0xFFFFFEFE;
                        if ((src & (word ? 32768 : 128)) != 0 && (dst & (word ? 32768 : 128)) != 0) {
                            sr |= 0x100;
                        }
                        if ((dst = src ^ dst) != 0) {
                            sr |= 1;
                        }
                        write = true;
                        this.writeRegister(2, sr);
                        break block0;
                    }
                    case 15: {
                        sr = this.readRegister(2);
                        sr &= 0xFFFFFEFE;
                        dst = src & dst;
                        if (dst != 0) {
                            sr |= 1;
                        }
                        write = true;
                        this.writeRegister(2, sr);
                        break block0;
                    }
                    default: {
                        System.out.println("DoubleOperand not implemented: " + this.op + " at " + pc);
                        EmulationException ex = new EmulationException("Bad operation: " + this.op + " at " + pc);
                        ex.initCause(new Throwable("" + pc));
                        throw ex;
                    }
                }
            }
        }
        dst = word ? (dst &= 0xFFFF) : (dst &= 0xFF);
        if (write) {
            if (dstRegMode) {
                this.writeRegister(dstRegister, dst);
            } else {
                this.write(dstAddress &= 0xFFFF, dst, word);
            }
        }
        if (updateStatus) {
            sr = this.readRegister(2);
            sr = sr & 0xFFFFFFF9 | (dst == 0 ? 2 : 0) | (word ? ((dst & 0x8000) > 0 ? 4 : 0) : ((dst & 0x80) > 0 ? 4 : 0));
            this.writeRegister(2, sr);
        }
        while (this.cycles >= this.nextEventCycles) {
            this.executeEvents();
        }
        this.cpuCycles += this.cycles - startCycles;
        return true;
    }

    @Override
    public String getName() {
        return "MSP430 Core";
    }

    @Override
    public int getModeMax() {
        return 5;
    }

    MapEntry getFunction(MapTable map, int address) {
        MapEntry function = new MapEntry(MapEntry.TYPE.function, address, 0, "fkn at $" + Utils.hex16(address), null, true);
        map.setEntry(function);
        return function;
    }

    public int getPC() {
        return this.reg[0];
    }
}

