/*
 * Decompiled with CFR 0.152.
 */
package se.sics.mspsim.core;

import java.io.PrintStream;
import se.sics.mspsim.core.DisAsm;
import se.sics.mspsim.core.EmulationException;
import se.sics.mspsim.core.MSP430Core;
import se.sics.mspsim.core.SimEvent;
import se.sics.mspsim.core.SimEventListener;
import se.sics.mspsim.util.ArrayUtils;
import se.sics.mspsim.util.ComponentRegistry;
import se.sics.mspsim.util.MapTable;
import se.sics.mspsim.util.SimpleProfiler;

public class MSP430
extends MSP430Core {
    public static final int RETURN = 16688;
    private int[] execCounter;
    private int[] trace;
    private int tracePos;
    private boolean debug = false;
    private boolean running = false;
    private long sleepRate = 50000L;
    private long lastCycles = 0L;
    private long lastCpuCycles = 0L;
    private long time;
    private long nextSleep = 0L;
    private long nextOut = 0L;
    private double lastCPUPercent = 0.0;
    private long instCtr = 0L;
    private DisAsm disAsm = new DisAsm();
    private SimEventListener[] simEventListeners;
    long lastReturnedMicros;
    long lastMicrosCycles;
    boolean microClockReady = false;
    long maxCycles = 0L;

    public MSP430(int type, ComponentRegistry registry) {
        super(type, registry);
        this.addChip(this);
    }

    public double getCPUPercent() {
        return this.lastCPUPercent;
    }

    public DisAsm getDisAsm() {
        return this.disAsm;
    }

    public void cpuloop() throws EmulationException {
        if (this.isRunning()) {
            throw new IllegalStateException("already running");
        }
        this.setRunning(true);
        this.time = System.currentTimeMillis();
        this.run();
    }

    private void run() throws EmulationException {
        while (this.isRunning()) {
            if (this.debug) {
                if (this.servicedInterrupt >= 0) {
                    this.disAsm.disassemble(this.reg[0], this.memory, this.reg, this.servicedInterrupt);
                } else {
                    this.disAsm.disassemble(this.reg[0], this.memory, this.reg);
                }
            }
            if (this.cycles > this.nextOut && !this.debug) {
                this.printCPUSpeed(this.reg[0]);
                this.nextOut = this.cycles + 20000007L;
            }
            if (this.emulateOP(-1L)) {
                ++this.instCtr;
                if (this.execCounter != null) {
                    int n = this.reg[0];
                    this.execCounter[n] = this.execCounter[n] + 1;
                }
                if (this.trace != null) {
                    this.trace[this.tracePos++] = this.reg[0];
                    if (this.tracePos >= this.trace.length) {
                        this.tracePos = 0;
                    }
                }
            }
            if (this.cycles <= this.nextSleep) continue;
            try {
                Thread.sleep(10L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.nextSleep = this.cycles + this.sleepRate;
        }
    }

    public long step() throws EmulationException {
        return this.stepMicros(1L, 1L);
    }

    public long stepInstructions(int count) throws EmulationException {
        if (this.isRunning()) {
            throw new IllegalStateException("step not possible when CPU is running");
        }
        this.setRunning(true);
        while (count-- > 0 && this.isRunning()) {
            boolean emuOP;
            if (this.debug) {
                if (this.servicedInterrupt >= 0) {
                    this.disAsm.disassemble(this.reg[0], this.memory, this.reg, this.servicedInterrupt);
                } else {
                    this.disAsm.disassemble(this.reg[0], this.memory, this.reg);
                }
            }
            if (!(emuOP = this.emulateOP(-1L))) continue;
            if (this.execCounter != null) {
                int n = this.reg[0];
                this.execCounter[n] = this.execCounter[n] + 1;
            }
            if (this.trace == null) continue;
            this.trace[this.tracePos++] = this.reg[0];
            if (this.tracePos <= this.trace.length) continue;
            this.tracePos = 0;
        }
        this.setRunning(false);
        return this.cycles;
    }

    @Override
    protected void dcoReset() {
        this.microClockReady = false;
    }

    public long stepMicros(long jumpMicros, long executeMicros) throws EmulationException {
        if (this.isRunning()) {
            throw new IllegalStateException("step not possible when CPU is running");
        }
        if (jumpMicros < 0L) {
            throw new IllegalArgumentException("Can not jump a negative time: " + jumpMicros);
        }
        if (!this.microClockReady) {
            this.lastMicrosCycles = this.maxCycles;
        }
        this.lastMicrosDelta += jumpMicros;
        if (this.microClockReady) {
            this.maxCycles = this.lastMicrosCycles + this.lastMicrosDelta * (long)this.dcoFrq / 1000000L;
            if (this.cpuOff) {
                if (this.maxCycles > this.nextEventCycles) {
                    this.lastMicrosDelta -= jumpMicros;
                    this.printEventQueues(System.out);
                    throw new IllegalArgumentException("Jumping to a time that is further than possible in LPM maxCycles:" + this.maxCycles + " cycles: " + this.cycles + " nextEventCycles: " + this.nextEventCycles);
                }
            } else if (this.maxCycles > this.cycles) {
                this.lastMicrosDelta -= jumpMicros;
                throw new IllegalArgumentException("Jumping to a time that is further than possible not LPM maxCycles:" + this.maxCycles + " cycles: " + this.cycles);
            }
        }
        this.microClockReady = true;
        this.maxCycles = this.lastMicrosCycles + (this.lastMicrosDelta + executeMicros) * (long)this.dcoFrq / 1000000L;
        if (this.debug) {
            if (this.servicedInterrupt >= 0) {
                this.disAsm.disassemble(this.reg[0], this.memory, this.reg, this.servicedInterrupt);
            } else {
                this.disAsm.disassemble(this.reg[0], this.memory, this.reg);
            }
        }
        boolean emuOP = false;
        while (this.cycles < this.maxCycles || this.cpuOff && this.nextEventCycles < this.cycles) {
            emuOP = this.emulateOP(this.maxCycles);
            if (!emuOP) continue;
            if (this.execCounter != null) {
                int n = this.reg[0];
                this.execCounter[n] = this.execCounter[n] + 1;
            }
            if (this.trace == null) continue;
            if (this.tracePos > this.trace.length) {
                this.tracePos = 0;
            }
            this.trace[this.tracePos++] = this.reg[0];
        }
        this.lastReturnedMicros = this.cpuOff && (!this.interruptsEnabled || this.servicedInterrupt != -1 || this.interruptMax < 0) ? 1000000L * (this.nextEventCycles - this.cycles) / (long)this.dcoFrq : 0L;
        if (this.cycles < this.maxCycles) {
            throw new RuntimeException("cycles < maxCycles : " + this.cycles + " < " + this.maxCycles);
        }
        if (this.lastReturnedMicros < 0L) {
            throw new RuntimeException("lastReturnedMicros < 0 : " + this.lastReturnedMicros);
        }
        return this.lastReturnedMicros;
    }

    public void stop() {
        this.setRunning(false);
    }

    public int getExecCount(int address) {
        if (this.execCounter != null) {
            return this.execCounter[address];
        }
        return 0;
    }

    public void setMonitorExec(boolean mon) {
        if (mon) {
            if (this.execCounter == null) {
                this.execCounter = new int[65536];
            }
        } else {
            this.execCounter = null;
        }
    }

    public void setTrace(int size) {
        this.trace = (int[])(size == 0 ? null : new int[size]);
        this.tracePos = 0;
    }

    public int getBackTrace(int pos) {
        int tPos = this.tracePos - pos;
        if (tPos < 0) {
            tPos += this.trace.length;
        }
        return this.trace[tPos];
    }

    public int getTraceSize() {
        return this.trace == null ? 0 : this.trace.length;
    }

    private void printCPUSpeed(int pc) {
        int td = (int)(System.currentTimeMillis() - this.time);
        long cd = this.cycles - this.lastCycles;
        long cpud = this.cpuCycles - this.lastCpuCycles;
        if (td == 0 || cd == 0L) {
            return;
        }
        this.lastCPUPercent = (double)(10000L * cpud / cd) / 100.0;
        this.time = System.currentTimeMillis();
        this.lastCycles = this.cycles;
        this.lastCpuCycles = this.cpuCycles;
    }

    @Override
    public void generateTrace(PrintStream out) {
        if (this.profiler != null && out != null) {
            this.profiler.printStackTrace(out);
        }
    }

    public boolean getDebug() {
        return this.debug;
    }

    public void setDebug(boolean db) {
        this.debug = db;
    }

    public void setMap(MapTable map) {
        this.map = map;
        if (this.profiler == null) {
            this.setProfiler(new SimpleProfiler());
            this.profiler.setCPU(this);
        }
    }

    public void setRunning(boolean running) {
        if (this.running != running) {
            this.running = running;
            SimEventListener[] listeners = this.simEventListeners;
            if (listeners != null) {
                SimEvent.Type type = running ? SimEvent.Type.START : SimEvent.Type.STOP;
                SimEvent event = new SimEvent(type);
                for (SimEventListener l : listeners) {
                    l.simChanged(event);
                }
            }
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public long getSleepRate() {
        return this.sleepRate;
    }

    public void setSleepRate(long rate) {
        this.sleepRate = rate;
    }

    public synchronized void addSimEventListener(SimEventListener l) {
        this.simEventListeners = (SimEventListener[])ArrayUtils.add(SimEventListener.class, this.simEventListeners, l);
    }

    public synchronized void removeSimEventListener(SimEventListener l) {
        this.simEventListeners = (SimEventListener[])ArrayUtils.remove(this.simEventListeners, l);
    }
}

