/*
 * Decompiled with CFR 0.152.
 */
package se.sics.mspsim.core;

import se.sics.mspsim.core.IOUnit;
import se.sics.mspsim.core.MSP430Core;
import se.sics.mspsim.core.PortListener;
import se.sics.mspsim.core.Timer;

public class IOPort
extends IOUnit {
    public static final int PIN_LOW = 0;
    public static final int PIN_HI = 1;
    public static final boolean DEBUG = false;
    public static final String[] iNames = new String[]{"P_IN", "P_OUT", "P_DIR", "P_IFG", "P_IES", "P_IE", "P_SEL"};
    public static final String[] names = new String[]{"P_IN", "P_OUT", "P_DIR", "P_SEL"};
    private String name;
    private int interrupt;
    private int interruptFlag;
    private int interruptEnable;
    private MSP430Core cpu;
    private int[] pinState = new int[8];
    public static final int IN = 0;
    public static final int OUT = 1;
    public static final int DIR = 2;
    public static final int SEL = 3;
    public static final int IFG = 3;
    public static final int IES = 4;
    public static final int IE = 5;
    public static final int ISEL = 6;
    private PortListener listener;
    private int dirReg;
    private int out;
    private Timer[] timerCapture = new Timer[8];

    public IOPort(MSP430Core cpu, String portName, int interrupt, int[] memory, int offset) {
        super(memory, offset);
        this.name = portName;
        this.interrupt = interrupt;
        this.interruptEnable = 0;
        this.cpu = cpu;
    }

    public void setPortListener(PortListener listener) {
        this.listener = listener;
    }

    public void setTimerCapture(Timer timer, int pin) {
        System.out.println("Setting timer capture for pin: " + pin);
        this.timerCapture[pin] = timer;
    }

    @Override
    public int read(int address, boolean word, long cycles) {
        int val = this.memory[address];
        if (word) {
            val |= this.memory[address + 1 & 0xFFFF] << 8;
        }
        return val;
    }

    @Override
    public void write(int address, int data, boolean word, long cycles) {
        this.memory[address] = data & 0xFF;
        if (word) {
            this.memory[address + 1] = data >> 8 & 0xFF;
        }
        int iAddress = address - this.offset;
        switch (iAddress) {
            case 0: {
                break;
            }
            case 1: {
                this.out = data;
                if (this.listener == null) break;
                this.listener.portWrite(this, this.out | ~this.dirReg & 0xFF);
                break;
            }
            case 2: {
                this.dirReg = data;
                if (this.listener == null) break;
                this.listener.portWrite(this, this.out | ~this.dirReg & 0xFF);
                break;
            }
            case 3: {
                if (this.interrupt <= 0) break;
                this.interruptFlag &= data;
                this.memory[this.offset + 3] = this.interruptFlag;
                this.cpu.flagInterrupt(this.interrupt, this, (this.interruptFlag & this.interruptEnable) > 0);
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                this.interruptEnable = data;
                break;
            }
        }
    }

    @Override
    public String getName() {
        return "Port " + this.name;
    }

    @Override
    public void interruptServiced(int vector) {
    }

    public void setPinState(int pin, int state) {
        if (this.pinState[pin] != state) {
            this.pinState[pin] = state;
            int bit = 1 << pin;
            if (state == 1) {
                int n = 0 + this.offset;
                this.memory[n] = this.memory[n] | bit;
            } else {
                int n = 0 + this.offset;
                this.memory[n] = this.memory[n] & ~bit;
            }
            if (this.interrupt > 0) {
                if ((this.memory[this.offset + 4] & bit) == 0) {
                    if (state == 1) {
                        this.interruptFlag |= bit;
                    }
                } else if (state == 0) {
                    this.interruptFlag |= bit;
                }
                this.memory[this.offset + 3] = this.interruptFlag;
                this.cpu.flagInterrupt(this.interrupt, this, (this.interruptFlag & this.interruptEnable) > 0);
            }
            if (this.timerCapture[pin] != null) {
                this.timerCapture[pin].capture(pin, 0, state);
            }
        }
    }

    @Override
    public void reset(int type) {
        int n = 8;
        for (int i = 0; i < n; ++i) {
            this.pinState[i] = 0;
        }
        this.interruptFlag = 0;
        this.interruptEnable = 0;
        this.cpu.flagInterrupt(this.interrupt, this, (this.interruptFlag & this.interruptEnable) > 0);
    }
}

