/*
 * Decompiled with CFR 0.152.
 */
package se.sics.mspsim.core;

import se.sics.mspsim.core.FlashRange;
import se.sics.mspsim.core.IOUnit;
import se.sics.mspsim.core.MSP430Core;
import se.sics.mspsim.core.SFR;
import se.sics.mspsim.core.TimeEvent;
import se.sics.mspsim.util.Utils;

public class Flash
extends IOUnit {
    private static final boolean DEBUG = true;
    private static final int FCTL1 = 296;
    private static final int FCTL2 = 298;
    private static final int FCTL3 = 300;
    private static final int FRKEY = 38400;
    private static final int FWKEY = 42240;
    private static final int KEYMASK = 65280;
    private static final int CMDMASK = 255;
    private static final int BLKWRT = 128;
    private static final int WRT = 64;
    private static final int ERASE_SHIFT = 1;
    private static final int ERASE_MASK = 6;
    private static final int EMEX = 32;
    private static final int LOCK = 16;
    private static final int WAIT = 8;
    private static final int ACCVIFG = 4;
    private static final int KEYV = 2;
    private static final int BUSY = 1;
    private static final int FSSEL_SHIFT = 6;
    private static final int FSSEL_MASK = 192;
    private static final int RESET_VECTOR = 15;
    private static final int NMI_VECTOR = 14;
    private static final int ACCVIE = 32;
    private static final int MASS_ERASE_TIME = 5297;
    private static final int SEGMENT_ERASE_TIME = 4819;
    private static final int WRITE_TIME = 35;
    private static final int BLOCKWRITE_FIRST_TIME = 30;
    private static final int BLOCKWRITE_TIME = 21;
    private static final int BLOCKWRITE_END_TIME = 6;
    private static final int FN_MASK = 63;
    private MSP430Core cpu;
    private SFR sfr;
    private FlashRange main_range;
    private FlashRange info_range;
    private int[] memory;
    private int mode;
    private int clockcfg;
    private int statusreg;
    private boolean locked;
    private boolean busy;
    private boolean wait;
    private boolean blocked_cpu;
    private EraseMode current_erase;
    private WriteMode current_write_mode;
    private int blockwrite_count;
    private TimeEvent end_process = new TimeEvent(0L){

        @Override
        public void execute(long t) {
            Flash.this.blocked_cpu = false;
            switch (Flash.this.current_erase) {
                case ERASE_NONE: {
                    break;
                }
                case ERASE_SEGMENT: 
                case ERASE_MAIN: 
                case ERASE_ALL: {
                    Flash.this.mode = 0;
                    Flash.this.current_erase = EraseMode.ERASE_NONE;
                    Flash.this.busy = false;
                }
            }
            switch (Flash.this.current_write_mode) {
                case WRITE_NONE: {
                    break;
                }
                case WRITE_SINGLE: {
                    Flash.this.mode = 0;
                    Flash.this.busy = false;
                    Flash.this.current_write_mode = WriteMode.WRITE_NONE;
                    break;
                }
                case WRITE_BLOCK: {
                    Flash.this.blockwrite_count++;
                    if (Flash.this.blockwrite_count == 64) {
                        System.out.printf("Last access in block mode. Forced exit?", new Object[0]);
                        Flash.this.current_write_mode = WriteMode.WRITE_BLOCK_FINISH;
                    }
                    Flash.this.wait = true;
                    break;
                }
                case WRITE_BLOCK_FINISH: {
                    System.out.println("Programming voltage dropped, write mode disabled.");
                    Flash.this.current_write_mode = WriteMode.WRITE_NONE;
                    Flash.this.busy = false;
                    Flash.this.wait = true;
                    Flash.this.mode = 0;
                }
            }
        }
    };

    public Flash(MSP430Core cpu, int[] memory, FlashRange main_range, FlashRange info_range) {
        super(memory, 296);
        this.cpu = cpu;
        this.memory = memory;
        this.main_range = main_range;
        this.info_range = info_range;
        this.sfr = cpu.getSFR();
        this.locked = true;
        this.reset(1);
    }

    public boolean blocksCPU() {
        return this.blocked_cpu;
    }

    @Override
    public String getName() {
        return "Flash";
    }

    @Override
    public void interruptServiced(int vector) {
        this.cpu.flagInterrupt(vector, this, false);
    }

    public boolean addressInFlash(int address) {
        if (this.main_range.isInRange(address)) {
            return true;
        }
        return this.info_range.isInRange(address);
    }

    private int getFlashClockDiv() {
        return (this.clockcfg & 0x3F) + 1;
    }

    private void waitFlashProcess(int time) {
        int instr_addr = this.cpu.readRegister(0);
        int freqdiv = this.getFlashClockDiv();
        this.busy = true;
        if (this.addressInFlash(instr_addr)) {
            this.blocked_cpu = true;
        }
        switch (this.getClockSource()) {
            case ACLK: {
                int myfreq = this.cpu.aclkFrq / freqdiv;
                double finish_msec = (double)time * (double)freqdiv * 1000.0 / (double)this.cpu.aclkFrq;
                System.out.println("Flash: Using ACLK source with f=" + myfreq + " Hz\nFlasg: Time required=" + finish_msec + " ms");
                this.cpu.scheduleTimeEventMillis(this.end_process, finish_msec);
                break;
            }
            case SMCLK: {
                int myfreq = this.cpu.smclkFrq / freqdiv;
                double finish_msec = (double)time * (double)freqdiv * 1000.0 / (double)this.cpu.smclkFrq;
                this.cpu.scheduleTimeEventMillis(this.end_process, finish_msec);
                break;
            }
            case MCLK: {
                System.out.println("Flash: Using MCLK source with div=" + freqdiv);
                this.cpu.scheduleCycleEvent(this.end_process, (long)time * (long)freqdiv);
            }
        }
    }

    public boolean needsTick() {
        return false;
    }

    public void flashWrite(int address, int data, boolean word) {
        int wait_time = -1;
        if (this.locked) {
            System.out.println("Write to flash blocked because of LOCK flag.");
            return;
        }
        if (!(!this.busy && this.wait || (this.mode & 0x80) != 0 && this.wait)) {
            this.triggerAccessViolation("Flash write prohbited while BUSY=1 or WAIT=0");
            return;
        }
        switch (this.current_erase) {
            case ERASE_SEGMENT: {
                int[] a_area_start = new int[1];
                int[] a_area_end = new int[1];
                this.getSegmentRange(address, a_area_start, a_area_end);
                int area_start = a_area_start[0];
                int area_end = a_area_end[0];
                System.out.println("Segment erase @" + Utils.hex16(address) + ": erasing area " + Utils.hex16(area_start) + "-" + Utils.hex16(area_end));
                for (int i = area_start; i < area_end; ++i) {
                    this.memory[i] = 255;
                }
                this.waitFlashProcess(4819);
                return;
            }
            case ERASE_MAIN: {
                if (!this.main_range.isInRange(address)) {
                    return;
                }
                for (int i = this.main_range.start; i < this.main_range.end; ++i) {
                    this.memory[i] = 255;
                }
                this.waitFlashProcess(5297);
                return;
            }
            case ERASE_ALL: {
                int i;
                for (i = this.main_range.start; i < this.main_range.end; ++i) {
                    this.memory[i] = 255;
                }
                for (i = this.info_range.start; i < this.main_range.end; ++i) {
                    this.memory[i] = 255;
                }
                this.waitFlashProcess(5297);
                return;
            }
        }
        switch (this.current_write_mode) {
            case WRITE_BLOCK: {
                this.wait = false;
                if (this.blockwrite_count == 0) {
                    wait_time = 30;
                    System.out.println("Flash write in block mode started @" + Utils.hex16(address));
                    if (!this.addressInFlash(this.cpu.readRegister(0))) break;
                    System.out.println("Oops. Block write access only allowed when executing from RAM.");
                    break;
                }
                wait_time = 21;
                break;
            }
            case WRITE_SINGLE: {
                wait_time = 35;
            }
        }
        int n = address;
        this.memory[n] = this.memory[n] & (data & 0xFF);
        if (word) {
            int n2 = address + 1;
            this.memory[n2] = this.memory[n2] & (data >> 8 & 0xFF);
        }
        if (wait_time < 0) {
            throw new RuntimeException("Wait time not properly initialized");
        }
        this.waitFlashProcess(wait_time);
    }

    public void notifyRead(int address) {
        if (this.busy) {
            this.triggerAccessViolation("Flash read not allowed while BUSY flag set");
            return;
        }
        if (!this.wait && this.current_write_mode == WriteMode.WRITE_BLOCK) {
            System.out.println("Reading flash prohibited. Would read 0x3fff!!!\nCPU PC=" + Utils.hex16(this.cpu.readRegister(0)) + " read address=" + Utils.hex16(address));
        }
    }

    private FlashRange getFlashRange(int address) {
        if (this.main_range.isInRange(address)) {
            return this.main_range;
        }
        if (this.info_range.isInRange(address)) {
            return this.info_range;
        }
        return null;
    }

    private void getSegmentRange(int address, int[] start, int[] end) {
        FlashRange addr_type = this.getFlashRange(address);
        if (addr_type == null) {
            throw new RuntimeException("Address not in flash");
        }
        int segsize = addr_type.segment_size;
        int ioffset = address - addr_type.start;
        ioffset /= segsize;
        start[0] = addr_type.start + (ioffset *= segsize);
        end[0] = start[0] + segsize;
    }

    @Override
    public int read(int address, boolean word, long cycles) {
        if (address == 296) {
            return this.mode | 0x9600;
        }
        if (address == 298) {
            return this.clockcfg | 0x9600;
        }
        if (address == 300) {
            int retval = this.statusreg | 0x9600;
            if (this.busy) {
                retval |= 1;
            }
            if (this.locked) {
                retval |= 0x10;
            }
            if (this.wait) {
                retval |= 8;
            }
            return retval;
        }
        return 0;
    }

    private ClockSource getClockSource() {
        switch ((this.clockcfg & 0xC0) >> 6) {
            case 0: {
                return ClockSource.ACLK;
            }
            case 1: {
                return ClockSource.MCLK;
            }
            case 2: 
            case 3: {
                return ClockSource.SMCLK;
            }
        }
        throw new RuntimeException("Bad clock source");
    }

    private boolean checkKey(int value) {
        if ((value & 0xFF00) == 42240) {
            return true;
        }
        System.out.println("Bad key accessing flash controller --> reset");
        this.statusreg |= 2;
        this.cpu.flagInterrupt(15, this, true);
        return false;
    }

    private void triggerEmergencyExit() {
        this.mode = 0;
        this.busy = false;
        this.wait = true;
        this.locked = true;
        this.current_erase = EraseMode.ERASE_NONE;
        this.current_write_mode = WriteMode.WRITE_NONE;
    }

    private EraseMode getEraseMode(int regdata) {
        int idx = (regdata & 6) >> 1;
        for (EraseMode em : EraseMode.values()) {
            if (em.ordinal() != idx) continue;
            return em;
        }
        throw new RuntimeException("Invalid erase mode");
    }

    private void triggerErase(int newmode) {
        this.current_erase = this.getEraseMode(newmode);
    }

    private void triggerLockFlash() {
        this.locked = true;
    }

    private void triggerUnlockFlash() {
        this.locked = false;
    }

    private void triggerAccessViolation(String reason) {
        System.out.println("Flash access violation: " + reason + "\nPC=" + Utils.hex16(this.cpu.readRegister(0)));
        this.statusreg |= 4;
        if (this.sfr.isIEBitsSet(0, 32)) {
            this.cpu.flagInterrupt(14, this, true);
        }
    }

    private void triggerSingleWrite() {
        this.current_write_mode = WriteMode.WRITE_SINGLE;
    }

    private void triggerBlockWrite() {
        System.out.println("Block write triggered");
        this.current_write_mode = WriteMode.WRITE_BLOCK;
        this.blockwrite_count = 0;
    }

    private void triggerEndBlockWrite() {
        System.out.println("Got end of flash block write");
        this.current_write_mode = WriteMode.WRITE_BLOCK_FINISH;
        this.waitFlashProcess(6);
    }

    @Override
    public void write(int address, int value, boolean word, long cycles) {
        if (!word) {
            System.out.println("Invalid access type to flash controller");
            return;
        }
        if (address != 296 && address != 298 && address != 300) {
            return;
        }
        if (!this.checkKey(value)) {
            return;
        }
        int regdata = value & 0xFF;
        switch (address) {
            case 296: {
                if (!((this.mode & 6) == 0 && (this.mode & 0x40) == 0 || (this.mode & 0x80) != 0 && this.wait)) {
                    this.triggerAccessViolation("FCTL1 write not allowed while erase/write active.");
                    return;
                }
                if ((this.mode & 6) != (regdata & 6)) {
                    if ((this.mode & 6) == 0) {
                        this.triggerErase(regdata);
                    }
                    this.mode &= 0xFFFFFFF9;
                    this.mode |= regdata & 6;
                }
                if ((this.mode & 0x40) != (regdata & 0x40) && (regdata & 0x40) != 0) {
                    if ((regdata & 0x80) != 0) {
                        this.triggerBlockWrite();
                        this.mode |= 0x80;
                    } else {
                        this.triggerSingleWrite();
                    }
                    this.mode &= 0xFFFFFFBF;
                    this.mode |= regdata & 0x40;
                }
                if ((this.mode & 0x80) == 0 || (regdata & 0x80) != 0) break;
                this.triggerEndBlockWrite();
                this.mode &= 0xFFFFFF7F;
                break;
            }
            case 298: {
                if (this.busy) {
                    this.triggerAccessViolation("Register write to FCTL2 not allowed when busy");
                    return;
                }
                this.clockcfg = regdata;
                break;
            }
            case 300: {
                if ((this.statusreg & 0x20) == 0 && (regdata & 0x20) == 1) {
                    this.triggerEmergencyExit();
                }
                if (this.locked && (regdata & 0x10) == 0) {
                    this.triggerUnlockFlash();
                } else if (!this.locked && (regdata & 0x10) != 0) {
                    this.triggerLockFlash();
                }
                if (((this.statusreg ^ regdata) & 2) != 0) {
                    this.statusreg ^= 2;
                }
                if (((this.statusreg ^ regdata) & 4) == 0) break;
                this.statusreg ^= 4;
            }
        }
    }

    @Override
    public void reset(int type) {
        System.out.println("Flash got reset!");
        if (type == 1) {
            this.statusreg = 0;
        }
        this.mode = 0;
        this.clockcfg = 66;
        this.busy = false;
        this.wait = true;
        this.locked = true;
        this.current_erase = EraseMode.ERASE_NONE;
        this.current_write_mode = WriteMode.WRITE_NONE;
    }

    private static enum ClockSource {
        ACLK,
        MCLK,
        SMCLK;

    }

    private static enum WriteMode {
        WRITE_NONE,
        WRITE_SINGLE,
        WRITE_BLOCK,
        WRITE_BLOCK_FINISH;

    }

    private static enum EraseMode {
        ERASE_NONE,
        ERASE_SEGMENT,
        ERASE_MAIN,
        ERASE_ALL;

    }
}

