/*
 * Decompiled with CFR 0.152.
 */
package se.sics.mspsim.core;

import java.io.PrintStream;
import se.sics.mspsim.core.TimeEvent;

public class EventQueue {
    private TimeEvent first;
    public long nextTime;
    public int eventCount = 0;

    public void addEvent(TimeEvent event, long time) {
        event.time = time;
        this.addEvent(event);
    }

    public void addEvent(TimeEvent event) {
        if (event.scheduledIn != null) {
            event.remove();
        }
        if (this.first == null) {
            this.first = event;
        } else {
            TimeEvent pos = this.first;
            TimeEvent lastPos = this.first;
            while (pos != null && pos.time < event.time) {
                lastPos = pos;
                pos = pos.nextEvent;
            }
            if (pos == this.first) {
                event.nextEvent = pos;
                this.first = event;
            } else {
                event.nextEvent = pos;
                lastPos.nextEvent = event;
            }
        }
        this.nextTime = this.first != null ? this.first.time : 0L;
        event.scheduledIn = this;
        ++this.eventCount;
    }

    public boolean removeEvent(TimeEvent event) {
        TimeEvent pos = this.first;
        TimeEvent lastPos = this.first;
        while (pos != null && pos != event) {
            lastPos = pos;
            pos = pos.nextEvent;
        }
        if (pos == null) {
            return false;
        }
        if (pos == this.first) {
            this.first = pos.nextEvent;
        } else {
            lastPos.nextEvent = pos.nextEvent;
        }
        pos.nextEvent = null;
        this.nextTime = this.first != null ? this.first.time : 0L;
        event.scheduledIn = null;
        --this.eventCount;
        return true;
    }

    public TimeEvent popFirst() {
        TimeEvent tmp = this.first;
        if (tmp != null) {
            this.first = tmp.nextEvent;
            tmp.nextEvent = null;
            tmp.scheduledIn = null;
            --this.eventCount;
        }
        this.nextTime = this.first != null ? this.first.time : 0L;
        return tmp;
    }

    public void removeAll() {
        TimeEvent t = this.first;
        while (t != null) {
            TimeEvent clr = t;
            t = t.nextEvent;
            clr.nextEvent = null;
            clr.time = 0L;
            clr.scheduledIn = null;
        }
        this.first = null;
        this.eventCount = 0;
    }

    public void print(PrintStream out) {
        TimeEvent t = this.first;
        out.print("nxt: " + this.nextTime + " [");
        while (t != null) {
            out.print(t.getShort());
            t = t.nextEvent;
            if (t == null) continue;
            out.print(", ");
        }
        out.println("]");
    }
}

