/*
 * Decompiled with CFR 0.152.
 */
package se.sics.mspsim.core;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import se.sics.mspsim.core.DbgInstruction;
import se.sics.mspsim.core.MSP430;
import se.sics.mspsim.core.MSP430Constants;
import se.sics.mspsim.util.MapEntry;
import se.sics.mspsim.util.MapTable;
import se.sics.mspsim.util.Utils;

public class DisAsm
implements MSP430Constants {
    private boolean step = true;
    private MapTable map;
    private BufferedReader input = new BufferedReader(new InputStreamReader(System.in));

    public void setMap(MapTable m) {
        this.map = m;
    }

    public MapTable getMap() {
        return this.map;
    }

    public DbgInstruction disassemble(int pc, int[] memory, int[] reg) {
        return this.disassemble(pc, memory, reg, 0);
    }

    public DbgInstruction disassemble(int pc, int[] memory, int[] reg, int interrupt) {
        DbgInstruction dbg = this.disassemble(pc, memory, reg, new DbgInstruction(), interrupt);
        String fkn = dbg.getFunction();
        if (fkn != null) {
            System.out.println("//// " + fkn);
        }
        System.out.println(dbg.getASMLine());
        return dbg;
    }

    public DbgInstruction getDbgInstruction(int pc, MSP430 cpu) {
        return this.disassemble(pc, cpu.memory, cpu.reg, new DbgInstruction(), cpu.servicedInterrupt);
    }

    public DbgInstruction disassemble(int pc, int[] memory, int[] reg, DbgInstruction dbg, int interrupt) {
        int startPC = pc;
        int size = 0;
        int instruction = memory[pc] + (memory[pc + 1] << 8);
        int op = instruction >> 12;
        boolean word = (instruction & 0x40) == 0;
        String output = "    ";
        if (interrupt > 0) {
            output = "I:" + Integer.toString(interrupt) + ' ';
        }
        String regs = "";
        output = pc < 16 ? output + "000" + Integer.toString(pc, 16) : (pc < 256 ? output + "00" + Integer.toString(pc, 16) : (pc < 4096 ? output + "0" + Integer.toString(pc, 16) : output + Integer.toString(pc, 16)));
        output = output + ":\t";
        pc += 2;
        size += 2;
        switch (op) {
            case 1: {
                int register = instruction & 0xF;
                int ad = instruction >> 4 & 3;
                int dstAddress = 0;
                String adr = "";
                String opstr = "";
                switch (ad) {
                    case 0: {
                        adr = "R" + register;
                        break;
                    }
                    case 1: {
                        dstAddress = memory[pc] + (memory[pc + 1] << 8);
                        adr = "R" + register + "(" + dstAddress + ")";
                        dstAddress = (register == 2 ? 0 : reg[register]) + dstAddress;
                        pc += 2;
                        size += 2;
                        break;
                    }
                    case 2: {
                        adr = "@(R" + register + ")";
                        dstAddress = reg[register];
                        break;
                    }
                    case 3: {
                        if (register == 0) {
                            MapEntry me;
                            int tmp = memory[pc] + (memory[pc + 1] << 8);
                            adr = this.map != null && (me = this.map.getEntry(tmp)) != null ? me.getName() : "#$" + Utils.hex16(tmp);
                            size += 2;
                            break;
                        }
                        adr = "@(R" + register + "+)";
                        dstAddress = reg[register];
                    }
                }
                switch (instruction & 0xFF80) {
                    case 4096: {
                        opstr = "RRC" + (word ? ".W" : ".B");
                        break;
                    }
                    case 4224: {
                        opstr = "SWPB" + (word ? ".W" : ".B");
                        break;
                    }
                    case 4352: {
                        opstr = "RRA" + (word ? ".W" : ".B");
                        break;
                    }
                    case 4480: {
                        opstr = "RRA" + (word ? ".W" : ".B");
                        break;
                    }
                    case 4608: {
                        opstr = "PUSH" + (word ? ".W" : ".B");
                        break;
                    }
                    case 4736: {
                        opstr = "CALL";
                        break;
                    }
                    case 4864: {
                        opstr = "RETI";
                        break;
                    }
                    default: {
                        System.out.println("Not implemented instruction: " + instruction);
                    }
                }
                output = output + DisAsm.dumpMem(startPC, size, memory);
                output = output + opstr + " " + adr;
                regs = "R" + register + "=" + Utils.hex16(reg[register]);
                regs = regs + " SP=" + Utils.hex16(reg[1]);
                break;
            }
            case 2: 
            case 3: {
                int jmpOffset = instruction & 0x3FF;
                jmpOffset = (jmpOffset & 0x200) == 0 ? 2 * jmpOffset : -(2 * (512 - (jmpOffset & 0x1FF)));
                boolean jump = false;
                String opstr = "";
                switch (instruction & 0xFC00) {
                    case 8192: {
                        opstr = "JNE";
                        break;
                    }
                    case 9216: {
                        opstr = "JEQ";
                        break;
                    }
                    case 10240: {
                        opstr = "JNC";
                        break;
                    }
                    case 11264: {
                        opstr = "JC";
                        break;
                    }
                    case 12288: {
                        opstr = "JN";
                        break;
                    }
                    case 13312: {
                        opstr = "JGE";
                        break;
                    }
                    case 14336: {
                        opstr = "JL";
                        break;
                    }
                    case 15360: {
                        opstr = "JMP";
                        break;
                    }
                    default: {
                        System.out.println("Not implemented instruction: " + Utils.binary16(instruction));
                    }
                }
                output = output + DisAsm.dumpMem(startPC, size, memory);
                output = output + opstr + " $" + Utils.hex16(jmpOffset);
                regs = "\tSR=" + DisAsm.dumpSR(reg[2]);
                break;
            }
            default: {
                MapEntry me;
                int dstRegister = instruction & 0xF;
                int srcRegister = instruction >> 8 & 0xF;
                int as = instruction >> 4 & 3;
                boolean dstRegMode = (instruction >> 7 & 1) == 0;
                int dstAddress = 0;
                int srcAddress = 0;
                int src = 0;
                int dst = 0;
                boolean write = false;
                boolean updateStatus = true;
                String srcadr = "";
                String dstadr = "";
                switch (as) {
                    case 0: {
                        if (srcRegister == 3) {
                            srcadr = "#0";
                            break;
                        }
                        if (srcRegister == 2) {
                            srcadr = "#0";
                            break;
                        }
                        srcadr = this.getRegName(srcRegister);
                        break;
                    }
                    case 1: {
                        if (srcRegister == 2) {
                            srcAddress = memory[pc] + (memory[pc + 1] << 8);
                            srcadr = this.map != null && (me = this.map.getEntry(srcAddress)) != null ? "&" + me.getName() : "&$" + Utils.hex16(srcAddress);
                            size += 2;
                            break;
                        }
                        if (srcRegister == 3) {
                            srcadr = "#1";
                            break;
                        }
                        srcAddress = reg[srcRegister] + memory[pc] + (memory[pc + 1] << 8);
                        srcadr = "$" + Utils.hex16(memory[pc] + (memory[pc + 1] << 8)) + "(R" + srcRegister + ")";
                        size += 2;
                        break;
                    }
                    case 2: {
                        if (srcRegister == 3) {
                            srcadr = "#2";
                            break;
                        }
                        if (srcRegister == 2) {
                            srcadr = "#4";
                            break;
                        }
                        srcadr = "@" + this.getRegName(srcRegister);
                        break;
                    }
                    case 3: {
                        if (srcRegister == 3) {
                            srcadr = "#$ffff";
                            break;
                        }
                        if (srcRegister == 2) {
                            srcadr = "#8";
                            break;
                        }
                        if (srcRegister == 0) {
                            srcadr = "#$" + Utils.hex16(memory[pc] + (memory[pc + 1] << 8));
                            pc += 2;
                            size += 2;
                            break;
                        }
                        if (srcRegister == 3) {
                            srcadr = "#$ffff";
                            break;
                        }
                        srcadr = "@" + this.getRegName(srcRegister) + "+";
                        srcAddress = reg[srcRegister];
                    }
                }
                if (dstRegMode) {
                    dstadr = this.getRegName(dstRegister);
                } else {
                    dstAddress = memory[pc] + (memory[pc + 1] << 8);
                    MapEntry mapEntry = me = this.map != null ? this.map.getEntry(dstAddress) : null;
                    dstadr = dstRegister == 2 ? (me != null ? "&" + me.getName() : "&$" + Utils.hex16(dstAddress)) : (me != null ? me.getName() + "(R" + dstRegister + ")" : "$" + Utils.hex16(dstAddress) + "(R" + dstRegister + ")");
                    pc += 2;
                    size += 2;
                }
                if (!word) {
                    src &= 0xFF;
                    dst &= 0xFF;
                }
                String opstr = "";
                switch (op) {
                    case 4: {
                        if (instruction == 12353) {
                            opstr = "RET /emulated: MOV.W ";
                            break;
                        }
                        opstr = "MOV" + (word ? ".W" : ".B");
                        break;
                    }
                    case 5: {
                        opstr = "ADD" + (word ? ".W" : ".B");
                        break;
                    }
                    case 6: {
                        opstr = "ADDC" + (word ? ".W" : ".B");
                        break;
                    }
                    case 7: {
                        opstr = "SUBC" + (word ? ".W" : ".B");
                        break;
                    }
                    case 8: {
                        opstr = "SUB" + (word ? ".W" : ".B");
                        break;
                    }
                    case 9: {
                        opstr = "CMP" + (word ? ".W" : ".B");
                        break;
                    }
                    case 10: {
                        opstr = "DADD" + (word ? ".W" : ".B");
                        break;
                    }
                    case 11: {
                        opstr = "BIT" + (word ? ".W" : ".B");
                        break;
                    }
                    case 12: {
                        opstr = "BIC" + (word ? ".W" : ".B");
                        break;
                    }
                    case 13: {
                        opstr = "BIS" + (word ? ".W" : ".B");
                        break;
                    }
                    case 14: {
                        opstr = "XOR" + (word ? ".W" : ".B");
                        break;
                    }
                    case 15: {
                        opstr = "AND" + (word ? ".W" : ".B");
                        break;
                    }
                    default: {
                        if (startPC <= 512) break;
                        System.out.println(output + " DoubleOperand not implemented: " + op + " instruction: " + Utils.binary16(instruction) + " = " + Utils.hex16(instruction));
                    }
                }
                output = output + DisAsm.dumpMem(startPC, size, memory);
                output = output + opstr + " " + srcadr + ", " + dstadr;
                regs = "R" + dstRegister + "=" + Utils.hex16(reg[dstRegister]) + " R" + srcRegister + "=" + Utils.hex16(reg[srcRegister]);
                regs = regs + " SR=" + DisAsm.dumpSR(reg[2]);
                regs = regs + " SP=" + Utils.hex16(reg[1]);
                regs = regs + "; as = " + as;
                if ((srcAddress &= 0xFFFF) == -1) break;
                regs = regs + " sMem:" + Utils.hex16(memory[srcAddress &= 0xFFFF] + (memory[(srcAddress + 1) % 65535] << 8));
            }
        }
        dbg.setASMLine(output);
        dbg.setRegs(regs);
        dbg.setInstruction(instruction, size);
        if (this.map != null) {
            dbg.setFunction(this.map.getFunctionName(startPC));
        }
        if (!this.step) {
            String line = "";
            try {
                line = this.input.readLine();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (line != null && line.length() > 0 && line.charAt(0) == 'r') {
                System.out.println("Registers:");
                int n = 16;
                for (int i = 0; i < n; ++i) {
                    System.out.print("R" + i + "=" + Utils.hex16(reg[i]) + "  ");
                    if (i % 7 != 0 || i == 0) continue;
                    System.out.println();
                }
                System.out.println();
            }
        }
        return dbg;
    }

    private String getRegName(int index) {
        if (index == 0) {
            return "PC";
        }
        if (index == 1) {
            return "SP";
        }
        if (index == 2) {
            return "SR";
        }
        return "R" + index;
    }

    public static String getSingleOPStr(int instruction) {
        boolean word = (instruction & 0x40) == 0;
        switch (instruction & 0xFF80) {
            case 4096: {
                return "RRC" + (word ? ".W" : ".B");
            }
            case 4224: {
                return "SWPB" + (word ? ".W" : ".B");
            }
            case 4352: {
                return "RRA" + (word ? ".W" : ".B");
            }
            case 4480: {
                return "RRA" + (word ? ".W" : ".B");
            }
            case 4608: {
                return "PUSH" + (word ? ".W" : ".B");
            }
            case 4736: {
                return "CALL";
            }
            case 4864: {
                return "RETI";
            }
        }
        return "-";
    }

    private static String dumpSR(int sr) {
        return "" + ((sr & 0x100) != 0 ? (char)'V' : '-') + ((sr & 4) != 0 ? (char)'N' : '-') + ((sr & 2) != 0 ? (char)'Z' : '-') + ((sr & 1) != 0 ? (char)'C' : '-');
    }

    private static String dumpMem(int pc, int size, int[] memory) {
        String output = "";
        int n = 4;
        for (int i = 0; i < n; ++i) {
            output = size > i ? output + Utils.hex8(memory[pc + i]) + " " : output + "   ";
        }
        return output;
    }
}

