/*
 * Decompiled with CFR 0.152.
 */
package se.sics.mspsim.core;

import java.io.PrintStream;
import se.sics.mspsim.core.EmulationLogger;
import se.sics.mspsim.core.EventListener;
import se.sics.mspsim.core.EventSource;
import se.sics.mspsim.core.Loggable;
import se.sics.mspsim.core.OperatingModeListener;
import se.sics.mspsim.util.ArrayUtils;

public abstract class Chip
implements Loggable,
EventSource {
    private OperatingModeListener[] omListeners;
    private EventListener eventListener;
    protected boolean sendEvents = false;
    private String[] modeNames = null;
    private int mode;
    protected EmulationLogger logger;
    private PrintStream log;
    protected boolean DEBUG = false;

    public void addOperatingModeListener(OperatingModeListener listener) {
        this.omListeners = (OperatingModeListener[])ArrayUtils.add(OperatingModeListener.class, this.omListeners, listener);
    }

    public void removeOperatingModeListener(OperatingModeListener listener) {
        this.omListeners = (OperatingModeListener[])ArrayUtils.remove(this.omListeners, listener);
    }

    public int getMode() {
        return this.mode;
    }

    protected void setMode(int mode) {
        if (mode != this.mode) {
            this.mode = mode;
            OperatingModeListener[] listeners = this.omListeners;
            if (listeners != null) {
                int n = listeners.length;
                for (int i = 0; i < n; ++i) {
                    listeners[i].modeChanged(this, mode);
                }
            }
        }
    }

    protected void setModeNames(String[] names) {
        this.modeNames = names;
    }

    public void setEventListener(EventListener e) {
        this.eventListener = e;
        this.sendEvents = true;
    }

    protected void sendEvent(String event, Object data) {
        if (this.eventListener != null) {
            this.eventListener.event(this, event, data);
        }
    }

    public String getModeName(int index) {
        if (this.modeNames == null) {
            return null;
        }
        return this.modeNames[index];
    }

    public int getModeByName(String mode) {
        if (this.modeNames != null) {
            for (int i = 0; i < this.modeNames.length; ++i) {
                if (!mode.equals(this.modeNames[i])) continue;
                return i;
            }
        }
        try {
            int modei = Integer.parseInt(mode);
            if (modei >= 0 && modei <= this.getModeMax()) {
                return modei;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }

    @Override
    public abstract String getName();

    public abstract int getModeMax();

    public boolean getChipSelect() {
        return true;
    }

    public String chipinfo() {
        return "* no info";
    }

    @Override
    public void clearLogStream() {
        this.log = null;
        this.DEBUG = false;
    }

    public PrintStream getLogStream() {
        return this.log;
    }

    @Override
    public void setLogStream(PrintStream out) {
        this.log = out;
        this.DEBUG = true;
    }

    public void log(String msg) {
        if (this.log != null) {
            this.log.println(this.getName() + ": " + msg);
        }
    }

    @Override
    public void setEmulationLogger(EmulationLogger logger) {
        this.logger = logger;
    }
}

