/*
 * Decompiled with CFR 0.152.
 */
package se.sics.mspsim.core;

import se.sics.mspsim.core.IOUnit;
import se.sics.mspsim.core.MSP430Core;
import se.sics.mspsim.core.Timer;

public class BasicClockModule
extends IOUnit {
    public static final boolean DEBUG = false;
    public static final int DCOCTL = 86;
    public static final int BCSCTL1 = 87;
    public static final int BCSCTL2 = 88;
    public static final int ACLK_FRQ = 32768;
    public static final int DCO_FRQ = 2500000;
    public static final int MAX_DCO_FRQ = 0x4B0000;
    public static final int MIN_DCO_FRQ = 1000;
    public static final int DCO_FACTOR = 2399;
    private MSP430Core core;
    private Timer[] timers;
    private int dcoFrequency;
    private int dcoModulator;
    private int resistorSel;
    private int calcDCOFrq;
    private int divAclk = 1;
    private int lfxt1Mode;
    private int xt2Off;
    private int mclkSel;
    private int divMclk = 1;
    private int smclSel;
    private int divSMclk = 1;
    private int dcoResitorSel;

    public BasicClockModule(MSP430Core core, int[] memory, int offset, Timer[] timers) {
        super(memory, offset);
        this.core = core;
        this.timers = timers;
        this.reset();
    }

    public void reset() {
        this.write(86, 96, false, this.core.cycles);
        this.write(87, 132, false, this.core.cycles);
        this.write(88, 0, false, this.core.cycles);
    }

    @Override
    public int read(int address, boolean word, long cycles) {
        int val = this.memory[address];
        if (word) {
            val |= this.memory[address + 1 & 0xFFFF] << 8;
        }
        return val;
    }

    @Override
    public void write(int address, int data, boolean word, long cycles) {
        this.memory[address] = data & 0xFF;
        if (word) {
            this.memory[address + 1] = data >> 8 & 0xFF;
        }
        switch (address) {
            case 86: {
                this.dcoFrequency = data >> 5 & 7;
                this.dcoModulator = data & 0x1F;
                break;
            }
            case 87: {
                this.resistorSel = data & 7;
                this.divAclk = 1 << (data >> 4 & 3);
                this.lfxt1Mode = data >> 6 & 1;
                this.xt2Off = data >> 7 & 1;
                this.core.setACLKFrq(32768 / this.divAclk);
                this.updateTimers(cycles);
                break;
            }
            case 88: {
                this.mclkSel = data >> 6 & 3;
                this.divMclk = 1 << (data >> 4 & 3);
                this.smclSel = data >> 3 & 1;
                this.divSMclk = 1 << (data >> 2 & 3);
                this.dcoResitorSel = data & 1;
            }
        }
        int newcalcDCOFrq = ((this.dcoFrequency << 5) + this.dcoModulator + (this.resistorSel << 8)) * 2399 + 1000;
        if (newcalcDCOFrq != this.calcDCOFrq) {
            this.calcDCOFrq = newcalcDCOFrq;
            this.core.setDCOFrq(this.calcDCOFrq, this.calcDCOFrq / this.divSMclk);
            this.updateTimers(cycles);
        }
    }

    private void updateTimers(long cycles) {
        if (this.timers != null) {
            for (int i = 0; i < this.timers.length; ++i) {
                this.timers[i].resetCounter(cycles);
            }
        }
    }

    @Override
    public String getName() {
        return "BasicClockModule";
    }

    @Override
    public void interruptServiced(int vector) {
    }
}

