/*
 * Decompiled with CFR 0.152.
 */
package se.sics.mspsim.core;

import se.sics.mspsim.core.ADCInput;
import se.sics.mspsim.core.IOUnit;
import se.sics.mspsim.core.MSP430Core;
import se.sics.mspsim.core.TimeEvent;

public class ADC12
extends IOUnit {
    private static final boolean DEBUG = false;
    public static final int ADC12CTL0 = 416;
    public static final int ADC12CTL1 = 418;
    public static final int ADC12IFG = 420;
    public static final int ADC12IE = 422;
    public static final int ADC12IV = 424;
    public static final int ADC12MEM0 = 320;
    public static final int ADC12MEM1 = 322;
    public static final int ADC12MEM2 = 324;
    public static final int ADC12MEM3 = 326;
    public static final int ADC12MEM4 = 328;
    public static final int ADC12MEM5 = 330;
    public static final int ADC12MEM6 = 332;
    public static final int ADC12MEM7 = 334;
    public static final int ADC12MEM8 = 336;
    public static final int ADC12MEM9 = 338;
    public static final int ADC12MEM10 = 340;
    public static final int ADC12MEM11 = 342;
    public static final int ADC12MEM12 = 344;
    public static final int ADC12MEM13 = 346;
    public static final int ADC12MEM14 = 348;
    public static final int ADC12MEM15 = 350;
    public static final int ADC12MCTL0 = 128;
    public static final int ADC12MCTL1 = 129;
    public static final int ADC12MCTL2 = 130;
    public static final int ADC12MCTL3 = 131;
    public static final int ADC12MCTL4 = 132;
    public static final int ADC12MCTL5 = 133;
    public static final int ADC12MCTL6 = 134;
    public static final int ADC12MCTL7 = 135;
    public static final int ADC12MCTL8 = 136;
    public static final int ADC12MCTL9 = 137;
    public static final int ADC12MCTL10 = 138;
    public static final int ADC12MCTL11 = 139;
    public static final int ADC12MCTL12 = 140;
    public static final int ADC12MCTL13 = 141;
    public static final int ADC12MCTL14 = 142;
    public static final int ADC12MCTL15 = 143;
    public static final int[] SHTBITS = new int[]{4, 8, 16, 32, 64, 96, 128, 192, 256, 384, 512, 768, 1024, 1024, 1024, 1024};
    public static final int EOS_MASK = 128;
    private int adc12ctl0 = 0;
    private int adc12ctl1 = 0;
    private int[] adc12mctl = new int[16];
    private int[] adc12mem = new int[16];
    private int adc12Pos = 0;
    private int shTime0 = 4;
    private int shTime1 = 4;
    private boolean adc12On = false;
    private boolean enableConversion;
    private boolean startConversion;
    private int shSource = 0;
    private int startMem = 0;
    private int adcDiv = 1;
    private ADCInput[] adcInput = new ADCInput[8];
    private int conSeq;
    private int adc12ie;
    private int adc12ifg;
    private int adc12iv;
    private int adcSSel;
    private MSP430Core core;
    private int adc12Vector = 7;
    private TimeEvent adcTrigger = new TimeEvent(0L){

        @Override
        public void execute(long t) {
            ADC12.this.convert();
        }
    };
    int smp = 0;

    public ADC12(MSP430Core cpu) {
        super(cpu.memory, 0);
        this.core = cpu;
    }

    public void setADCInput(int adindex, ADCInput input) {
        this.adcInput[adindex] = input;
    }

    @Override
    public void write(int address, int value, boolean word, long cycles) {
        switch (address) {
            case 416: {
                this.adc12ctl0 = value;
                this.shTime0 = SHTBITS[value >> 8 & 0xF];
                this.shTime1 = SHTBITS[value >> 12 & 0xF];
                this.adc12On = (value & 0x10) > 0;
                this.enableConversion = (value & 2) > 0;
                boolean bl = this.startConversion = (value & 1) > 0;
                if (!this.adc12On || !this.enableConversion || !this.startConversion) break;
                this.adcTrigger.time = this.core.getTime();
                this.convert();
                break;
            }
            case 418: {
                this.adc12ctl1 = value;
                this.startMem = value >> 12 & 0xF;
                this.shSource = value >> 10 & 3;
                this.adcDiv = (value >> 5 & 7) + 1;
                this.conSeq = value >> 1 & 3;
                this.adcSSel = value >> 3 & 3;
                break;
            }
            case 422: {
                this.adc12ie = value;
                break;
            }
            case 420: {
                this.adc12ifg = value;
                break;
            }
            default: {
                if (address < 128 || address > 143) break;
                this.adc12mctl[address - 128] = value & 0xFF;
                if ((value & 0x80) == 0) break;
            }
        }
    }

    @Override
    public int read(int address, boolean word, long cycles) {
        switch (address) {
            case 416: {
                return this.adc12ctl0;
            }
            case 418: {
                return this.adc12ctl1;
            }
            case 422: {
                return this.adc12ie;
            }
            case 420: {
                return this.adc12ifg;
            }
        }
        if (address >= 128 && address <= 143) {
            return this.adc12mctl[address - 128];
        }
        if (address >= 320) {
            int reg = (address - 320) / 2;
            this.adc12ifg &= ~(1 << reg);
            if (this.adc12iv == reg * 2 + 6) {
                this.core.flagInterrupt(this.adc12Vector, this, false);
                this.adc12iv = 0;
            }
            return this.adc12mem[reg];
        }
        return 0;
    }

    @Override
    public String getName() {
        return "ADC12";
    }

    private void convert() {
        if (!this.adc12On || !this.enableConversion) {
            return;
        }
        ADCInput input = this.adcInput[this.adc12mctl[this.adc12Pos] & 7];
        this.adc12mem[this.adc12Pos] = input != null ? input.nextData() : 2148 - this.smp & 0xFF;
        this.smp += 7;
        if ((this.adc12ie & 1 << this.adc12Pos) > 0) {
            this.adc12ifg |= 1 << this.adc12Pos;
            this.adc12iv = this.adc12Pos * 2 + 6;
            this.core.flagInterrupt(this.adc12Vector, this, true);
        }
        this.adc12Pos = (this.adc12mctl[this.adc12Pos] & 0x80) == 128 ? this.startMem : this.adc12Pos + 1 & 0xF;
        int delay = this.adcDiv * (this.shTime0 + 13);
        this.core.scheduleTimeEvent(this.adcTrigger, this.adcTrigger.time + (long)delay);
    }

    @Override
    public void interruptServiced(int vector) {
    }
}

