/*
 * Decompiled with CFR 0.152.
 */
package se.sics.mspsim.cli;

import java.awt.Font;
import java.io.PrintStream;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import se.sics.mspsim.cli.CommandContext;
import se.sics.mspsim.cli.CommandParser;
import se.sics.mspsim.cli.LineListener;
import se.sics.mspsim.cli.WindowDataHandler;
import se.sics.mspsim.extutil.jfreechart.LineChart;
import se.sics.mspsim.extutil.jfreechart.LineSampleChart;

public class WindowTarget
implements LineListener {
    private JFrame window;
    private String targetName;
    private JTextArea jta = new JTextArea(40, 80);
    private WindowDataHandler dataHandler = null;
    private ArrayList<CommandContext> pids = new ArrayList();

    public WindowTarget(String name) {
        this.jta.setFont(Font.decode("Courier"));
        this.jta.setEditable(false);
        this.window = new JFrame(name);
        this.window.getContentPane().add(new JScrollPane(this.jta, 20, 31));
        this.window.pack();
        this.window.setVisible(true);
        this.targetName = name;
    }

    public void addContext(CommandContext c) {
        if (c.getPID() != -1) {
            this.pids.add(c);
        }
    }

    public void removeContext(CommandContext c) {
        this.pids.remove(c);
    }

    @Override
    public void lineRead(final String line) {
        if (line != null && this.window != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WindowTarget.this.handleLine(line);
                }
            });
        }
    }

    private void handleLine(String line) {
        if (line.startsWith("#!")) {
            String[] parts = CommandParser.parseLine(line = line.substring(2));
            String cmd = parts[0];
            if ("bounds".equals(cmd)) {
                try {
                    this.window.setBounds(Integer.parseInt(parts[1]), Integer.parseInt(parts[2]), Integer.parseInt(parts[3]), Integer.parseInt(parts[4]));
                }
                catch (Exception e) {
                    System.err.println("Could not set bounds: " + line);
                }
            } else if ("title".equals(cmd)) {
                String args = CommandParser.toString(parts, 1, parts.length);
                this.window.setTitle(args);
                if (this.dataHandler != null) {
                    this.dataHandler.setProperty("title", new String[]{args});
                }
            } else if ("type".equals(cmd)) {
                if ("line-sample".equals(parts[1])) {
                    this.dataHandler = new LineSampleChart();
                } else if ("line".equals(parts[1])) {
                    this.dataHandler = new LineChart();
                } else {
                    System.err.println("Unknown window data handler type: " + parts[1]);
                }
                if (this.dataHandler != null) {
                    System.out.println("Replacing window data handler! " + parts[1] + " " + this.dataHandler);
                    this.window.getContentPane().removeAll();
                    this.window.getContentPane().add(this.dataHandler.getComponent());
                    String title = this.window.getTitle();
                    if (title != null) {
                        this.dataHandler.setProperty("title", new String[]{title});
                    }
                    this.window.repaint();
                }
            } else if (this.dataHandler != null) {
                this.dataHandler.handleCommand(parts);
            } else if ("clear".equals(cmd)) {
                this.jta.setText("");
            } else if ("tabsize".equals(cmd)) {
                try {
                    this.jta.setTabSize(Integer.parseInt(parts[1]));
                }
                catch (Exception e) {
                    System.err.println("Could not set tab size: " + line);
                }
            } else if ("font".equals(cmd)) {
                this.jta.setFont(Font.decode(parts[1]));
            }
        } else if (!line.startsWith("#")) {
            if (this.dataHandler != null) {
                this.dataHandler.lineRead(line);
            } else {
                this.jta.append(line + '\n');
            }
        }
    }

    public void close() {
        this.window.setVisible(false);
        this.window.dispose();
        this.window.removeAll();
        this.window = null;
    }

    public void clear() {
        this.jta.setText("");
    }

    public String getName() {
        return this.targetName;
    }

    public void print(PrintStream out) {
        out.print("Window: " + this.targetName + " PIDs: [");
        CommandContext[] ctx = this.pids.toArray(new CommandContext[this.pids.size()]);
        for (int i = 0; i < ctx.length; ++i) {
            if (i > 0) {
                out.print(" ,");
            }
            out.print(ctx[i].getPID());
        }
        out.println("]");
    }
}

