/*
 * Decompiled with CFR 0.152.
 */
package se.sics.mspsim.cli;

import java.util.Hashtable;
import se.sics.mspsim.cli.BasicCommand;
import se.sics.mspsim.cli.BasicLineCommand;
import se.sics.mspsim.cli.CommandBundle;
import se.sics.mspsim.cli.CommandContext;
import se.sics.mspsim.cli.CommandHandler;
import se.sics.mspsim.cli.WindowTarget;
import se.sics.mspsim.ui.WindowUtils;
import se.sics.mspsim.util.ComponentRegistry;

public class WindowCommands
implements CommandBundle {
    private Hashtable<String, WindowTarget> windowTargets = new Hashtable();

    @Override
    public void setupCommands(ComponentRegistry registry, CommandHandler handler) {
        handler.registerCommand("window", new BasicLineCommand("redirect input to a window", "[-close|-clear|-list] <windowname>"){
            WindowTarget wt;
            CommandContext context;

            @Override
            public int executeCommand(CommandContext context) {
                boolean close = false;
                boolean clear = false;
                boolean exit = false;
                this.context = context;
                for (int i = 0; i < context.getArgumentCount(); ++i) {
                    String name = context.getArgument(i);
                    if ("-close".equals(name)) {
                        close = true;
                        exit = true;
                        continue;
                    }
                    if ("-clear".equals(name)) {
                        clear = true;
                        continue;
                    }
                    if ("-list".equals(name)) {
                        WindowTarget[] tgts = WindowCommands.this.windowTargets.values().toArray(new WindowTarget[WindowCommands.this.windowTargets.size()]);
                        if (tgts != null && tgts.length > 0) {
                            context.out.println("Window Name   PIDs");
                        }
                        for (int j = 0; j < tgts.length; ++j) {
                            tgts[j].print(context.out);
                        }
                        exit = true;
                        continue;
                    }
                    if (i != context.getArgumentCount() - 1) continue;
                    if (clear || close) {
                        this.wt = (WindowTarget)WindowCommands.this.windowTargets.get(name);
                        if (this.wt != null) {
                            if (close) {
                                context.out.println("Closing window " + name);
                                WindowCommands.this.removeTarget(this.wt);
                                this.wt.close();
                            } else if (clear) {
                                this.wt.clear();
                            }
                            if (exit) {
                                context.exit(0);
                            }
                            return 0;
                        }
                        context.err.println("Could not find the window " + name);
                        context.exit(1);
                        return 1;
                    }
                    this.wt = WindowCommands.this.addTarget(context, name);
                }
                if (exit) {
                    context.exit(0);
                }
                return 0;
            }

            @Override
            public void lineRead(String line) {
                if (line != null) {
                    this.wt.lineRead(line);
                } else {
                    this.wt.removeContext(this.context);
                    this.context.exit(0);
                }
            }

            @Override
            public void stopCommand(CommandContext context) {
                System.out.println("Stopping window target: " + this.wt.getName());
                this.wt.removeContext(context);
            }
        });
        handler.registerCommand("wclear", new BasicCommand("resets stored window positions", ""){

            @Override
            public int executeCommand(CommandContext context) {
                WindowUtils.clearState();
                return 0;
            }
        });
    }

    protected WindowTarget addTarget(CommandContext context, String name) {
        WindowTarget wt = this.windowTargets.get(name);
        if (wt == null) {
            wt = new WindowTarget(name);
            this.windowTargets.put(name, wt);
        }
        wt.addContext(context);
        return wt;
    }

    protected void removeTarget(WindowTarget target) {
        this.windowTargets.remove(target.getName());
    }
}

