/*
 * Decompiled with CFR 0.152.
 */
package se.sics.mspsim.cli;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.PrintStream;
import se.sics.mspsim.cli.BasicCommand;
import se.sics.mspsim.cli.CommandContext;
import se.sics.mspsim.cli.CommandHandler;

public class StreamCommandHandler
extends CommandHandler
implements Runnable {
    private BufferedReader inReader;
    private boolean workaround = false;
    private boolean exit;
    private String prompt;

    public StreamCommandHandler(InputStream in, PrintStream out, PrintStream err, String prompt) {
        super(out, err);
        this.prompt = prompt;
        this.exit = false;
        this.inReader = new BufferedReader(new InputStreamReader(in));
        this.registerCommand("workaround", new BasicCommand("activate workaround for Java console input bug", ""){

            @Override
            public int executeCommand(CommandContext context) {
                StreamCommandHandler.this.workaround = true;
                return 0;
            }
        });
    }

    public void setWorkaround(boolean w) {
        this.workaround = w;
    }

    @Override
    public void start() {
        super.start();
        new Thread((Runnable)this, "cmd").start();
    }

    private String readLine(BufferedReader inReader2) throws IOException {
        if (this.workaround) {
            StringBuilder str = new StringBuilder();
            while (true) {
                if (inReader2.ready()) {
                    int c = inReader2.read();
                    if (c == 10) {
                        return str.toString();
                    }
                    if (c == 13) continue;
                    str.append((char)c);
                    continue;
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException();
                }
            }
        }
        return inReader2.readLine();
    }

    @Override
    public void run() {
        String lastLine = null;
        while (!this.exit) {
            try {
                this.out.print(this.prompt);
                this.out.flush();
                String line = this.readLine(this.inReader);
                if ("\u001b[A".equals(line)) {
                    line = lastLine;
                }
                if (line == null || line.length() <= 0) continue;
                lastLine = line;
                this.lineRead(line);
            }
            catch (IOException e) {
                e.printStackTrace(this.err);
                this.err.println("Command line tool exiting...");
                this.exit = true;
            }
        }
    }
}

