/*
 * Decompiled with CFR 0.152.
 */
package se.sics.mspsim.cli;

import java.util.Properties;
import se.sics.mspsim.cli.BasicAsyncCommand;
import se.sics.mspsim.cli.BasicCommand;
import se.sics.mspsim.cli.CommandBundle;
import se.sics.mspsim.cli.CommandContext;
import se.sics.mspsim.cli.CommandHandler;
import se.sics.mspsim.core.Chip;
import se.sics.mspsim.core.EventListener;
import se.sics.mspsim.core.EventSource;
import se.sics.mspsim.core.MSP430;
import se.sics.mspsim.core.Profiler;
import se.sics.mspsim.util.ComponentRegistry;
import se.sics.mspsim.util.SimpleProfiler;

public class ProfilerCommands
implements CommandBundle {
    @Override
    public void setupCommands(ComponentRegistry registry, CommandHandler ch) {
        final MSP430 cpu = (MSP430)registry.getComponent(MSP430.class);
        if (cpu != null) {
            ch.registerCommand("profile", new BasicCommand("show profile information", "[-clear] [-sort column] [-showcallers] [regexp]"){

                @Override
                public int executeCommand(CommandContext context) {
                    Profiler profiler = cpu.getProfiler();
                    if (profiler == null) {
                        context.err.println("No profiler found.");
                        return 1;
                    }
                    String namematch = null;
                    String sortMode = null;
                    String showCaller = null;
                    for (int i = 0; i < context.getArgumentCount(); ++i) {
                        String value = context.getArgument(i);
                        if ("-clear".equals(value)) {
                            profiler.clearProfile();
                            context.out.println("Cleared profile information.");
                            return 0;
                        }
                        if ("-sort".equals(value)) {
                            if (context.getArgumentCount() > i + 1) {
                                sortMode = context.getArgument(i + 1);
                                ++i;
                                continue;
                            }
                            context.err.println("Missing mode argument for -sort.");
                            return 1;
                        }
                        if ("-showcallers".equals(value)) {
                            showCaller = value;
                            continue;
                        }
                        if (namematch != null) {
                            context.err.println("Too many arguments. Either clear or show profile information.");
                            continue;
                        }
                        namematch = value;
                    }
                    Properties params = new Properties();
                    if (namematch != null) {
                        params.put("function.regexp", namematch);
                    }
                    if (showCaller != null) {
                        params.put("showcallers", showCaller);
                    }
                    if (sortMode != null) {
                        params.put("sortmode", sortMode);
                    }
                    profiler.printProfile(context.out, params);
                    return 0;
                }
            });
            ch.registerCommand("stacktrace", new BasicCommand("show stack trace", ""){

                @Override
                public int executeCommand(CommandContext context) {
                    Profiler profiler = cpu.getProfiler();
                    if (profiler == null) {
                        context.err.println("No profiler found.");
                        return 1;
                    }
                    profiler.printStackTrace(context.out);
                    return 0;
                }
            });
            ch.registerCommand("logevents", new BasicAsyncCommand("log events", ""){
                Chip chip;

                @Override
                public int executeCommand(CommandContext context) {
                    this.chip = cpu.getChip(context.getArgument(0));
                    if (this.chip == null) {
                        context.err.println("Can not find chip: " + context.getArgument(0));
                    }
                    this.chip.setEventListener(new EventListener(){

                        @Override
                        public void event(EventSource source, String event, Object data) {
                            System.out.println("Event:" + source.getName() + ":" + event);
                        }
                    });
                    return 0;
                }

                @Override
                public void stopCommand(CommandContext context) {
                    this.chip.setEventListener(null);
                }
            });
            ch.registerCommand("tagprof", new BasicCommand("profile between two events", ""){

                @Override
                public int executeCommand(CommandContext context) {
                    Chip chipE2;
                    String event1 = context.getArgument(0);
                    String event2 = context.getArgument(1);
                    String[] chip1 = event1.split("\\.");
                    String[] chip2 = event2.split("\\.");
                    Chip chipE1 = cpu.getChip(chip1[0]);
                    if (chipE1 == null) {
                        context.err.println("Can not find chip: " + chip1[0]);
                    }
                    if ((chipE2 = cpu.getChip(chip2[0])) == null) {
                        context.err.println("Can not find chip: " + chip2[0]);
                    }
                    Profiler profiler = cpu.getProfiler();
                    SimpleProfiler sprof = (SimpleProfiler)profiler;
                    sprof.addProfileTag(context.getArgument(2), chipE1, chip1[1], chipE2, chip2[1]);
                    return 0;
                }
            });
            ch.registerCommand("printtags", new BasicCommand("print tags profile", ""){

                @Override
                public int executeCommand(CommandContext context) {
                    Profiler profiler = cpu.getProfiler();
                    SimpleProfiler sprof = (SimpleProfiler)profiler;
                    sprof.printTagProfile(context.out);
                    return 0;
                }
            });
            ch.registerCommand("logcalls", new BasicAsyncCommand("log function calls", ""){

                @Override
                public int executeCommand(CommandContext context) {
                    Profiler profiler = cpu.getProfiler();
                    if (profiler == null) {
                        context.err.println("No profiler found.");
                        return 1;
                    }
                    profiler.setLogger(context.out);
                    return 0;
                }

                @Override
                public void stopCommand(CommandContext context) {
                    Profiler profiler = cpu.getProfiler();
                    if (profiler != null) {
                        profiler.setLogger(null);
                    }
                }
            });
            ch.registerCommand("profiler", new BasicCommand("configure profiler", "<command> <arguments>"){

                @Override
                public int executeCommand(CommandContext context) {
                    SimpleProfiler profiler = (SimpleProfiler)cpu.getProfiler();
                    if (profiler == null) {
                        context.err.println("No profiler found.");
                        return 1;
                    }
                    String cmd = context.getArgument(0);
                    if ("hide".equals(cmd)) {
                        int n = context.getArgumentCount();
                        for (int j = 1; j < n; ++j) {
                            profiler.addIgnoreFunction(context.getArgument(j));
                        }
                    } else if ("hideirq".equals(cmd)) {
                        profiler.setHideIRQ(context.getArgumentAsBoolean(1));
                    }
                    return 0;
                }
            });
        }
    }
}

