/*
 * Decompiled with CFR 0.152.
 */
package se.sics.mspsim.cli;

import se.sics.jipv6.core.IPStack;
import se.sics.jipv6.core.NetworkInterface;
import se.sics.jipv6.core.PacketHandler;
import se.sics.jipv6.mac.IEEE802154Handler;
import se.sics.jipv6.mac.LoWPANHandler;
import se.sics.jipv6.tunnel.TSPClient;
import se.sics.mspsim.cli.BasicCommand;
import se.sics.mspsim.cli.BasicLineCommand;
import se.sics.mspsim.cli.CommandBundle;
import se.sics.mspsim.cli.CommandContext;
import se.sics.mspsim.cli.CommandHandler;
import se.sics.mspsim.core.MSP430;
import se.sics.mspsim.net.CC2420PacketHandler;
import se.sics.mspsim.util.ComponentRegistry;
import se.sics.mspsim.util.Utils;

public class NetCommands
implements CommandBundle {
    private IPStack ipStack;

    @Override
    public void setupCommands(final ComponentRegistry registry, CommandHandler handler) {
        handler.registerCommand("ipstack", new BasicLineCommand("setup 802.15.4/IP stack", ""){
            CC2420PacketHandler listener;
            CommandContext context;

            @Override
            public int executeCommand(CommandContext context) {
                this.context = context;
                MSP430 cpu = (MSP430)registry.getComponent(MSP430.class);
                this.listener = new CC2420PacketHandler(cpu);
                this.listener.setOutput(context.out);
                IEEE802154Handler ieeeHandler = new IEEE802154Handler();
                this.listener.addUpperLayerHandler(0, (PacketHandler)ieeeHandler);
                ieeeHandler.setLowerLayerHandler((PacketHandler)this.listener);
                NetCommands.this.ipStack = new IPStack();
                byte[] macAddr = new byte[]{2, 18, 116, 0, 17, 17, 18, 18};
                NetCommands.this.ipStack.setLinkLayerAddress(macAddr);
                NetCommands.this.ipStack.setRouter(true);
                LoWPANHandler lowpanHandler = new LoWPANHandler();
                lowpanHandler.setIPStack(NetCommands.this.ipStack);
                ieeeHandler.addUpperLayerHandler(0, (PacketHandler)lowpanHandler);
                lowpanHandler.setLowerLayerHandler((PacketHandler)ieeeHandler);
                NetCommands.this.ipStack.setLinkLayerHandler((PacketHandler)lowpanHandler);
                context.err.print("IP Stack started");
                return 0;
            }

            @Override
            public void lineRead(String line) {
                if (this.listener != null) {
                    byte[] data = Utils.hexconv(line);
                    for (int i = 0; i < data.length; ++i) {
                        this.listener.receivedByte(data[i]);
                    }
                }
            }
        });
        handler.registerCommand("tspstart", new BasicCommand("starts a TSP tunnel", "<server> <user> <password>"){

            @Override
            public int executeCommand(CommandContext context) {
                TSPClient tunnel = TSPClient.startTSPTunnel((IPStack)NetCommands.this.ipStack, (String)context.getArgument(0), (String)context.getArgument(1), (String)context.getArgument(2));
                NetCommands.this.ipStack.setTunnel((NetworkInterface)tunnel);
                if (tunnel != null) {
                    context.out.print("TSP Tunnel started");
                    return 0;
                }
                context.out.print("TSP Tunnel failed");
                return 1;
            }
        });
    }
}

