/*
 * Decompiled with CFR 0.152.
 */
package se.sics.mspsim.cli;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.regex.Pattern;
import se.sics.mspsim.chip.RFListener;
import se.sics.mspsim.chip.RFSource;
import se.sics.mspsim.cli.BasicAsyncCommand;
import se.sics.mspsim.cli.BasicCommand;
import se.sics.mspsim.cli.BasicLineCommand;
import se.sics.mspsim.cli.CommandBundle;
import se.sics.mspsim.cli.CommandContext;
import se.sics.mspsim.cli.CommandHandler;
import se.sics.mspsim.cli.ExecCommand;
import se.sics.mspsim.cli.FileTarget;
import se.sics.mspsim.core.Chip;
import se.sics.mspsim.core.MSP430;
import se.sics.mspsim.core.TimeEvent;
import se.sics.mspsim.util.ArgumentManager;
import se.sics.mspsim.util.ComponentRegistry;
import se.sics.mspsim.util.ConfigManager;
import se.sics.mspsim.util.PluginRepository;
import se.sics.mspsim.util.ServiceComponent;
import se.sics.mspsim.util.Utils;

public class MiscCommands
implements CommandBundle {
    private Hashtable<String, FileTarget> fileTargets = new Hashtable();

    @Override
    public void setupCommands(final ComponentRegistry registry, CommandHandler handler) {
        handler.registerCommand("grep", new BasicLineCommand("print lines matching the specified pattern", "[-i] [-v] <regexp>"){
            private PrintStream out;
            private Pattern pattern;
            private boolean isInverted;
            {
                this.isInverted = false;
            }

            @Override
            public int executeCommand(CommandContext context) {
                int index = 0;
                int flags = 0;
                while (index + 1 < context.getArgumentCount()) {
                    if ("-i".equals(context.getArgument(index))) {
                        flags |= 2;
                    } else if ("-v".equals(context.getArgument(index))) {
                        this.isInverted = true;
                    } else {
                        context.err.println("unknown option: " + context.getArgument(index));
                        return 1;
                    }
                    ++index;
                }
                this.out = context.out;
                this.pattern = Pattern.compile(context.getArgument(index), flags);
                return 0;
            }

            @Override
            public void lineRead(String line) {
                boolean isMatch = this.pattern.matcher(line).find();
                if (isMatch ^ this.isInverted) {
                    this.out.println(line);
                }
            }
        });
        handler.registerCommand("timestamp", new BasicLineCommand("print lines with timestamp prefixed", ""){
            private PrintStream out;
            private MSP430 cpu;
            long startTime;

            @Override
            public int executeCommand(CommandContext context) {
                this.cpu = (MSP430)registry.getComponent(MSP430.class);
                if (this.cpu == null) {
                    context.err.println("could not access the CPU.");
                    return 1;
                }
                this.out = context.out;
                this.startTime = System.currentTimeMillis() - (long)this.cpu.getTimeMillis();
                return 0;
            }

            @Override
            public void lineRead(String line) {
                this.out.println(Long.toString(this.startTime + (long)this.cpu.getTimeMillis()) + ' ' + line);
            }
        });
        handler.registerCommand("speed", new BasicCommand("set the speed factor for the CPU", "[factor]"){

            @Override
            public int executeCommand(CommandContext context) {
                MSP430 cpu = (MSP430)registry.getComponent(MSP430.class);
                if (cpu == null) {
                    context.err.println("could not access the CPU.");
                    return 1;
                }
                if (context.getArgumentCount() == 0) {
                    long rate = cpu.getSleepRate();
                    double d = (double)rate / 25000.0;
                    context.out.println("Speed factor is set to " + (double)((int)(d * 100.0 + 0.5)) / 100.0);
                } else {
                    double d = context.getArgumentAsDouble(0);
                    if (d > 0.0) {
                        long rate = (long)(25000.0 * d);
                        cpu.setSleepRate(rate);
                    } else {
                        context.err.println("Speed factor must be larger than zero.");
                        return 1;
                    }
                }
                return 0;
            }
        });
        handler.registerCommand("echo", new BasicCommand("echo arguments", ""){

            @Override
            public int executeCommand(CommandContext context) {
                StringBuilder sb = new StringBuilder();
                int n = context.getArgumentCount();
                for (int i = 0; i < n; ++i) {
                    if (i > 0) {
                        sb.append(' ');
                    }
                    sb.append(context.getArgument(i));
                }
                context.out.println(sb.toString());
                return 0;
            }
        });
        handler.registerCommand("source", new BasicCommand("run script", "[-v] <filename>"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int executeCommand(CommandContext context) {
                File fp;
                boolean verbose = false;
                if (context.getArgumentCount() > 1) {
                    verbose = "-v".equals(context.getArgument(0));
                }
                if (!(fp = new File(context.getArgument(context.getArgumentCount() - 1))).canRead()) {
                    context.err.println("could not find the script file '" + context.getArgument(0) + "'.");
                    return 1;
                }
                try {
                    FileInputStream infs = new FileInputStream(fp);
                    BufferedReader input = new BufferedReader(new InputStreamReader(infs));
                    try {
                        String line;
                        while ((line = input.readLine()) != null) {
                            if (verbose) {
                                context.out.println(line);
                            }
                            context.executeCommand(line);
                        }
                    }
                    finally {
                        input.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace(context.err);
                    return 1;
                }
                return 0;
            }
        });
        handler.registerCommand("repeat", new BasicAsyncCommand("repeat the specified command line", "[-t delay] [-c count] <command line>"){
            private MSP430 cpu;
            private int period;
            private int count;
            private int maxCount;
            private String commandLine;
            private boolean isRunning;
            {
                super(x0, x1);
                this.period = 1;
                this.count = 0;
                this.maxCount = -1;
                this.isRunning = true;
            }

            @Override
            public int executeCommand(final CommandContext context) {
                String a;
                int index = 0;
                while ((a = context.getArgument(index)).startsWith("-")) {
                    if (a.equals("-t")) {
                        this.period = context.getArgumentAsInt(index + 1);
                        index += 2;
                        continue;
                    }
                    if (a.equals("-c")) {
                        this.maxCount = context.getArgumentAsInt(index + 1);
                        index += 2;
                        continue;
                    }
                    context.err.println("illegal option: " + a);
                    return 1;
                }
                if (index + 1 < context.getArgumentCount()) {
                    context.err.println("too many arguments");
                    return 1;
                }
                this.commandLine = context.getArgument(index);
                this.cpu = (MSP430)registry.getComponent(MSP430.class);
                if (this.cpu == null) {
                    context.err.println("could not access the CPU.");
                    return 1;
                }
                this.cpu.scheduleTimeEventMillis(new TimeEvent(0L){

                    @Override
                    public void execute(long t) {
                        if (isRunning) {
                            count++;
                            context.executeCommand(commandLine);
                            if (maxCount <= 0 || count < maxCount) {
                                cpu.scheduleTimeEventMillis(this, (double)period * 1000.0);
                            } else {
                                this.stopCommand(context);
                            }
                        }
                    }
                }, (double)this.period * 1000.0);
                return 0;
            }

            @Override
            public void stopCommand(CommandContext context) {
                this.isRunning = false;
                context.err.println("[repeat exit: " + this.commandLine + ']');
                context.exit(0);
            }
        });
        handler.registerCommand("exec", new ExecCommand());
        handler.registerCommand("trig", new BasicLineCommand("trigg command when getting input", "<command>"){
            String command;
            CommandContext context;
            {
                this.command = null;
            }

            @Override
            public int executeCommand(CommandContext context) {
                StringBuilder sb = new StringBuilder();
                int n = context.getArgumentCount();
                for (int i = 0; i < n; ++i) {
                    if (i > 0) {
                        sb.append(' ');
                    }
                    sb.append(context.getArgument(i));
                }
                this.command = sb.toString();
                this.context = context;
                return 0;
            }

            @Override
            public void lineRead(String line) {
                this.context.executeCommand(this.command);
            }
        });
        handler.registerCommand("install", new BasicCommand("install and start a plugin", "ClassName [Name]"){

            @Override
            public int executeCommand(CommandContext context) {
                String className;
                String name = className = context.getArgument(0);
                if (context.getArgumentCount() > 1) {
                    name = context.getArgument(1);
                }
                if (registry.getComponent(name) != null) {
                    context.err.println("Another component with name " + name + " is already installed");
                    return 1;
                }
                Class<?> pluginClass = null;
                PluginRepository plugins = (PluginRepository)registry.getComponent("pluginRepository");
                try {
                    try {
                        pluginClass = plugins != null ? plugins.loadClass(className) : Class.forName(className);
                    }
                    catch (ClassNotFoundException e) {
                        String newClassName = "se.sics.mspsim.plugin." + className;
                        pluginClass = plugins != null ? plugins.loadClass(newClassName) : Class.forName(newClassName);
                    }
                    Object component = pluginClass.newInstance();
                    registry.registerComponent(name, component);
                    return 0;
                }
                catch (Exception e1) {
                    e1.printStackTrace(context.err);
                    return 1;
                }
            }
        });
        handler.registerCommand("service", new BasicCommand("handle service plugins", "[class name|service name] [start|stop]"){

            @Override
            public int executeCommand(CommandContext context) {
                if (context.getArgumentCount() == 0) {
                    ServiceComponent[] sc = (ServiceComponent[])registry.getAllComponents(ServiceComponent.class);
                    for (int i = 0; i < sc.length; ++i) {
                        context.out.printf(" %-20s %s\n", new Object[]{sc[i].getName(), sc[i].getStatus()});
                    }
                } else if (context.getArgumentCount() == 1) {
                    String name = context.getArgument(0);
                    ServiceComponent sc = MiscCommands.getServiceForName(registry, name);
                    if (sc != null) {
                        context.out.printf(" %-20s %s\n", new Object[]{sc.getName(), sc.getStatus()});
                    } else {
                        context.out.println("can not find service" + name);
                    }
                } else {
                    String name = context.getArgument(0);
                    String operation = context.getArgument(1);
                    if ("start".equals(operation)) {
                        ServiceComponent sc = MiscCommands.getServiceForName(registry, name);
                        if (sc != null) {
                            sc.start();
                            context.out.println("service " + sc.getName() + " started");
                        } else {
                            context.out.println("can not find service" + name);
                        }
                    } else if ("stop".equals(operation)) {
                        ServiceComponent sc = MiscCommands.getServiceForName(registry, name);
                        if (sc != null) {
                            sc.stop();
                            context.out.println("service " + sc.getName() + " stopped");
                        } else {
                            context.out.println("can not find service" + name);
                        }
                    }
                }
                return 0;
            }
        });
        handler.registerCommand("rflistener", new BasicLineCommand("an rflisteer", "[input|output] <rf-chip>"){
            CommandContext context;
            RFListener listener;
            final MSP430 cpu;
            {
                super(x0, x1);
                this.cpu = (MSP430)registry.getComponent(MSP430.class);
            }

            @Override
            public int executeCommand(CommandContext ctx) {
                this.context = ctx;
                String inout = this.context.getArgument(0);
                Chip chip = this.cpu.getChip(this.context.getArgument(1));
                if ("output".equals(inout)) {
                    if (chip instanceof RFSource) {
                        ((RFSource)((Object)chip)).setRFListener(new RFListener(){

                            @Override
                            public void receivedByte(byte data) {
                                context.out.println("" + Utils.hex8(data));
                            }
                        });
                    }
                } else if ("input".equals(inout)) {
                    this.listener = (RFListener)((Object)chip);
                } else {
                    this.context.err.println("Error: illegal type: " + inout);
                }
                return 0;
            }

            @Override
            public void lineRead(String line) {
                if (this.listener != null) {
                    byte[] data = Utils.hexconv(line);
                    this.context.out.println("Should send bytes to radio: " + line);
                    for (int i = 0; i < data.length; ++i) {
                        this.listener.receivedByte(data[i]);
                    }
                }
            }
        });
        handler.registerCommand("sysinfo", new BasicCommand("show info about the MSPSim system", "[-registry] [-config]"){

            @Override
            public int executeCommand(CommandContext context) {
                ArgumentManager config = (ArgumentManager)registry.getComponent("config");
                context.out.println("--------- System info ----------\n");
                context.out.println("MSPSim version: 0.97");
                context.out.println("Java version  : " + System.getProperty("java.version") + " " + System.getProperty("java.vendor"));
                context.out.println("Firmware      : " + config.getProperty("firmwareFile"));
                context.out.println("AutoloadScript: " + config.getProperty("autoloadScript"));
                context.out.println();
                if (context.getOption("registry")) {
                    context.out.println("--------- Registry info --------\n");
                    registry.printRegistry(context.out);
                }
                if (context.getOption("config")) {
                    context.out.println("--------- Configuration ---------\n");
                    config.print(context.out);
                }
                return 0;
            }
        });
        handler.registerCommand("quit", new BasicCommand("exit MSPSim", ""){

            @Override
            public int executeCommand(CommandContext context) {
                System.exit(0);
                return 0;
            }
        });
        handler.registerCommand("exit", new BasicCommand("exit MSPSim", ""){

            @Override
            public int executeCommand(CommandContext context) {
                System.exit(0);
                return 0;
            }
        });
        handler.registerCommand("set", new BasicCommand("set a config parameter", "<parameter> <value>"){

            @Override
            public int executeCommand(CommandContext context) {
                ConfigManager config = (ConfigManager)registry.getComponent("config");
                config.setProperty(context.getArgument(0), context.getArgument(1));
                context.out.println("set " + context.getArgument(0) + " to " + context.getArgument(1));
                return 0;
            }
        });
    }

    private static ServiceComponent getServiceForName(ComponentRegistry registry, String name) {
        Object o = registry.getComponent(name);
        if (o instanceof ServiceComponent) {
            return (ServiceComponent)o;
        }
        return null;
    }
}

