/*
 * Decompiled with CFR 0.152.
 */
package se.sics.mspsim.cli;

import java.io.IOException;
import java.util.Hashtable;
import se.sics.mspsim.cli.BasicLineCommand;
import se.sics.mspsim.cli.CommandContext;
import se.sics.mspsim.cli.FileTarget;

public class FileTargetCommand
extends BasicLineCommand {
    private final Hashtable<String, FileTarget> fileTargets;
    private final boolean print;
    private final boolean append;
    private FileTarget ft;
    private CommandContext context;

    public FileTargetCommand(Hashtable<String, FileTarget> fileTargets, String name, String desc, boolean print, boolean append) {
        super(name, desc);
        this.fileTargets = fileTargets;
        this.print = print;
        this.append = append;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeCommand(CommandContext context) {
        this.context = context;
        String fileName = context.getArgument(0);
        Hashtable<String, FileTarget> hashtable = this.fileTargets;
        synchronized (hashtable) {
            this.ft = this.fileTargets.get(fileName);
            if (this.ft == null) {
                try {
                    this.ft = new FileTarget(this.fileTargets, fileName, this.append);
                }
                catch (IOException e) {
                    e.printStackTrace(context.err);
                    return -1;
                }
            } else if (!this.append) {
                context.err.println("File already opened: can not overwrite");
                return -1;
            }
            this.ft.addContext(context);
        }
        return 0;
    }

    @Override
    public void lineRead(String line) {
        if (this.print) {
            this.context.out.println(line);
        }
        this.ft.lineRead(this.context, line);
    }

    @Override
    public void stopCommand(CommandContext context) {
        if (this.ft != null) {
            this.ft.removeContext(context);
        }
    }
}

