/*
 * Decompiled with CFR 0.152.
 */
package se.sics.mspsim.cli;

import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import se.sics.mspsim.cli.CommandContext;

public class FileTarget {
    private static final boolean DEBUG = false;
    private final Hashtable<String, FileTarget> fileTargets;
    private final String name;
    private final FileWriter out;
    private ArrayList<CommandContext> contexts = new ArrayList();

    public FileTarget(Hashtable<String, FileTarget> fileTargets, String name, boolean append) throws IOException {
        this.fileTargets = fileTargets;
        this.out = new FileWriter(name, append);
        this.name = name;
        fileTargets.put(name, this);
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStatus() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name);
        Hashtable<String, FileTarget> hashtable = this.fileTargets;
        synchronized (hashtable) {
            if (this.contexts != null) {
                sb.append(" \tPIDs: [");
                int n = this.contexts.size();
                for (int i = 0; i < n; ++i) {
                    int pid = this.contexts.get(i).getPID();
                    if (i > 0) {
                        sb.append(',');
                    }
                    if (pid < 0) {
                        sb.append('?');
                        continue;
                    }
                    sb.append(pid);
                }
                sb.append(']');
            }
        }
        return sb.toString();
    }

    public void lineRead(CommandContext context, String line) {
        if (line == null) {
            this.removeContext(context);
        } else {
            try {
                this.out.write(line);
                this.out.write(10);
                this.out.flush();
            }
            catch (IOException e) {
                e.printStackTrace(context.err);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addContext(CommandContext context) {
        boolean added = false;
        Hashtable<String, FileTarget> hashtable = this.fileTargets;
        synchronized (hashtable) {
            if (this.contexts != null) {
                this.contexts.add(context);
                added = true;
            }
        }
        if (!added) {
            context.kill();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeContext(CommandContext context) {
        boolean close = false;
        Hashtable<String, FileTarget> hashtable = this.fileTargets;
        synchronized (hashtable) {
            if (this.contexts != null && this.contexts.remove(context) && this.contexts.size() == 0) {
                close = true;
            }
        }
        if (close) {
            this.close(false);
        }
    }

    public void close() {
        this.close(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(boolean forceClose) {
        ArrayList<CommandContext> list;
        Hashtable<String, FileTarget> hashtable = this.fileTargets;
        synchronized (hashtable) {
            if (this.contexts == null) {
                return;
            }
            if (this.contexts.size() > 0 && !forceClose) {
                return;
            }
            list = this.contexts;
            this.contexts = null;
            if (this.fileTargets.get(this.name) == this) {
                this.fileTargets.remove(this.name);
            }
        }
        if (list != null) {
            for (CommandContext context : list) {
                context.kill();
            }
        }
        try {
            this.out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

