/*
 * Decompiled with CFR 0.152.
 */
package se.sics.mspsim.cli;

import java.util.Hashtable;
import se.sics.mspsim.cli.BasicCommand;
import se.sics.mspsim.cli.CommandBundle;
import se.sics.mspsim.cli.CommandContext;
import se.sics.mspsim.cli.CommandHandler;
import se.sics.mspsim.cli.FileTarget;
import se.sics.mspsim.cli.FileTargetCommand;
import se.sics.mspsim.util.ComponentRegistry;

public class FileCommands
implements CommandBundle {
    private final Hashtable<String, FileTarget> fileTargets = new Hashtable();

    @Override
    public void setupCommands(ComponentRegistry registry, CommandHandler handler) {
        handler.registerCommand(">", new FileTargetCommand(this.fileTargets, null, "<filename>", false, false));
        handler.registerCommand(">>", new FileTargetCommand(this.fileTargets, null, "<filename>", false, true));
        handler.registerCommand("tee", new FileTargetCommand(this.fileTargets, "redirect to file and standard out", "<filename>", true, true));
        handler.registerCommand("fclose", new BasicCommand("close the specified file", "<filename>"){

            @Override
            public int executeCommand(CommandContext context) {
                String name = context.getArgument(0);
                FileTarget ft = (FileTarget)FileCommands.this.fileTargets.get(name);
                if (ft != null) {
                    context.out.println("Closing file " + name);
                    ft.close();
                    return 0;
                }
                context.err.println("Could not find the open file " + name);
                return 1;
            }
        });
        handler.registerCommand("files", new BasicCommand("list open files", ""){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int executeCommand(CommandContext context) {
                FileTarget[] files = null;
                Hashtable hashtable = FileCommands.this.fileTargets;
                synchronized (hashtable) {
                    if (FileCommands.this.fileTargets.size() > 0) {
                        files = FileCommands.this.fileTargets.values().toArray(new FileTarget[FileCommands.this.fileTargets.size()]);
                    }
                }
                if (files == null) {
                    context.out.println("There are no open files.");
                } else {
                    for (FileTarget type : files) {
                        context.out.println(type.getStatus());
                    }
                }
                return 0;
            }
        });
    }
}

