/*
 * Decompiled with CFR 0.152.
 */
package se.sics.mspsim.cli;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import se.sics.mspsim.cli.BasicLineCommand;
import se.sics.mspsim.cli.CommandContext;

public class ExecCommand
extends BasicLineCommand {
    private CommandContext context;
    private Process process;
    private Runner runner;
    private Reader stdout;
    private Reader stderr;
    private PrintStream output;

    public ExecCommand() {
        super("execute the specified command", "<cmd> [args...]");
    }

    @Override
    public int executeCommand(CommandContext context) {
        this.context = context;
        String[] args = new String[context.getArgumentCount()];
        int n = args.length;
        for (int i = 0; i < n; ++i) {
            args[i] = context.getArgument(i);
        }
        String name = args[0];
        try {
            this.process = Runtime.getRuntime().exec(args);
            this.stdout = new Reader(name + ".out", this, this.process.getInputStream(), context.out);
            this.stdout.start();
            this.stderr = new Reader(name + ".err", this, this.process.getErrorStream(), context.err);
            this.stderr.start();
            this.output = new PrintStream(this.process.getOutputStream());
            this.runner = new Runner(name + ".proc", this);
            this.runner.start();
        }
        catch (Exception e) {
            context.err.println("failed to start command: " + e.getMessage());
            return 1;
        }
        return 0;
    }

    @Override
    public void lineRead(String line) {
        System.out.println("Exec: sending a line: " + line);
        this.output.println(line);
        this.output.flush();
    }

    @Override
    public void stopCommand(CommandContext context) {
        if (this.runner != null && this.runner.isRunning) {
            this.process.destroy();
        } else {
            context.exit(0);
        }
    }

    private static class Reader
    extends Thread {
        private ExecCommand command;
        private PrintStream out;
        private BufferedReader input;

        public Reader(String name, ExecCommand command, InputStream input, PrintStream out) {
            super(name);
            this.command = command;
            this.input = new BufferedReader(new InputStreamReader(input));
            this.out = out;
        }

        @Override
        public void run() {
            try {
                String line;
                while ((line = this.input.readLine()) != null) {
                    this.out.println(line);
                }
            }
            catch (Exception e) {
                ((ExecCommand)this.command).context.err.println("* " + this.getName() + " failed: " + e.getMessage());
            }
        }
    }

    private static class Runner
    extends Thread {
        public ExecCommand command;
        public boolean isRunning;

        public Runner(String name, ExecCommand command) {
            super(name);
            this.command = command;
            this.isRunning = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int exitValue = -1;
            this.isRunning = true;
            try {
                this.command.process.waitFor();
                for (int i = 0; i < 5 && (this.command.stdout.isAlive() || this.command.stderr.isAlive()); ++i) {
                    Thread.sleep(300L);
                }
                exitValue = this.command.process.exitValue();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            finally {
                this.isRunning = false;
                this.command.context.exit(exitValue);
            }
        }
    }
}

