/*
 * Decompiled with CFR 0.152.
 */
package se.sics.mspsim.cli;

import se.sics.mspsim.cli.BasicAsyncCommand;
import se.sics.mspsim.cli.BasicCommand;
import se.sics.mspsim.cli.Command;
import se.sics.mspsim.cli.CommandBundle;
import se.sics.mspsim.cli.CommandContext;
import se.sics.mspsim.cli.CommandHandler;
import se.sics.mspsim.core.CPUMonitor;
import se.sics.mspsim.core.Chip;
import se.sics.mspsim.core.DbgInstruction;
import se.sics.mspsim.core.DisAsm;
import se.sics.mspsim.core.EmulationException;
import se.sics.mspsim.core.MSP430;
import se.sics.mspsim.core.MSP430Constants;
import se.sics.mspsim.core.Memory;
import se.sics.mspsim.platform.GenericNode;
import se.sics.mspsim.util.ComponentRegistry;
import se.sics.mspsim.util.DebugInfo;
import se.sics.mspsim.util.ELF;
import se.sics.mspsim.util.GDBStubs;
import se.sics.mspsim.util.MapEntry;
import se.sics.mspsim.util.Utils;

public class DebugCommands
implements CommandBundle {
    private long lastCall = 0L;
    private long lastWall = 0L;
    private ComponentRegistry registry;

    private ELF getELF() {
        return (ELF)this.registry.getComponent(ELF.class);
    }

    @Override
    public void setupCommands(ComponentRegistry registry, CommandHandler ch) {
        this.registry = registry;
        final MSP430 cpu = (MSP430)registry.getComponent(MSP430.class);
        final GenericNode node = (GenericNode)registry.getComponent("node");
        if (cpu != null) {
            ch.registerCommand("break", new BasicAsyncCommand("add a breakpoint to a given address or symbol", "<address or symbol>"){
                int address;
                {
                    super(x0, x1);
                    this.address = 0;
                }

                @Override
                public int executeCommand(final CommandContext context) {
                    int baddr = context.getArgumentAsAddress(0);
                    if (baddr < 0) {
                        context.err.println("unknown symbol: " + context.getArgument(0));
                        return 1;
                    }
                    this.address = baddr;
                    cpu.setBreakPoint(this.address, new CPUMonitor(){

                        @Override
                        public void cpuAction(int type, int adr, int data) {
                            context.out.println("*** Break at $" + Utils.hex16(adr));
                            cpu.stop();
                        }
                    });
                    context.out.println("Breakpoint set at $" + Utils.hex16(baddr));
                    return 0;
                }

                @Override
                public void stopCommand(CommandContext context) {
                    cpu.clearBreakPoint(this.address);
                }
            });
            ch.registerCommand("watch", new BasicAsyncCommand("add a write/read watch to a given address or symbol", "<address or symbol> [length] [char | hex | break]"){
                int mode;
                int address;
                int length;
                {
                    super(x0, x1);
                    this.mode = 0;
                    this.address = 0;
                    this.length = 1;
                }

                @Override
                public int executeCommand(final CommandContext context) {
                    int baddr = context.getArgumentAsAddress(0);
                    if (baddr == -1) {
                        context.err.println("unknown symbol: " + context.getArgument(0));
                        return -1;
                    }
                    if (context.getArgumentCount() > 1) {
                        for (int i = 1; i < context.getArgumentCount(); ++i) {
                            String modeStr = context.getArgument(i);
                            if (Character.isDigit(modeStr.charAt(0))) {
                                this.length = Integer.parseInt(modeStr);
                                continue;
                            }
                            if ("char".equals(modeStr)) {
                                this.mode = 1;
                                continue;
                            }
                            if ("break".equals(modeStr)) {
                                this.mode = 2;
                                continue;
                            }
                            if (!"hex".equals(modeStr)) continue;
                            this.mode = 3;
                        }
                    }
                    CPUMonitor monitor = new CPUMonitor(){

                        @Override
                        public void cpuAction(int type, int adr, int data) {
                            if (mode == 0 || mode == 2) {
                                int pc = cpu.readRegister(0);
                                String adrStr = DebugCommands.getSymOrAddr(context, adr);
                                String pcStr = DebugCommands.getSymOrAddrELF(DebugCommands.this.getELF(), pc);
                                String op = "op";
                                if (type == 1) {
                                    op = "Read";
                                } else if (type == 2) {
                                    op = "Write";
                                }
                                context.out.println("*** " + op + " from " + pcStr + ": " + adrStr + " = " + data);
                                if (mode == 2) {
                                    cpu.stop();
                                }
                            } else if (length > 1) {
                                for (int i = address; i < address + length; ++i) {
                                    context.out.print(Utils.toString(cpu.memory[i], 0, mode == 1 ? 1 : 2));
                                }
                                context.out.println();
                            } else {
                                context.out.print(Utils.toString(data, 0, mode == 1 ? 1 : 2));
                            }
                        }
                    };
                    this.address = baddr;
                    cpu.setBreakPoint(this.address, monitor);
                    if (this.length > 1) {
                        for (int i = 1; i < this.length; ++i) {
                            cpu.setBreakPoint(this.address + i, monitor);
                        }
                    }
                    context.out.println("Watch set at $" + Utils.hex16(baddr));
                    return 0;
                }

                @Override
                public void stopCommand(CommandContext context) {
                    cpu.clearBreakPoint(this.address);
                    context.exit(0);
                }
            });
            ch.registerCommand("watchreg", new BasicAsyncCommand("add a write watch to a given register", "<register> [int]"){
                int mode;
                int register;
                {
                    super(x0, x1);
                    this.mode = 0;
                    this.register = 0;
                }

                @Override
                public int executeCommand(final CommandContext context) {
                    this.register = context.getArgumentAsRegister(0);
                    if (this.register < 0) {
                        return -1;
                    }
                    if (context.getArgumentCount() > 1) {
                        String modeStr = context.getArgument(1);
                        if ("int".equals(modeStr)) {
                            this.mode = 1;
                        } else {
                            context.err.println("illegal argument: " + modeStr);
                            return -1;
                        }
                    }
                    cpu.setRegisterWriteMonitor(this.register, new CPUMonitor(){

                        @Override
                        public void cpuAction(int type, int adr, int data) {
                            if (mode == 0) {
                                int pc = cpu.readRegister(0);
                                String adrStr = DebugCommands.getRegisterName(register);
                                String pcStr = DebugCommands.getSymOrAddrELF(DebugCommands.this.getELF(), pc);
                                context.out.println("*** Write from " + pcStr + ": " + adrStr + " = " + data);
                            } else {
                                context.out.println(data);
                            }
                        }
                    });
                    context.out.println("Watch set for register " + DebugCommands.getRegisterName(this.register));
                    return 0;
                }

                @Override
                public void stopCommand(CommandContext context) {
                    cpu.clearBreakPoint(this.register);
                }
            });
            ch.registerCommand("clear", new Command(){

                @Override
                public int executeCommand(CommandContext context) {
                    int baddr = context.getArgumentAsAddress(0);
                    cpu.setBreakPoint(baddr, null);
                    return 0;
                }

                @Override
                public String getArgumentHelp(String commandName) {
                    return "<address or symbol>";
                }

                @Override
                public String getCommandHelp(String commandName) {
                    return "clear a breakpoint or watch from a given address or symbol";
                }
            });
            ch.registerCommand("symbol", new BasicCommand("list matching symbols", "<regexp>"){

                @Override
                public int executeCommand(CommandContext context) {
                    String regExp = context.getArgument(0);
                    MapEntry[] entries = context.getMapTable().getEntries(regExp);
                    for (int i = 0; i < entries.length; ++i) {
                        MapEntry mapEntry = entries[i];
                        int address = mapEntry.getAddress();
                        context.out.println(" " + mapEntry.getName() + " at $" + Utils.hex16(address) + " (" + Utils.hex8(cpu.memory[address]) + " " + Utils.hex8(cpu.memory[address + 1]) + ")");
                    }
                    return 0;
                }
            });
            ch.registerCommand("line", new BasicCommand("print line number of address/symbol", "<address or symbol>"){

                @Override
                public int executeCommand(CommandContext context) {
                    int adr = context.getArgumentAsAddress(0);
                    DebugInfo di = DebugCommands.this.getELF().getDebugInfo(adr);
                    if (di == null) {
                        di = DebugCommands.this.getELF().getDebugInfo(adr + 1);
                    }
                    if (di != null) {
                        di.getLine();
                        context.out.println(di);
                    } else {
                        context.err.println("No line number found for: " + context.getArgument(0));
                    }
                    return 0;
                }
            });
            if (node != null) {
                ch.registerCommand("stop", new BasicCommand("stop the CPU", ""){

                    @Override
                    public int executeCommand(CommandContext context) {
                        node.stop();
                        context.out.println("CPU stopped at: $" + Utils.hex16(cpu.readRegister(0)));
                        return 0;
                    }
                });
                ch.registerCommand("start", new BasicCommand("start the CPU", ""){

                    @Override
                    public int executeCommand(CommandContext context) {
                        node.start();
                        return 0;
                    }
                });
                ch.registerCommand("step", new BasicCommand("single step the CPU", "[number of instructions]"){

                    @Override
                    public int executeCommand(CommandContext context) {
                        int nr = context.getArgumentCount() > 0 ? context.getArgumentAsInt(0) : 1;
                        long cyc = cpu.cycles;
                        if (cpu.isRunning()) {
                            context.err.println("Can not single step when emulation is running.");
                            return -1;
                        }
                        try {
                            node.step(nr);
                        }
                        catch (Exception e) {
                            e.printStackTrace(context.out);
                        }
                        context.out.println("CPU stepped to: $" + Utils.hex16(cpu.readRegister(0)) + " in " + (cpu.cycles - cyc) + " cycles (" + cpu.cycles + ")");
                        return 0;
                    }
                });
                ch.registerCommand("stepmicro", new BasicCommand("single the CPU specified no micros", "<micro skip> <micro step>"){

                    @Override
                    public int executeCommand(CommandContext context) {
                        int nr = context.getArgumentCount() > 0 ? context.getArgumentAsInt(0) : 1;
                        long cyc = cpu.cycles;
                        if (cpu.isRunning()) {
                            context.err.println("Can not single step when emulation is running.");
                            return -1;
                        }
                        long nxt = 0L;
                        try {
                            nxt = cpu.stepMicros(context.getArgumentAsLong(0), context.getArgumentAsLong(1));
                        }
                        catch (Exception e) {
                            e.printStackTrace(context.out);
                        }
                        context.out.println("CPU stepped to: $" + Utils.hex16(cpu.readRegister(0)) + " in " + (cpu.cycles - cyc) + " cycles (" + cpu.cycles + ") - next exec time: " + nxt);
                        return 0;
                    }
                });
                ch.registerCommand("stack", new BasicCommand("show stack info", ""){

                    @Override
                    public int executeCommand(CommandContext context) {
                        int stackEnd = context.getMapTable().heapStartAddress;
                        int stackStart = context.getMapTable().stackStartAddress;
                        int current = cpu.readRegister(1);
                        context.out.println("Current stack: $" + Utils.hex16(current) + " (" + (stackStart - current) + " used of " + (stackStart - stackEnd) + ')');
                        return 0;
                    }
                });
                ch.registerCommand("print", new BasicCommand("print value of an address or symbol", "<address or symbol>"){

                    @Override
                    public int executeCommand(CommandContext context) {
                        int adr = context.getArgumentAsAddress(0);
                        if (adr != -1) {
                            try {
                                context.out.println("" + context.getArgument(0) + " = " + Utils.hex16(cpu.read(adr, adr >= 256)));
                            }
                            catch (Exception e) {
                                e.printStackTrace(context.out);
                            }
                            return 0;
                        }
                        context.err.println("unknown symbol: " + context.getArgument(0));
                        return 1;
                    }
                });
                ch.registerCommand("printreg", new BasicCommand("print value of an register", "<register>"){

                    @Override
                    public int executeCommand(CommandContext context) {
                        int register = context.getArgumentAsRegister(0);
                        if (register >= 0) {
                            context.out.println(context.getArgument(0) + " = $" + Utils.hex16(cpu.readRegister(register)));
                            return 0;
                        }
                        return -1;
                    }
                });
                ch.registerCommand("reset", new BasicCommand("reset the CPU", ""){

                    @Override
                    public int executeCommand(CommandContext context) {
                        cpu.reset();
                        return 0;
                    }
                });
                ch.registerCommand("time", new BasicCommand("print the elapse time and cycles", ""){

                    @Override
                    public int executeCommand(CommandContext context) {
                        long time = (long)cpu.getTimeMillis();
                        long wallDiff = System.currentTimeMillis() - DebugCommands.this.lastWall;
                        context.out.println("Emulated time elapsed: " + time + "(ms)  since last: " + (time - DebugCommands.this.lastCall) + " ms" + " wallTime: " + wallDiff + " ms speed factor: " + (wallDiff == 0L ? "N/A" : "" + (time - DebugCommands.this.lastCall) / wallDiff));
                        DebugCommands.this.lastCall = time;
                        DebugCommands.this.lastWall = System.currentTimeMillis();
                        return 0;
                    }
                });
                ch.registerCommand("mem", new BasicCommand("dump memory", "<start address> <num_entries> [type] [hex|char]"){

                    @Override
                    public int executeCommand(CommandContext context) {
                        int start = context.getArgumentAsAddress(0);
                        int count = context.getArgumentAsInt(1);
                        int mode = 3;
                        int type = 1;
                        boolean signed = false;
                        if (context.getArgumentCount() > 2) {
                            int pos = 2;
                            int acount = context.getArgumentCount();
                            if (acount > 4) {
                                acount = 4;
                            }
                            while (pos < acount) {
                                String tS;
                                if ("ubyte".equals(tS = context.getArgument(pos++))) continue;
                                if ("byte".equals(tS)) {
                                    type = 0;
                                    continue;
                                }
                                if ("word".equals(tS)) {
                                    type = 2;
                                    continue;
                                }
                                if ("uword".equals(tS)) {
                                    type = 3;
                                    continue;
                                }
                                if ("hex".equals(tS)) {
                                    mode = 2;
                                    continue;
                                }
                                if (!"char".equals(tS)) continue;
                                mode = 1;
                                type = 0;
                            }
                        }
                        for (int i = 0; i < count; ++i) {
                            int data = 0;
                            data = cpu.memory[start++];
                            if (Utils.size(type) == 2) {
                                data += cpu.memory[start++] << 8;
                            }
                            context.out.print((mode != 1 ? " " : "") + Utils.toString(data, type, mode));
                        }
                        context.out.println();
                        return 0;
                    }
                });
                ch.registerCommand("mset", new BasicCommand("set memory", "<address> [type] <value> [value ...]"){

                    @Override
                    public int executeCommand(CommandContext context) {
                        int i;
                        int count = context.getArgumentCount();
                        int adr = context.getArgumentAsAddress(0);
                        String arg2 = context.getArgument(1);
                        int type = 0;
                        int mode = 3;
                        boolean typeRead = false;
                        if (count > 2) {
                            if ("char".equals(arg2)) {
                                mode = 1;
                                typeRead = true;
                            }
                            if ("word".equals(arg2)) {
                                type = 2;
                                typeRead = true;
                            }
                        }
                        int n = i = typeRead ? 2 : 1;
                        while (i < count) {
                            if (mode == 3) {
                                int val = context.getArgumentAsInt(i);
                                boolean word = Utils.size(type) == 2 | val > 255;
                                try {
                                    cpu.write(adr, val, word);
                                    adr += word ? 2 : 1;
                                }
                                catch (EmulationException e) {
                                    e.printStackTrace(context.out);
                                }
                            } else if (mode == 1) {
                                String data = context.getArgument(i);
                                for (int j = 0; j < data.length(); ++j) {
                                    cpu.write(adr++, data.charAt(j) & 0xFF, false);
                                }
                            }
                            ++i;
                        }
                        return 0;
                    }
                });
                ch.registerCommand("xmem", new BasicCommand("dump flash memory", "<start address> <num_entries> [type]"){

                    @Override
                    public int executeCommand(CommandContext context) {
                        Memory xmem = (Memory)DebugCommands.this.registry.getComponent("xmem");
                        if (xmem == null) {
                            context.err.println("No xmem component registered");
                            return 0;
                        }
                        int start = context.getArgumentAsAddress(0);
                        int count = context.getArgumentAsInt(1);
                        int size = 1;
                        boolean signed = false;
                        if (context.getArgumentCount() > 2) {
                            String tS = context.getArgument(2);
                            if ("byte".equals(tS)) {
                                signed = true;
                            } else if ("word".equals(tS)) {
                                signed = true;
                                size = 2;
                            } else if ("uword".equals(tS)) {
                                size = 2;
                            }
                        }
                        for (int i = 0; i < count; ++i) {
                            int data = 0;
                            data = xmem.readByte(start++);
                            if (size == 2) {
                                data += xmem.readByte(start++) << 8;
                            }
                            context.out.print(" " + data);
                        }
                        context.out.println();
                        return 0;
                    }
                });
                ch.registerCommand("xmset", new BasicCommand("set memory", "<address> <value> [type]"){

                    @Override
                    public int executeCommand(CommandContext context) {
                        boolean word;
                        Memory xmem = (Memory)DebugCommands.this.registry.getComponent("xmem");
                        if (xmem == null) {
                            context.err.println("No xmem component registered");
                            return 0;
                        }
                        int adr = context.getArgumentAsAddress(0);
                        int val = context.getArgumentAsInt(1);
                        boolean bl = word = val > 255;
                        if (word) {
                            xmem.writeByte(adr, val >> 8);
                            val &= 0xFF;
                            ++adr;
                        }
                        xmem.writeByte(adr, val & 0xFF);
                        return 0;
                    }
                });
                ch.registerCommand("gdbstubs", new BasicCommand("open up a gdb stubs server for GDB remote debugging", "port"){
                    private GDBStubs stubs;
                    {
                        super(x0, x1);
                        this.stubs = null;
                    }

                    @Override
                    public int executeCommand(CommandContext context) {
                        if (this.stubs != null) {
                            context.err.println("GDBStubs already open");
                        } else {
                            int port = context.getArgumentAsInt(0);
                            this.stubs = new GDBStubs();
                            this.stubs.setupServer(cpu, port);
                        }
                        return 0;
                    }
                });
                ch.registerCommand("loggable", new BasicCommand("list loggable objects", ""){

                    @Override
                    public int executeCommand(CommandContext context) {
                        Chip[] chips = cpu.getChips();
                        for (int i = 0; i < chips.length; ++i) {
                            context.out.println(chips[i].getName());
                        }
                        return 0;
                    }
                });
                ch.registerCommand("log", new BasicAsyncCommand("log a loggable object", "<loggable>"){
                    Chip chip;
                    {
                        super(x0, x1);
                        this.chip = null;
                    }

                    @Override
                    public int executeCommand(CommandContext context) {
                        this.chip = cpu.getChip(context.getArgument(0));
                        if (this.chip == null) {
                            context.err.println("Can not find loggable: " + context.getArgument(0));
                        }
                        this.chip.setLogStream(context.out);
                        return 0;
                    }

                    @Override
                    public void stopCommand(CommandContext context) {
                        this.chip.clearLogStream();
                    }
                });
                ch.registerCommand("trace", new BasicCommand("store a trace of execution positions.", "<trace size | show>"){

                    @Override
                    public int executeCommand(CommandContext context) {
                        if ("show".equals(context.getArgument(0))) {
                            int size = cpu.getTraceSize();
                            DisAsm disAsm = cpu.getDisAsm();
                            for (int i = 0; i < size; ++i) {
                                int pc = cpu.getBackTrace(size - 1 - i);
                                DbgInstruction inst = disAsm.getDbgInstruction(pc, cpu);
                                inst.setPos(pc);
                                System.out.println(inst);
                            }
                        } else {
                            cpu.setTrace(context.getArgumentAsInt(0));
                        }
                        return 0;
                    }
                });
                ch.registerCommand("events", new BasicCommand("print event queues", ""){

                    @Override
                    public int executeCommand(CommandContext context) {
                        cpu.printEventQueues(context.out);
                        return 0;
                    }
                });
            }
        }
    }

    private static String getSymOrAddr(CommandContext context, int adr) {
        MapEntry me = context.getMapTable().getEntry(adr);
        if (me != null) {
            return me.getName();
        }
        return Utils.hex16(adr);
    }

    private static String getSymOrAddrELF(ELF elf, int adr) {
        DebugInfo me = elf.getDebugInfo(adr);
        if (me != null) {
            return me.toString();
        }
        return Utils.hex16(adr);
    }

    private static String getRegisterName(int register) {
        if (register >= 0 && register < MSP430Constants.REGISTER_NAMES.length) {
            return MSP430Constants.REGISTER_NAMES[register];
        }
        return "R" + register;
    }
}

