/*
 * Decompiled with CFR 0.152.
 */
package se.sics.mspsim.cli;

import java.util.ArrayList;

public class CommandParser {
    private static final int TEXT = 0;
    private static final int ARG = 1;
    private static final int QUOTE = 2;

    private CommandParser() {
    }

    public static String[][] parseCommandLine(String line) {
        return CommandParser.parseLine(line, true, true);
    }

    public static String[] parseLine(String line) {
        String[][] lines = CommandParser.parseLine(line, false, false);
        if (lines != null && lines.length > 0) {
            return lines[0];
        }
        return null;
    }

    public static String[][] parseLine(String line, boolean handlePipes, boolean handleRedirect) {
        if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') {
            return null;
        }
        ArrayList<String[]> list = new ArrayList<String[]>();
        ArrayList<String> args = new ArrayList<String>();
        StringBuilder sb = null;
        String redirectCommand = null;
        int redirectFile = -1;
        int state = 0;
        int index = 0;
        char quote = '\u0000';
        int n = line.length();
        block6: for (int i = 0; i < n; ++i) {
            char c = line.charAt(i);
            if (c <= ' ') {
                if (state != 1) continue;
                if (sb == null) {
                    args.add(line.substring(index, i));
                } else {
                    args.add(sb.append(line.substring(index, i)).toString());
                    sb = null;
                }
                state = 0;
                continue;
            }
            switch (c) {
                case '\\': {
                    if (++i >= n) {
                        throw new IllegalArgumentException("unexpected end of line");
                    }
                    if (state == 0) {
                        state = 1;
                    } else {
                        if (sb == null) {
                            sb = new StringBuilder();
                        }
                        sb.append(line.substring(index, i - 1));
                    }
                    index = i;
                    continue block6;
                }
                case '\"': 
                case '\'': {
                    if (state == 2) {
                        if (c != quote) continue block6;
                        if (sb == null) {
                            args.add(line.substring(index, i));
                        } else {
                            args.add(sb.append(line.substring(index, i)).toString());
                            sb = null;
                        }
                        state = 0;
                        continue block6;
                    }
                    if (state == 1) {
                        if (sb == null) {
                            args.add(line.substring(index, i));
                        } else {
                            args.add(sb.append(line.substring(index, i)).toString());
                            sb = null;
                        }
                    }
                    index = i + 1;
                    state = 2;
                    quote = c;
                    continue block6;
                }
                case '>': {
                    if (!handleRedirect) {
                        if (state != 0) continue block6;
                        index = i;
                        state = 1;
                        continue block6;
                    }
                    if (state == 2) continue block6;
                    if (state == 1) {
                        if (sb == null) {
                            args.add(line.substring(index, i));
                        } else {
                            args.add(sb.append(line.substring(index, i)).toString());
                            sb = null;
                        }
                        state = 0;
                    }
                    if (redirectCommand == null) {
                        redirectCommand = ">";
                        redirectFile = args.size();
                        continue block6;
                    }
                    if (state == 0 && redirectFile == args.size()) {
                        redirectCommand = redirectCommand + '>';
                        continue block6;
                    }
                    throw new IllegalArgumentException("redirected twice");
                }
                case '|': {
                    if (!handlePipes) {
                        if (state != 0) continue block6;
                        index = i;
                        state = 1;
                        continue block6;
                    }
                    if (state == 2) continue block6;
                    if (state == 1) {
                        if (sb == null) {
                            args.add(line.substring(index, i));
                        } else {
                            args.add(sb.append(line.substring(index, i)).toString());
                            sb = null;
                        }
                    }
                    state = 0;
                    if (args.size() == 0) {
                        throw new IllegalArgumentException("empty command");
                    }
                    if (redirectCommand != null) {
                        throw new IllegalArgumentException("pipe can not follow redirection");
                    }
                    list.add(args.toArray(new String[args.size()]));
                    args.clear();
                    continue block6;
                }
                default: {
                    if (state != 0) continue block6;
                    index = i;
                    state = 1;
                }
            }
        }
        if (state == 2) {
            throw new IllegalArgumentException("unexpected end of line");
        }
        if (state == 1) {
            if (sb == null) {
                args.add(line.substring(index));
            } else {
                args.add(sb.append(line.substring(index)).toString());
            }
        }
        String redirectFilename = null;
        if (redirectCommand != null) {
            if (args.size() <= redirectFile) {
                throw new IllegalArgumentException("no redirect target");
            }
            redirectFilename = (String)args.remove(redirectFile);
        }
        if (args.size() > 0) {
            list.add(args.toArray(new String[args.size()]));
        }
        if (redirectCommand != null) {
            list.add(new String[]{redirectCommand, redirectFilename});
        }
        return (String[][])list.toArray((T[])new String[list.size()][]);
    }

    public static String toString(String[] parts, int start, int end) {
        StringBuilder sb = new StringBuilder();
        for (int i = start; i < end; ++i) {
            if (i > start) {
                sb.append(' ');
            }
            sb.append(parts[i]);
        }
        return sb.toString();
    }
}

