/*
 * Decompiled with CFR 0.152.
 */
package se.sics.mspsim.cli;

import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import se.sics.mspsim.cli.AsyncCommand;
import se.sics.mspsim.cli.BasicCommand;
import se.sics.mspsim.cli.Command;
import se.sics.mspsim.cli.CommandBundle;
import se.sics.mspsim.cli.CommandContext;
import se.sics.mspsim.cli.CommandParser;
import se.sics.mspsim.cli.LineListener;
import se.sics.mspsim.cli.LineOutputStream;
import se.sics.mspsim.cli.ScriptCommand;
import se.sics.mspsim.util.ActiveComponent;
import se.sics.mspsim.util.ComponentRegistry;
import se.sics.mspsim.util.MapTable;

public class CommandHandler
implements ActiveComponent,
LineListener {
    private String scriptDirectory = "scripts";
    private Hashtable<String, Command> commands = new Hashtable();
    protected final PrintStream out;
    protected final PrintStream err;
    private MapTable mapTable;
    private ComponentRegistry registry;
    private ArrayList<CommandContext[]> currentAsyncCommands = new ArrayList();
    private int pidCounter = 0;

    public CommandHandler(PrintStream out, PrintStream err) {
        this.out = out;
        this.err = err;
        this.registerCommands();
    }

    private MapTable getMapTable() {
        if (this.mapTable == null && this.registry != null) {
            this.mapTable = (MapTable)this.registry.getComponent(MapTable.class);
        }
        return this.mapTable;
    }

    public void registerCommand(String cmd, Command command) {
        this.commands.put(cmd, command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeCommand(String commandLine, CommandContext context) {
        String[][] parts;
        PrintStream out = context == null ? this.out : context.out;
        PrintStream err = context == null ? this.err : context.err;
        try {
            parts = CommandParser.parseCommandLine(commandLine);
        }
        catch (Exception e) {
            err.println("Error: failed to parse command:");
            e.printStackTrace(err);
            return -1;
        }
        if (parts == null || parts.length == 0) {
            return 0;
        }
        Command[] cmds = this.createCommands(parts);
        if (cmds != null && cmds.length > 0) {
            int index;
            CommandContext[] commands = new CommandContext[parts.length];
            boolean error = false;
            int pid = -1;
            for (int i = 0; i < parts.length; ++i) {
                String[] args = parts[i];
                Command cmd = cmds[i];
                if (i == 0 && cmd instanceof AsyncCommand) {
                    pid = ++this.pidCounter;
                }
                commands[i] = new CommandContext(this, this.getMapTable(), commandLine, args, pid, cmd);
                if (i > 0) {
                    PrintStream po = new PrintStream(new LineOutputStream((LineListener)((Object)commands[i].getCommand())));
                    commands[i - 1].setOutput(po, err);
                }
                if (i != parts.length - 1) continue;
                commands[i].setOutput(out, err);
            }
            try {
                for (index = commands.length - 1; index >= 0; --index) {
                    int code = commands[index].getCommand().executeCommand(commands[index]);
                    if (code == 0) continue;
                    err.println("command '" + commands[index].getCommandName() + "' failed with error code " + code);
                    error = true;
                    break;
                }
            }
            catch (Exception e) {
                err.println("Error: Command failed: " + e.getMessage());
                e.printStackTrace(err);
                error = true;
            }
            if (error) {
                ++index;
                while (index < commands.length) {
                    commands[index].stopCommand();
                    ++index;
                }
                return 1;
            }
            if (pid >= 0) {
                boolean exited = false;
                for (int i = 0; i < commands.length && !exited; ++i) {
                    if (!commands[i].hasExited()) continue;
                    exited = true;
                }
                if (exited) {
                    this.exitCommands(commands);
                } else {
                    ArrayList<CommandContext[]> arrayList = this.currentAsyncCommands;
                    synchronized (arrayList) {
                        this.currentAsyncCommands.add(commands);
                    }
                }
            }
            return 0;
        }
        return -1;
    }

    private Command getCommand(String cmd) {
        Command command = this.commands.get(cmd);
        if (command != null) {
            try {
                return (Command)command.clone();
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace(this.err);
                return null;
            }
        }
        File scriptFile = new File(this.scriptDirectory, cmd);
        if (scriptFile.isFile() && scriptFile.canRead()) {
            return new ScriptCommand(scriptFile);
        }
        return null;
    }

    private Command[] createCommands(String[][] commandList) {
        Command[] cmds = new Command[commandList.length];
        for (int i = 0; i < commandList.length; ++i) {
            Command command = this.getCommand(commandList[i][0]);
            if (command == null) {
                this.err.println("CLI: Command not found: \"" + commandList[i][0] + "\". Try \"help\".");
                return null;
            }
            if (i > 0 && !(command instanceof LineListener)) {
                this.err.println("CLI: Error, command \"" + commandList[i][0] + "\" does not take input.");
                return null;
            }
            String argHelp = command.getArgumentHelp(null);
            if (argHelp != null) {
                int requiredCount = 0;
                int m = argHelp.length();
                for (int j = 0; j < m; ++j) {
                    if (argHelp.charAt(j) != '<') continue;
                    ++requiredCount;
                }
                if (requiredCount > commandList[i].length - 1) {
                    this.err.println("Too few arguments for " + commandList[i][0]);
                    this.err.println("Usage: " + commandList[i][0] + ' ' + argHelp);
                    return null;
                }
            }
            cmds[i] = command;
        }
        return cmds;
    }

    @Override
    public void init(String name, ComponentRegistry registry) {
        this.registry = registry;
    }

    @Override
    public void start() {
        Object[] commandBundles = this.registry.getAllComponents(CommandBundle.class);
        if (commandBundles != null) {
            int n = commandBundles.length;
            for (int i = 0; i < n; ++i) {
                ((CommandBundle)commandBundles[i]).setupCommands(this.registry, this);
            }
        }
    }

    private void registerCommands() {
        this.registerCommand("help", new BasicCommand("show help for the specified command or command list", "[command]"){

            @Override
            public int executeCommand(CommandContext context) {
                if (context.getArgumentCount() == 0) {
                    context.out.println("Available commands:");
                    Object[] names = CommandHandler.this.commands.keySet().toArray(new String[CommandHandler.this.commands.size()]);
                    Arrays.sort(names);
                    for (Object name : names) {
                        Command command = (Command)CommandHandler.this.commands.get(name);
                        String helpText = command.getCommandHelp((String)name);
                        if (helpText == null) continue;
                        String argHelp = command.getArgumentHelp((String)name);
                        String prefix = argHelp != null ? ' ' + (String)name + ' ' + argHelp : ' ' + (String)name;
                        int n = helpText.indexOf(10);
                        if (n > 0) {
                            helpText = helpText.substring(0, n);
                        }
                        context.out.print(prefix);
                        int prefixLen = prefix.length();
                        if (prefixLen < 8) {
                            context.out.print("\t\t\t\t");
                        } else if (prefixLen < 16) {
                            context.out.print("\t\t\t");
                        } else if (prefixLen < 24) {
                            context.out.print("\t\t");
                        } else if (prefixLen < 32) {
                            context.out.print('\t');
                        }
                        context.out.print(' ');
                        context.out.println(helpText);
                    }
                    return 0;
                }
                String cmd = context.getArgument(0);
                Command command = CommandHandler.this.getCommand(cmd);
                if (command != null) {
                    String helpText = command.getCommandHelp(cmd);
                    String argHelp = command.getArgumentHelp(cmd);
                    context.out.print(cmd);
                    if (argHelp != null && argHelp.length() > 0) {
                        context.out.print(' ' + argHelp);
                    }
                    context.out.println();
                    if (helpText != null && helpText.length() > 0) {
                        context.out.println("  " + helpText);
                    }
                    return 0;
                }
                context.err.println("Error: unknown command '" + cmd + '\'');
                return 1;
            }
        });
        this.registerCommand("ps", new BasicCommand("list current executing commands/processes", ""){

            @Override
            public int executeCommand(CommandContext context) {
                if (CommandHandler.this.currentAsyncCommands.size() > 0) {
                    context.out.println(" PID\tCommand");
                    for (int i = 0; i < CommandHandler.this.currentAsyncCommands.size(); ++i) {
                        CommandContext cmd = ((CommandContext[])CommandHandler.this.currentAsyncCommands.get(i))[0];
                        context.out.println("  " + cmd);
                    }
                } else {
                    context.out.println("No executing commands.");
                }
                return 0;
            }
        });
        this.registerCommand("kill", new BasicCommand("kill a currently executing command", "<process>"){

            @Override
            public int executeCommand(CommandContext context) {
                int pid = context.getArgumentAsInt(0);
                if (CommandHandler.this.removePid(pid)) {
                    return 0;
                }
                context.err.println("could not find the command to kill.");
                return 1;
            }
        });
    }

    public void exit(CommandContext commandContext, int exitCode, int pid) {
        if (pid < 0 || !this.removePid(pid)) {
            commandContext.stopCommand();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removePid(int pid) {
        CommandContext[] contexts = null;
        ArrayList<CommandContext[]> arrayList = this.currentAsyncCommands;
        synchronized (arrayList) {
            int n = this.currentAsyncCommands.size();
            for (int i = 0; i < n; ++i) {
                CommandContext[] cntx = this.currentAsyncCommands.get(i);
                if (pid != cntx[0].getPID()) continue;
                contexts = cntx;
                this.currentAsyncCommands.remove(cntx);
                break;
            }
        }
        return this.exitCommands(contexts);
    }

    private boolean exitCommands(CommandContext[] contexts) {
        if (contexts != null) {
            for (int i = 0; i < contexts.length; ++i) {
                contexts[i].stopCommand();
            }
            return true;
        }
        return false;
    }

    @Override
    public void lineRead(String line) {
        this.executeCommand(line, null);
    }
}

