/*
 * Decompiled with CFR 0.152.
 */
package se.sics.mspsim.cli;

import java.io.PrintStream;
import se.sics.mspsim.cli.AsyncCommand;
import se.sics.mspsim.cli.Command;
import se.sics.mspsim.cli.CommandHandler;
import se.sics.mspsim.core.MSP430Constants;
import se.sics.mspsim.util.MapTable;
import se.sics.mspsim.util.Utils;

public class CommandContext {
    private String[] args;
    private String commandLine;
    private MapTable mapTable;
    private int pid = -1;
    private boolean exited = false;
    private Command command;
    public PrintStream out;
    public PrintStream err;
    private CommandHandler commandHandler;

    public CommandContext(CommandHandler ch, MapTable table, String commandLine, String[] args, int pid, Command command, PrintStream out, PrintStream err) {
        this(ch, table, commandLine, args, pid, command);
        this.setOutput(out, err);
    }

    public CommandContext(CommandHandler ch, MapTable table, String commandLine, String[] args, int pid, Command command) {
        this.commandLine = commandLine;
        this.args = args;
        this.pid = pid;
        this.mapTable = table;
        this.command = command;
        this.commandHandler = ch;
    }

    void setOutput(PrintStream out, PrintStream err) {
        this.out = out;
        this.err = err;
    }

    Command getCommand() {
        return this.command;
    }

    void stopCommand() {
        if (!this.exited) {
            this.exited = true;
            if (this.command instanceof AsyncCommand) {
                AsyncCommand ac = (AsyncCommand)((Object)this.command);
                ac.stopCommand(this);
            }
        }
    }

    String getCommandLine() {
        return this.commandLine;
    }

    public int getPID() {
        return this.pid;
    }

    public boolean hasExited() {
        return this.exited;
    }

    public void exit(int exitCode) {
        this.exited = true;
        this.commandHandler.exit(this, exitCode, this.pid);
    }

    void kill() {
        if (!this.exited) {
            this.commandHandler.exit(this, -9, this.pid);
        }
    }

    public MapTable getMapTable() {
        return this.mapTable;
    }

    public String getCommandName() {
        return this.args[0];
    }

    public int getArgumentCount() {
        return this.args.length - 1;
    }

    public String getArgument(int index) {
        return this.args[index + 1];
    }

    public int getArgumentAsAddress(int index) {
        String adr = this.getArgument(index);
        if (adr == null || adr.length() == 0) {
            return 0;
        }
        char c = adr.charAt(0);
        if (!Character.isLetter(c) && c != '_' && c != '.') {
            try {
                return Utils.decodeInt(adr);
            }
            catch (Exception e) {
                this.err.println("Illegal address format: " + adr);
            }
        } else if (this.mapTable != null) {
            return this.mapTable.getFunctionAddress(adr);
        }
        return -1;
    }

    public int getArgumentAsRegister(int index) {
        String symbol = this.getArgument(index);
        int n = MSP430Constants.REGISTER_NAMES.length;
        for (int i = 0; i < n; ++i) {
            if (!MSP430Constants.REGISTER_NAMES[i].equals(symbol)) continue;
            return i;
        }
        String reg = symbol.startsWith("R") || symbol.startsWith("r") ? symbol.substring(1) : symbol;
        try {
            int register = Integer.parseInt(reg);
            if (register >= 0 && register <= 15) {
                return register;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.err.println("illegal register: " + symbol);
        return -1;
    }

    public int getArgumentAsInt(int index) {
        return this.getArgumentAsInt(index, 0);
    }

    public int getArgumentAsInt(int index, int defaultValue) {
        try {
            return Utils.decodeInt(this.getArgument(index));
        }
        catch (Exception e) {
            this.err.println("Illegal number format: " + this.getArgument(index));
            return defaultValue;
        }
    }

    public long getArgumentAsLong(int index) {
        return this.getArgumentAsLong(index, 0L);
    }

    public long getArgumentAsLong(int index, long defaultValue) {
        try {
            return Utils.decodeLong(this.getArgument(index));
        }
        catch (Exception e) {
            this.err.println("Illegal number format: " + this.getArgument(index));
            return defaultValue;
        }
    }

    public float getArgumentAsFloat(int index) {
        return this.getArgumentAsFloat(index, 0.0f);
    }

    public float getArgumentAsFloat(int index, float defaultValue) {
        try {
            return Float.parseFloat(this.getArgument(index));
        }
        catch (Exception e) {
            this.err.println("Illegal number format: " + this.getArgument(index));
            return defaultValue;
        }
    }

    public double getArgumentAsDouble(int index) {
        return this.getArgumentAsDouble(index, 0.0);
    }

    public double getArgumentAsDouble(int index, double defaultValue) {
        String arg = this.getArgument(index);
        try {
            return Double.parseDouble(arg);
        }
        catch (Exception e) {
            this.err.println("Illegal number format: " + this.getArgument(index));
            return defaultValue;
        }
    }

    public boolean getOption(String optionName) {
        for (int i = 0; i < this.args.length; ++i) {
            if (!this.args[i].equals("-" + optionName)) continue;
            return true;
        }
        return false;
    }

    public boolean getArgumentAsBoolean(int index) {
        String v = this.getArgument(index);
        return "true".equalsIgnoreCase(v) || "1".equals(v);
    }

    public int executeCommand(String command) {
        return this.commandHandler.executeCommand(command, this);
    }

    public String toString() {
        return (this.pid >= 0 ? "" + this.pid : "?") + '\t' + (this.commandLine == null ? this.getCommandName() : this.commandLine);
    }
}

