/*
 * Decompiled with CFR 0.152.
 */
package se.sics.mspsim.chip;

import se.sics.mspsim.core.Chip;
import se.sics.mspsim.core.IOPort;
import se.sics.mspsim.core.MSP430Core;
import se.sics.mspsim.core.TimeEvent;

public class SHT11
extends Chip {
    private static final int IDLE = 0;
    private static final int COMMAND = 1;
    private static final int ACK_CMD = 2;
    private static final int MEASURE = 3;
    private static final int WRITE_BYTE = 4;
    private static final int ACK_WRITE = 5;
    private final int CMD_MEASURE_TEMP = 3;
    private final int CMD_MEASURE_HUM = 5;
    private final boolean DEBUG = false;
    private static final char[] INIT_COMMAND = "CdcCDc".toCharArray();
    private int initPos = 0;
    IOPort sclkPort;
    int sclkPin;
    IOPort sdataPort;
    int sdataPin;
    int state = 0;
    boolean clockHi = false;
    boolean dataHi = false;
    private int readData = 0;
    private int bitCnt = 0;
    private int temp = 6360;
    private int humid = 4160;
    private int[] output = new int[3];
    private int writePos = 0;
    private int writeLen = 0;
    private int writeData = 0;
    private MSP430Core cpu;
    private TimeEvent measureEvent = new TimeEvent(0L){

        @Override
        public void execute(long t) {
            if (SHT11.this.readData == 3) {
                ((SHT11)SHT11.this).output[0] = SHT11.this.temp >> 8;
                ((SHT11)SHT11.this).output[1] = SHT11.this.temp & 0xFF;
            } else if (SHT11.this.readData == 5) {
                ((SHT11)SHT11.this).output[0] = SHT11.this.humid >> 8;
                ((SHT11)SHT11.this).output[1] = SHT11.this.humid & 0xFF;
            } else {
                return;
            }
            int crc = 0;
            crc = SHT11.this.crc8Add(crc, SHT11.this.readData);
            crc = SHT11.this.crc8Add(crc, SHT11.this.output[0]);
            crc = SHT11.this.crc8Add(crc, SHT11.this.output[1]);
            ((SHT11)SHT11.this).output[2] = SHT11.this.rev8bits(crc);
            SHT11.this.sdataPort.setPinState(SHT11.this.sdataPin, 0);
            SHT11.this.state = 4;
            SHT11.this.writeData = SHT11.this.output[0];
            SHT11.this.writePos = 0;
            SHT11.this.writeLen = 3;
        }
    };

    private int rev8bits(int v) {
        int r = 0;
        int s = 7;
        v >>= 1;
        while (v > 0) {
            r <<= 1;
            r |= v & 1;
            --s;
            v >>= 1;
        }
        return r <<= s;
    }

    private int crc8Add(int acc, int data) {
        acc ^= data;
        for (int i = 0; i < 8; ++i) {
            if ((acc & 0x80) != 0) {
                acc = acc << 1 ^ 0x31;
                continue;
            }
            acc <<= 1;
        }
        return acc & 0xFF;
    }

    public SHT11(MSP430Core core) {
        this.cpu = core;
        this.cpu.addChip(this);
    }

    public void setDataPort(IOPort port, int bit) {
        this.sdataPort = port;
        this.sdataPin = bit;
    }

    public void reset(int type) {
        this.clockHi = true;
        this.dataHi = true;
        this.initPos = 0;
        this.bitCnt = 0;
        this.readData = 0;
        this.writePos = 0;
        this.writeData = 0;
        this.state = 0;
        this.sdataPort.setPinState(this.sdataPin, 1);
    }

    public void clockPin(boolean high) {
        if (this.clockHi == high) {
            return;
        }
        char c = high ? (char)'C' : 'c';
        switch (this.state) {
            case 0: {
                if (!this.checkInit(c)) break;
                this.state = 1;
                break;
            }
            case 1: {
                if (c != 99) break;
                this.readData = this.readData << 1 | (this.dataHi ? 1 : 0);
                ++this.bitCnt;
                if (this.bitCnt != 8) break;
                this.bitCnt = 0;
                this.state = 2;
                this.sdataPort.setPinState(this.sdataPin, 0);
                break;
            }
            case 2: {
                if (c != 99) break;
                this.sdataPort.setPinState(this.sdataPin, 1);
                if (this.readData != 5 && this.readData != 3) break;
                this.state = 3;
                this.cpu.scheduleTimeEventMillis(this.measureEvent, 20.0);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                if (c != 67) break;
                boolean hi = (this.writeData & 0x80) != 0;
                this.sdataPort.setPinState(this.sdataPin, hi ? 1 : 0);
                ++this.bitCnt;
                this.writeData <<= 1;
                if (this.bitCnt != 8) break;
                this.state = 5;
                ++this.writePos;
                break;
            }
            case 5: {
                if (c != 67 || !this.dataHi) break;
                this.reset(0);
            }
        }
        this.clockHi = high;
    }

    public void dataPin(boolean high) {
        if (this.dataHi == high) {
            return;
        }
        char c = high ? (char)'D' : 'd';
        switch (this.state) {
            case 0: {
                if (!this.checkInit(c)) break;
                this.state = 1;
                break;
            }
            case 5: {
                if (c != 68) break;
                if (this.writePos < this.writeLen) {
                    this.state = 4;
                    this.writeData = this.output[this.writePos];
                    this.bitCnt = 0;
                    break;
                }
                this.reset(0);
            }
        }
        this.dataHi = high;
    }

    private boolean checkInit(char c) {
        if (INIT_COMMAND[this.initPos] == c) {
            ++this.initPos;
            if (this.initPos == INIT_COMMAND.length) {
                this.initPos = 0;
                return true;
            }
        } else {
            this.initPos = 0;
            if (c == INIT_COMMAND[0]) {
                this.initPos = 1;
            }
        }
        return false;
    }

    @Override
    public int getModeMax() {
        return 0;
    }

    @Override
    public String getName() {
        return "SHT11";
    }
}

