/*
 * Decompiled with CFR 0.152.
 */
package se.sics.mspsim.chip;

import java.io.IOException;
import se.sics.mspsim.core.Chip;
import se.sics.mspsim.core.IOPort;
import se.sics.mspsim.core.MSP430Core;
import se.sics.mspsim.core.Memory;
import se.sics.mspsim.core.PortListener;
import se.sics.mspsim.core.TimeEvent;
import se.sics.mspsim.core.USART;
import se.sics.mspsim.core.USARTListener;

public abstract class M25P80
extends Chip
implements USARTListener,
PortListener,
Memory {
    public static final boolean DEBUG = false;
    public static final int WRITE_STATUS = 1;
    public static final int PAGE_PROGRAM = 2;
    public static final int READ_DATA = 3;
    public static final int WRITE_DISABLE = 4;
    public static final int READ_STATUS = 5;
    public static final int WRITE_ENABLE = 6;
    public static final int READ_DATA_FAST = 11;
    public static final int READ_IDENT = 159;
    public static final int SECTOR_ERASE = 216;
    public static final int BULK_ERASE = 199;
    public static final int DEEP_POWER_DOWN = 185;
    public static final int WAKE_UP = 171;
    public static final int MEMORY_SIZE = 0x100000;
    private int state = 0;
    public static final int CHIP_SELECT = 16;
    private static final double PROGRAM_PAGE_MILLIS = 1.0;
    private static final double SECTOR_ERASE_MILLIS = 1400.0;
    private boolean chipSelect;
    private int pos;
    private int status = 0;
    private boolean writeEnable = false;
    private boolean writing = false;
    private int[] identity = new int[]{32, 32, 20, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private int readAddress;
    private int loadedAddress = -1;
    private int blockWriteAddress;
    private byte[] readMemory = new byte[256];
    private byte[] buffer = new byte[256];
    private TimeEvent writeEvent = new TimeEvent(0L){

        @Override
        public void execute(long t) {
            M25P80.this.writing = false;
        }
    };
    private MSP430Core cpu;

    public M25P80(MSP430Core cpu) {
        this.cpu = cpu;
    }

    @Override
    public void stateChanged(int state) {
    }

    @Override
    public void dataReceived(USART source, int data) {
        if (this.chipSelect) {
            switch (this.state) {
                case 5: {
                    source.byteReceived(this.status);
                    return;
                }
                case 159: {
                    source.byteReceived(this.identity[this.pos]);
                    ++this.pos;
                    if (this.pos >= this.identity.length) {
                        this.pos = 0;
                    }
                    return;
                }
                case 1: {
                    this.status = data;
                    source.byteReceived(0);
                    return;
                }
                case 3: {
                    if (this.pos < 3) {
                        this.readAddress = (this.readAddress << 8) + data;
                        source.byteReceived(0);
                        ++this.pos;
                    } else {
                        source.byteReceived(this.readMemory(this.readAddress++));
                        if (this.readAddress > 1048575) {
                            this.readAddress = 0;
                        }
                    }
                    return;
                }
                case 216: {
                    if (this.pos < 3) {
                        this.readAddress = (this.readAddress << 8) + data;
                        source.byteReceived(0);
                        ++this.pos;
                        if (this.pos == 3) {
                            this.sectorErase(this.readAddress);
                        }
                    }
                    return;
                }
                case 2: {
                    if (this.pos < 3) {
                        this.readAddress = (this.readAddress << 8) + data;
                        source.byteReceived(0);
                        ++this.pos;
                        if (this.pos == 3) {
                            for (int i = 0; i < this.buffer.length; ++i) {
                                this.buffer[i] = -1;
                            }
                            this.blockWriteAddress = this.readAddress & 0xFFF00;
                        }
                    } else {
                        source.byteReceived(0);
                        this.writeBuffer(this.readAddress++ & 0xFF, data);
                    }
                    return;
                }
            }
            switch (data) {
                case 6: {
                    this.writeEnable = true;
                    break;
                }
                case 4: {
                    this.writeEnable = false;
                    break;
                }
                case 159: {
                    this.state = 159;
                    this.pos = 0;
                    source.byteReceived(0);
                    return;
                }
                case 5: {
                    this.status = this.status & 0xFC | (this.writeEnable ? 2 : 0) | (this.writing ? 1 : 0);
                    this.state = 5;
                    source.byteReceived(0);
                    return;
                }
                case 1: {
                    this.state = 1;
                    break;
                }
                case 3: {
                    this.state = 3;
                    this.readAddress = 0;
                    this.pos = 0;
                    break;
                }
                case 2: {
                    this.state = 2;
                    this.readAddress = 0;
                    this.pos = 0;
                    break;
                }
                case 216: {
                    this.state = 216;
                    this.pos = 0;
                    break;
                }
                case 199: {
                    System.out.println("M25P80: Bulk Erase");
                }
            }
            source.byteReceived(0);
        }
    }

    @Override
    public int readByte(int address) {
        byte[] data = new byte[256];
        try {
            this.loadMemory(address, data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ~data[address & 0xFF];
    }

    @Override
    public void writeByte(int address, int data) {
        byte[] mem = new byte[256];
        try {
            this.loadMemory(address, mem);
            mem[address & 0xFF] = (byte)(~data);
            this.writeBack(address, mem);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.loadedAddress >= 0 && (this.loadedAddress & 0xFFF00) == (address & 0xFFF00)) {
            this.loadedAddress = -1;
        }
    }

    @Override
    public int getSize() {
        return 0x100000;
    }

    private int readMemory(int address) {
        this.ensureLoaded(address);
        return this.readMemory[address & 0xFF];
    }

    private void writeBuffer(int address, int data) {
        this.buffer[address] = (byte)data;
    }

    private void ensureLoaded(int address) {
        if (this.loadedAddress < 0 || (this.loadedAddress & 0xFFF00) != (address & 0xFFF00)) {
            try {
                this.loadMemory(address, this.readMemory);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.loadedAddress = address & 0xFFF00;
        }
    }

    private void loadMemory(int address, byte[] readMemory) throws IOException {
        this.seek(address & 0xFFF00);
        this.readFully(readMemory);
        for (int i = 0; i < readMemory.length; ++i) {
            readMemory[i] = (byte)(~readMemory[i] & 0xFF);
        }
    }

    @Override
    public boolean getChipSelect() {
        return this.chipSelect;
    }

    @Override
    public void portWrite(IOPort source, int data) {
        if (this.chipSelect && (data & 0x10) != 0) {
            switch (this.state) {
                case 2: {
                    this.programPage();
                }
            }
        }
        this.chipSelect = (data & 0x10) == 0;
        this.state = 0;
    }

    private void writeStatus(double time) {
        this.writing = true;
        this.cpu.scheduleTimeEventMillis(this.writeEvent, time);
    }

    private void programPage() {
        if (this.writing) {
            System.out.println("Can not set program page while already writing... " + this.cpu.getPC());
        }
        this.writeStatus(1.0);
        this.ensureLoaded(this.blockWriteAddress);
        for (int i = 0; i < this.readMemory.length; ++i) {
            int n = i;
            this.readMemory[n] = (byte)(this.readMemory[n] & this.buffer[i]);
        }
        this.writeBack(this.blockWriteAddress, this.readMemory);
    }

    private void sectorErase(int address) {
        int i;
        this.writeStatus(1400.0);
        int sectorAddress = address & 0xF0000;
        this.loadedAddress = -1;
        for (i = 0; i < this.buffer.length; ++i) {
            this.buffer[i] = -1;
        }
        this.blockWriteAddress = sectorAddress;
        for (i = 0; i < 256; ++i) {
            this.writeBack(this.blockWriteAddress, this.buffer);
            this.blockWriteAddress += 256;
        }
    }

    private void writeBack(int address, byte[] data) {
        try {
            byte[] tmp = new byte[data.length];
            this.seek(address & 0xFFF00);
            for (int i = 0; i < data.length; ++i) {
                tmp[i] = (byte)(~data[i] & 0xFF);
            }
            this.write(tmp);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getModeMax() {
        return 0;
    }

    @Override
    public String getName() {
        return "M25P80: external flash";
    }

    public abstract void seek(long var1) throws IOException;

    public abstract int readFully(byte[] var1) throws IOException;

    public abstract void write(byte[] var1) throws IOException;
}

