/*
 * Decompiled with CFR 0.152.
 */
package se.sics.mspsim.chip;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import se.sics.mspsim.chip.M25P80;
import se.sics.mspsim.core.MSP430Core;

public class FileM25P80
extends M25P80 {
    private static final boolean DEBUG = true;
    private String filename;
    private RandomAccessFile file;
    private FileChannel fileChannel;
    private FileLock fileLock;
    private long pos = 0L;

    public FileM25P80(MSP430Core cpu, String filename) {
        super(cpu);
        if (filename == null) {
            filename = "flash.bin";
        }
        this.filename = filename;
    }

    private boolean ensureOpen(boolean write) {
        Matcher m;
        File fp;
        if (this.fileChannel != null) {
            return true;
        }
        if (!write && !(fp = new File(this.filename)).exists()) {
            return false;
        }
        if (!this.openFile(this.filename) && (m = Pattern.compile("(.+?)(\\d*)(\\.[^.]+)").matcher(this.filename)).matches()) {
            String baseName = m.group(1);
            String c = m.group(2);
            String extName = m.group(3);
            int count = 1;
            if (c != null && c.length() > 0) {
                count = Integer.parseInt(c) + 1;
            }
            int i = 0;
            while (!this.openFile(baseName + count + extName) && i < 100) {
                ++i;
                ++count;
            }
        }
        if (this.fileLock == null) {
            if (write) {
                System.err.println(this.getName() + ": failed to open flash file '" + this.filename + '\'');
            }
            return false;
        }
        try {
            this.file.setLength(0x100000L);
            if (this.pos > 0L) {
                this.file.seek(this.pos);
            }
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean openFile(String filename) {
        try {
            this.file = new RandomAccessFile(filename, "rw");
            this.fileChannel = this.file.getChannel();
            this.fileLock = this.fileChannel.tryLock();
            if (this.fileLock != null) {
                System.out.println("FileM25P80: using flash file '" + filename + '\'');
                return true;
            }
            this.fileChannel.close();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            this.closeFile();
            return false;
        }
    }

    private void closeFile() {
        try {
            this.file = null;
            if (this.fileLock != null) {
                this.fileLock.release();
                this.fileLock = null;
            }
            if (this.fileChannel != null) {
                this.fileChannel.close();
                this.fileChannel = null;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void seek(long pos) throws IOException {
        if (this.file != null) {
            this.file.seek(pos);
        }
        this.pos = pos;
    }

    @Override
    public int readFully(byte[] b) throws IOException {
        if (this.file != null || this.ensureOpen(false)) {
            this.pos += (long)b.length;
            return this.file.read(b);
        }
        Arrays.fill(b, (byte)0);
        this.pos += (long)b.length;
        return b.length;
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (this.file != null || this.ensureOpen(true)) {
            this.file.write(b);
        }
        this.pos += (long)b.length;
    }

    @Override
    public void stateChanged(int state) {
    }
}

