/*
 * Decompiled with CFR 0.152.
 */
package se.sics.mspsim.chip;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import se.sics.mspsim.chip.AT45DB;
import se.sics.mspsim.core.MSP430Core;

public class FileAT45DB
extends AT45DB {
    private static final boolean DEBUG = true;
    private static final int FLASH_SIZE = 540672;
    private RandomAccessFile file;
    private FileChannel fileChannel;
    private FileLock fileLock;

    public FileAT45DB(MSP430Core cpu, String filename) {
        super(cpu);
        Matcher m;
        if (filename == null) {
            filename = "flash.bin";
        }
        if (!this.openFile(filename) && (m = Pattern.compile("(.+?)(\\d*)(\\.[^.]+)").matcher(filename)).matches()) {
            String baseName = m.group(1);
            String c = m.group(2);
            String extName = m.group(3);
            int count = 1;
            if (c != null && c.length() > 0) {
                count = Integer.parseInt(c) + 1;
            }
            int i = 0;
            while (!this.openFile(baseName + count + extName) && i < 100) {
                ++i;
                ++count;
            }
        }
        if (this.fileLock == null) {
            throw new IllegalStateException("failed to open flash file '" + filename + '\'');
        }
        try {
            this.file.setLength(540672L);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private boolean openFile(String filename) {
        try {
            this.file = new RandomAccessFile(filename, "rw");
            this.fileChannel = this.file.getChannel();
            this.fileLock = this.fileChannel.tryLock();
            if (this.fileLock != null) {
                System.out.println("FileAT45DB: using flash file '" + filename + '\'');
                return true;
            }
            this.fileChannel.close();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            this.closeFile();
            return false;
        }
    }

    private void closeFile() {
        try {
            if (this.fileLock != null) {
                this.fileLock.release();
                this.fileLock = null;
            }
            if (this.fileChannel != null) {
                this.fileChannel.close();
                this.fileChannel = null;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void seek(long pos) throws IOException {
        this.file.seek(pos);
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.file.read(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.file.write(b);
    }

    @Override
    public void stateChanged(int state) {
    }
}

