/*
 * Decompiled with CFR 0.152.
 */
package se.sics.mspsim.chip;

import se.sics.mspsim.core.Chip;
import se.sics.mspsim.core.IOPort;
import se.sics.mspsim.core.MSP430Core;
import se.sics.mspsim.core.TimeEvent;
import se.sics.mspsim.util.Utils;

public class DS2411
extends Chip {
    private static final boolean DEBUG = false;
    private static final int CMD_READ_ROM = 51;
    private static final int CMD_SEACH_ROM = 240;
    MSP430Core cpu;
    private IOPort sdataPort;
    private int sdataPin;
    private STATE state = STATE.IDLE;
    private boolean lastPin;
    private int pos = 0;
    private int readByte = 0;
    private int writeByte = 0;
    private int writeLen = 0;
    private int writePos = 0;
    private int[] writeBuf = new int[10];
    private int[] macID = new int[]{1, 2, 3, 4, 5, 6};
    private TimeEvent stateEvent = new TimeEvent(0L){

        @Override
        public void execute(long t) {
            switch (DS2411.this.state) {
                case WAIT_FOR_RESET: {
                    if (DS2411.this.lastPin) break;
                    DS2411.this.state = STATE.RESETTING;
                    DS2411.this.log("Reseting...");
                    break;
                }
                case SIGNAL_READY: {
                    DS2411.this.sdataPort.setPinState(DS2411.this.sdataPin, 1);
                    DS2411.this.state = STATE.READY;
                    DS2411.this.log("Ready!");
                    DS2411.this.readByte = 0;
                    DS2411.this.pos = 0;
                    break;
                }
                case READY: {
                    DS2411.this.log("Reading: " + (DS2411.this.lastPin ? 1 : 0));
                    DS2411.this.readByte = DS2411.this.readByte + (DS2411.this.lastPin ? 1 << DS2411.this.pos : 0);
                    DS2411.this.pos++;
                    if (DS2411.this.pos != 8) break;
                    DS2411.this.log("Command: " + Utils.hex8(DS2411.this.readByte));
                    DS2411.this.handleCommand(DS2411.this.readByte);
                    DS2411.this.state = STATE.WAIT_SENDING;
                    DS2411.this.pos = 0;
                    DS2411.this.writePos = 0;
                    DS2411.this.writeByte = DS2411.this.writeBuf[DS2411.this.writePos];
                }
            }
        }
    };

    public DS2411(MSP430Core cpu) {
        this.cpu = cpu;
    }

    private int crcAdd(int acc, int data) {
        acc ^= data;
        for (int i = 0; i < 8; ++i) {
            if ((acc & 1) == 1) {
                acc = acc >> 1 ^ 0x8C;
                continue;
            }
            acc >>= 1;
        }
        return acc;
    }

    private int crc8(int[] buf, int len) {
        int acc = 0;
        for (int i = 0; i < len; ++i) {
            acc = this.crcAdd(acc, buf[i]);
        }
        return acc;
    }

    protected void handleCommand(int cmd) {
        if (cmd == 51) {
            this.writeBuf[0] = 1;
            this.writeBuf[1] = this.macID[0];
            this.writeBuf[2] = this.macID[1];
            this.writeBuf[3] = this.macID[2];
            this.writeBuf[4] = this.macID[3];
            this.writeBuf[5] = this.macID[4];
            this.writeBuf[6] = this.macID[5];
            this.writeBuf[7] = this.crc8(this.writeBuf, 7);
            this.writeLen = 8;
        }
    }

    @Override
    public int getModeMax() {
        return 0;
    }

    @Override
    public String getName() {
        return "DS2411";
    }

    public void setDataPort(IOPort port, int bit) {
        this.sdataPort = port;
        this.sdataPin = bit;
    }

    public void dataPin(boolean high) {
        this.log(" Data pin high: " + high + " " + this.cpu.cycles);
        if (this.lastPin == high) {
            return;
        }
        this.lastPin = high;
        switch (this.state) {
            case IDLE: {
                this.sdataPort.setPinState(this.sdataPin, 1);
                if (high) break;
                this.state = STATE.WAIT_FOR_RESET;
                this.log("Wait for reset...");
                this.cpu.scheduleTimeEventMillis(this.stateEvent, 0.4);
                break;
            }
            case RESETTING: {
                if (!high) break;
                this.state = STATE.SIGNAL_READY;
                this.log("Signal ready");
                this.sdataPort.setPinState(this.sdataPin, 0);
                this.cpu.scheduleTimeEventMillis(this.stateEvent, 0.48);
                this.pos = 0;
                break;
            }
            case READY: {
                if (high) break;
                this.cpu.scheduleTimeEventMillis(this.stateEvent, 0.04);
                break;
            }
            case WAIT_SENDING: {
                if (high) break;
                this.state = STATE.SENDING;
                break;
            }
            case SENDING: {
                if (!high) break;
                if (this.pos == 0) {
                    this.log("should write next byte: " + this.writeByte);
                }
                this.sdataPort.setPinState(this.sdataPin, (this.writeByte & 1 << this.pos) > 0 ? 1 : 0);
                this.log(" wrote bit: " + ((this.writeByte & 1 << this.pos) > 0 ? 1 : 0));
                ++this.pos;
                if (this.pos != 8) break;
                ++this.writePos;
                if (this.writePos == this.writeLen) {
                    this.log("write is over => IDLE!!!!");
                    this.state = STATE.IDLE;
                    break;
                }
                this.pos = 0;
                this.writeByte = this.writeBuf[this.writePos];
            }
        }
    }

    public void setMACID(int i, int j, int k, int l, int m, int n) {
        this.macID[0] = i;
        this.macID[1] = j;
        this.macID[2] = k;
        this.macID[3] = l;
        this.macID[4] = m;
        this.macID[5] = n;
    }

    private static enum STATE {
        IDLE,
        WAIT_FOR_RESET,
        RESETTING,
        SIGNAL_READY,
        READY,
        WAIT_SENDING,
        SENDING;

    }
}

