/*
 * Decompiled with CFR 0.152.
 */
package se.sics.mspsim.chip;

import se.sics.mspsim.chip.RFListener;
import se.sics.mspsim.chip.RFSource;
import se.sics.mspsim.core.Chip;
import se.sics.mspsim.core.IOPort;
import se.sics.mspsim.core.MSP430Core;
import se.sics.mspsim.core.TimeEvent;
import se.sics.mspsim.core.USART;
import se.sics.mspsim.core.USARTListener;
import se.sics.mspsim.util.CCITT_CRC;
import se.sics.mspsim.util.Utils;

public class CC2420
extends Chip
implements USARTListener,
RFListener,
RFSource {
    public static final int REG_SNOP = 0;
    public static final int REG_SXOSCON = 1;
    public static final int REG_STXCAL = 2;
    public static final int REG_SRXON = 3;
    public static final int REG_STXON = 4;
    public static final int REG_STXONCCA = 5;
    public static final int REG_SRFOFF = 6;
    public static final int REG_SXOSCOFF = 7;
    public static final int REG_SFLUSHRX = 8;
    public static final int REG_SFLUSHTX = 9;
    public static final int REG_SACK = 10;
    public static final int REG_SACKPEND = 11;
    public static final int REG_SRXDEC = 12;
    public static final int REG_STXENC = 13;
    public static final int REG_SAES = 14;
    public static final int REG_foo = 15;
    public static final int REG_MAIN = 16;
    public static final int REG_MDMCTRL0 = 17;
    public static final int REG_MDMCTRL1 = 18;
    public static final int REG_RSSI = 19;
    public static final int REG_SYNCWORD = 20;
    public static final int REG_TXCTRL = 21;
    public static final int REG_RXCTRL0 = 22;
    public static final int REG_RXCTRL1 = 23;
    public static final int REG_FSCTRL = 24;
    public static final int REG_SECCTRL0 = 25;
    public static final int REG_SECCTRL1 = 26;
    public static final int REG_BATTMON = 27;
    public static final int REG_IOCFG0 = 28;
    public static final int REG_IOCFG1 = 29;
    public static final int REG_MANFIDL = 30;
    public static final int REG_MANFIDH = 31;
    public static final int REG_FSMTC = 32;
    public static final int REG_MANAND = 33;
    public static final int REG_MANOR = 34;
    public static final int REG_AGCCTRL = 35;
    public static final int REG_AGCTST0 = 36;
    public static final int REG_AGCTST1 = 37;
    public static final int REG_AGCTST2 = 38;
    public static final int REG_FSTST0 = 39;
    public static final int REG_FSTST1 = 40;
    public static final int REG_FSTST2 = 41;
    public static final int REG_FSTST3 = 42;
    public static final int REG_RXBPFTST = 43;
    public static final int REG_FSMSTATE = 44;
    public static final int REG_ADCTST = 45;
    public static final int REG_DACTST = 46;
    public static final int REG_TOPTST = 47;
    public static final int REG_RESERVED = 48;
    public static final int REG_TXFIFO = 62;
    public static final int REG_RXFIFO = 63;
    public static final int STATUS_XOSC16M_STABLE = 64;
    public static final int STATUS_TX_UNDERFLOW = 32;
    public static final int STATUS_ENC_BUSY = 16;
    public static final int STATUS_TX_ACTIVE = 8;
    public static final int STATUS_LOCK = 4;
    public static final int STATUS_RSSI_VALID = 2;
    public static final int BCN_ACCEPT = 2048;
    public static final int FIFO_POLARITY = 1024;
    public static final int FIFOP_POLARITY = 512;
    public static final int SFD_POLARITY = 256;
    public static final int CCA_POLARITY = 128;
    public static final int FIFOP_THR = 127;
    public static final int SFDMUX = 992;
    public static final int CCAMUX = 31;
    public static final int CCAMUX_CCA = 0;
    public static final int CCAMUX_XOSC16M_STABLE = 24;
    public static final int ADR_DECODE = 2048;
    public static final int ADR_AUTOCRC = 32;
    public static final int AUTOACK = 16;
    public static final int PREAMBLE_LENGTH = 15;
    public static final int RAM_TXFIFO = 0;
    public static final int RAM_RXFIFO = 128;
    public static final int RAM_KEY0 = 256;
    public static final int RAM_RXNONCE = 272;
    public static final int RAM_SABUF = 288;
    public static final int RAM_KEY1 = 304;
    public static final int RAM_TXNONCE = 320;
    public static final int RAM_CBCSTATE = 336;
    public static final int RAM_IEEEADDR = 352;
    public static final int RAM_PANID = 360;
    public static final int RAM_SHORTADDR = 362;
    public static final int MODE_TXRX_OFF = 0;
    public static final int MODE_RX_ON = 1;
    public static final int MODE_TXRX_ON = 2;
    public static final int MODE_POWER_OFF = 3;
    public static final int MODE_MAX = 3;
    private static final String[] MODE_NAMES = new String[]{"off", "listen", "transmit", "power_off"};
    public static final int FRAME_TYPE = 7;
    public static final int SECURITY_ENABLED = 8;
    public static final int ACK_REQUEST = 32;
    public static final int INTRA_PAN = 64;
    public static final int DESTINATION_ADDRESS_MODE = 48;
    public static final int SOURCE_ADDRESS_MODE = 3;
    private RadioState stateMachine = RadioState.VREG_OFF;
    public static final double SYMBOL_PERIOD = 0.016;
    public static final int FLAG_READ = 64;
    public static final int FLAG_RAM = 128;
    public static final int FLAG_RAM_READ = 32;
    private SpiState state = SpiState.WAITING;
    private int pos;
    private int address;
    private int shrPos;
    private int txfifoPos;
    private boolean txfifoFlush;
    private int rxfifoWritePos;
    private int rxfifoReadPos;
    private int rxfifoLen;
    private int rxlen;
    private int rxread;
    private int lastPacketStart;
    private int zeroSymbols;
    private boolean ramRead = false;
    private int rssi = -100;
    private static int RSSI_OFFSET = -45;
    private boolean cca = false;
    private boolean autoAck = false;
    private boolean shouldAck = false;
    private int activeFrequency = 0;
    private int activeChannel = 0;
    private int status = 0;
    private int[] registers = new int[64];
    private int[] memory = new int[512];
    private byte[] SHR = new byte[5];
    private boolean chipSelect;
    private IOPort ccaPort = null;
    private int ccaPin;
    private IOPort fifopPort = null;
    private int fifopPin;
    private boolean fifoP = false;
    private IOPort fifoPort = null;
    private int fifoPin;
    private IOPort sfdPort = null;
    private int sfdPin;
    private int txCursor;
    private RFListener listener;
    private boolean on;
    private MSP430Core cpu;
    private TimeEvent oscillatorEvent = new TimeEvent(0L, "CC2420 OSC"){

        @Override
        public void execute(long t) {
            CC2420.this.status |= 64;
            if (CC2420.this.DEBUG) {
                CC2420.this.log("Oscillator Stable Event.");
            }
            CC2420.this.setState(RadioState.IDLE);
            if ((CC2420.this.registers[29] & 0x1F) == 24) {
                CC2420.this.updateCCA();
            } else if (CC2420.this.DEBUG) {
                CC2420.this.log("CCAMUX != CCA_XOSC16M_STABLE! Not raising CCA");
            }
        }
    };
    private TimeEvent vregEvent = new TimeEvent(0L, "CC2420 VREG"){

        @Override
        public void execute(long t) {
            if (CC2420.this.DEBUG) {
                CC2420.this.log("VREG Started at: " + t + " cyc: " + ((CC2420)CC2420.this).cpu.cycles + " " + this.getTime());
            }
            CC2420.this.on = true;
            CC2420.this.setState(RadioState.POWER_DOWN);
            CC2420.this.updateCCA();
        }
    };
    private TimeEvent sendEvent = new TimeEvent(0L, "CC2420 Send"){

        @Override
        public void execute(long t) {
            CC2420.this.txNext();
        }
    };
    private TimeEvent ackEvent = new TimeEvent(0L, "CC2420 Ack"){

        @Override
        public void execute(long t) {
            CC2420.this.ackNext();
        }
    };
    private TimeEvent shrEvent = new TimeEvent(0L, "CC2420 SHR"){

        @Override
        public void execute(long t) {
            CC2420.this.shrNext();
        }
    };
    private TimeEvent symbolEvent = new TimeEvent(0L, "CC2420 Symbol"){

        @Override
        public void execute(long t) {
            switch (CC2420.this.stateMachine) {
                case RX_CALIBRATE: {
                    CC2420.this.setState(RadioState.RX_SFD_SEARCH);
                    break;
                }
                case TX_CALIBRATE: {
                    CC2420.this.setState(RadioState.TX_PREAMBLE);
                    break;
                }
                case RX_WAIT: {
                    CC2420.this.setState(RadioState.RX_SFD_SEARCH);
                    break;
                }
                case TX_ACK_CALIBRATE: {
                    CC2420.this.setState(RadioState.TX_ACK_PREAMBLE);
                }
            }
        }
    };
    private boolean currentSFD;
    private boolean currentFIFO;
    private boolean overflow = false;
    private StateListener stateListener = null;
    private int ackPos;
    private int[] ackBuf = new int[]{2, 0, 0, 0, 0};
    private CCITT_CRC rxCrc = new CCITT_CRC();
    private CCITT_CRC txCrc = new CCITT_CRC();

    public void setStateListener(StateListener listener) {
        this.stateListener = listener;
    }

    public RadioState getState() {
        return this.stateMachine;
    }

    public CC2420(MSP430Core cpu) {
        this.registers[0] = 0;
        this.registers[21] = 41215;
        this.cpu = cpu;
        this.setModeNames(MODE_NAMES);
        this.setMode(3);
        this.fifoP = false;
        this.rxfifoReadPos = 0;
        this.rxfifoWritePos = 0;
        this.overflow = false;
        cpu.addChip(this);
    }

    private boolean setState(RadioState state) {
        if (this.DEBUG) {
            this.log("State transition from " + (Object)((Object)this.stateMachine) + " to " + (Object)((Object)state));
        }
        this.stateMachine = state;
        this.registers[44] = state.getFSMState();
        switch (this.stateMachine) {
            case VREG_OFF: {
                if (this.DEBUG) {
                    this.log("VREG Off.");
                }
                this.flushRX();
                this.flushTX();
                this.status &= 0xFFFFFFBD;
                this.setMode(3);
                this.updateCCA();
                break;
            }
            case POWER_DOWN: {
                this.rxfifoReadPos = 0;
                this.rxfifoWritePos = 0;
                this.status &= 0xFFFFFFBD;
                this.setMode(3);
                this.updateCCA();
                break;
            }
            case RX_CALIBRATE: {
                this.setSymbolEvent(12);
                this.setMode(1);
                break;
            }
            case RX_SFD_SEARCH: {
                this.zeroSymbols = 0;
                this.status |= 2;
                this.updateCCA();
                this.setMode(1);
                break;
            }
            case TX_CALIBRATE: {
                this.setSymbolEvent(14);
                this.setMode(2);
                break;
            }
            case TX_PREAMBLE: {
                this.shrPos = 0;
                this.SHR[0] = 0;
                this.SHR[1] = 0;
                this.SHR[2] = 0;
                this.SHR[3] = 0;
                this.SHR[4] = 122;
                this.shrNext();
                break;
            }
            case TX_FRAME: {
                this.txfifoPos = 0;
                this.txNext();
                break;
            }
            case RX_WAIT: {
                this.setSymbolEvent(8);
                this.setMode(1);
                break;
            }
            case IDLE: {
                this.status &= 0xFFFFFFFD;
                this.setMode(0);
                this.updateCCA();
                break;
            }
            case TX_ACK_CALIBRATE: {
                this.status |= 8;
                this.setSymbolEvent(14);
                this.setMode(2);
                break;
            }
            case TX_ACK_PREAMBLE: {
                this.shrPos = 0;
                this.SHR[0] = 0;
                this.SHR[1] = 0;
                this.SHR[2] = 0;
                this.SHR[3] = 0;
                this.SHR[4] = 122;
                this.shrNext();
                break;
            }
            case TX_ACK: {
                this.ackPos = 0;
                this.ackNext();
            }
        }
        if (this.stateListener != null) {
            this.stateListener.newState(this.stateMachine);
        }
        return true;
    }

    @Override
    public void receivedByte(byte data) {
        this.log("RF Byte received: " + Utils.hex8(data) + " state: " + (Object)((Object)this.stateMachine) + " noZeroes: " + this.zeroSymbols + (this.stateMachine == RadioState.RX_SFD_SEARCH || this.stateMachine == RadioState.RX_FRAME ? "" : " *** Ignored"));
        if (this.stateMachine == RadioState.RX_SFD_SEARCH) {
            if (data == 0) {
                ++this.zeroSymbols;
            } else if (this.zeroSymbols >= 4 && data == 122) {
                this.setSFD(true);
                if (this.DEBUG) {
                    this.log("RX: Preamble/SFD Synchronized.");
                }
                this.rxread = 0;
                this.setState(RadioState.RX_FRAME);
            } else {
                this.zeroSymbols = 0;
            }
        } else if (this.stateMachine == RadioState.RX_FRAME) {
            if (this.rxfifoLen == 128) {
                this.setRxOverflow();
            } else {
                this.memory[128 + this.rxfifoWritePos] = data & 0xFF;
                this.rxfifoWritePos = this.rxfifoWritePos + 1 & 0x7F;
                ++this.rxfifoLen;
                if (this.rxread == 0) {
                    this.rxCrc.setCRC(0);
                    this.rxlen = data & 0xFF;
                    if (this.DEBUG) {
                        this.log("RX: Start frame length " + this.rxlen);
                    }
                    this.setFIFO(true);
                }
                if (this.rxread < this.rxlen - 2) {
                    this.rxCrc.add(data & 0xFF);
                }
                if (this.rxread++ == this.rxlen) {
                    int crc = this.memory[128 + (this.rxfifoWritePos + 128 - 2 & 0x7F)] << 8;
                    this.memory[128 + (this.rxfifoWritePos + 128 - 2 & 0x7F)] = this.registers[19] & 0xFF;
                    this.memory[128 + (this.rxfifoWritePos + 128 - 1 & 0x7F)] = 0x25 | ((crc += this.memory[128 + (this.rxfifoWritePos + 128 - 1 & 0x7F)]) == this.rxCrc.getCRC() ? 128 : 0);
                    this.setFIFOP(true);
                    this.setSFD(false);
                    this.lastPacketStart = this.rxfifoWritePos + 128 - this.rxlen & 0x7F;
                    if (this.DEBUG) {
                        this.log("RX: Complete: packetStart: " + this.lastPacketStart);
                    }
                    if (this.autoAck && this.checkAutoack() || this.shouldAck) {
                        this.setState(RadioState.TX_ACK_CALIBRATE);
                    } else {
                        this.setState(RadioState.RX_WAIT);
                    }
                }
            }
        }
    }

    private boolean checkAutoack() {
        boolean ackReq;
        boolean bl = ackReq = (this.memory[128 + this.lastPacketStart] & 0x20) != 0;
        if (!ackReq) {
            return false;
        }
        int addrSize = 8;
        int addrPos = this.lastPacketStart + 2 + 1;
        for (int i = 0; i < addrSize; ++i) {
            if (this.memory[352 + i] == this.memory[128 + (addrPos + i) & 0x7F]) continue;
            return false;
        }
        return false;
    }

    @Override
    public void dataReceived(USART source, int data) {
        int oldStatus = this.status;
        if (this.DEBUG) {
            this.log("byte received: " + Utils.hex8(data) + " (" + (data >= 32 && data <= 90 ? (char)data : (char)'.') + ')' + " CS: " + this.chipSelect + " SPI state: " + (Object)((Object)this.state) + " StateMachine: " + (Object)((Object)this.stateMachine));
        }
        if (this.stateMachine != RadioState.VREG_OFF && this.chipSelect) {
            switch (this.state) {
                case WAITING: {
                    this.state = (data & 0x40) != 0 ? SpiState.READ_REGISTER : SpiState.WRITE_REGISTER;
                    if ((data & 0x80) != 0) {
                        this.state = SpiState.RAM_ACCESS;
                        this.address = data & 0x7F;
                    } else {
                        this.address = data & 0x3F;
                        if (this.address == 63) {
                            this.state = SpiState.READ_RXFIFO;
                        } else if (this.address == 62) {
                            this.state = SpiState.WRITE_TXFIFO;
                        }
                    }
                    if (data < 15) {
                        this.strobe(data);
                        this.state = SpiState.WAITING;
                    }
                    this.pos = 0;
                    break;
                }
                case WRITE_REGISTER: {
                    if (this.pos == 0) {
                        source.byteReceived(this.registers[this.address] >> 8);
                        this.registers[this.address] = this.registers[this.address] & 0xFF | data << 8;
                        this.pos = 1;
                        break;
                    }
                    source.byteReceived(this.registers[this.address] & 0xFF);
                    this.registers[this.address] = this.registers[this.address] & 0xFF00 | data;
                    if (this.address == 28) {
                        this.setFIFOP(false);
                    }
                    if (this.DEBUG) {
                        this.log("wrote to " + Utils.hex8(this.address) + " = " + this.registers[this.address]);
                        switch (this.address) {
                            case 28: {
                                this.log("IOCFG0: " + this.registers[this.address]);
                                break;
                            }
                            case 29: {
                                this.log("IOCFG1: SFDMUX " + ((this.registers[this.address] & 0x3E0) >> 992) + " CCAMUX: " + (this.registers[this.address] & 0x1F));
                                this.updateCCA();
                            }
                        }
                    }
                    this.state = SpiState.WAITING;
                    break;
                }
                case READ_REGISTER: {
                    if (this.pos == 0) {
                        source.byteReceived(this.registers[this.address] >> 8);
                        this.pos = 1;
                    } else {
                        source.byteReceived(this.registers[this.address] & 0xFF);
                        if (this.DEBUG) {
                            this.log("read from " + Utils.hex8(this.address) + " = " + this.registers[this.address]);
                        }
                        this.state = SpiState.WAITING;
                    }
                    return;
                }
                case READ_RXFIFO: {
                    if (this.DEBUG) {
                        this.log("RXFIFO READ " + this.rxfifoReadPos + " => " + (this.memory[128 + this.rxfifoReadPos] & 0xFF) + " size: " + this.rxfifoLen);
                    }
                    source.byteReceived(this.memory[128 + this.rxfifoReadPos] & 0xFF);
                    this.rxfifoReadPos = this.rxfifoReadPos + 1 & 0x7F;
                    if (this.rxfifoLen > 0) {
                        --this.rxfifoLen;
                    }
                    if (this.rxfifoLen == 0) {
                        if (this.DEBUG) {
                            this.log("Setting FIFO to low (buffer empty)");
                        }
                        this.setFIFO(false);
                    }
                    if (this.fifoP && !this.overflow) {
                        if (this.DEBUG) {
                            this.log("*** FIFOP cleared at: " + this.rxfifoReadPos + " lastPacketStartPos: " + this.lastPacketStart);
                        }
                        this.setFIFOP(false);
                    }
                    return;
                }
                case WRITE_TXFIFO: {
                    if (this.txfifoFlush) {
                        this.txCursor = 0;
                        this.txfifoFlush = false;
                    }
                    if (this.DEBUG) {
                        this.log("Writing data: " + data + " to tx: " + this.txCursor);
                    }
                    if (this.txCursor == 0) {
                        if ((data & 0xFF) > 127) {
                            this.logger.warning(this, "CC2420: Warning - packet size too large");
                        }
                    } else if (this.txCursor > 127) {
                        this.logger.warning(this, "CC2420: Warning - TX Cursor wrapped");
                        this.txCursor = 0;
                    }
                    this.memory[0 + this.txCursor] = data & 0xFF;
                    ++this.txCursor;
                    if (!this.sendEvents) break;
                    this.sendEvent("WRITE_TXFIFO", null);
                    break;
                }
                case RAM_ACCESS: {
                    if (this.pos == 0) {
                        this.address |= data << 1 & 0x180;
                        boolean bl = this.ramRead = (data & 0x20) != 0;
                        if (this.DEBUG) {
                            this.log("Address: " + Utils.hex16(this.address) + " read: " + this.ramRead);
                        }
                        ++this.pos;
                        break;
                    }
                    if (!this.ramRead) {
                        this.memory[this.address++] = data;
                        if (this.address >= 384) {
                            this.logger.warning(this, "CC2420: Warning - RAM position too big - wrapping!");
                            this.address = 0;
                        }
                        if (!this.DEBUG || this.address != 362) break;
                        this.log("Pan ID set to: 0x" + Utils.hex8(this.memory[360]) + Utils.hex8(this.memory[361]));
                        break;
                    }
                    source.byteReceived(this.memory[this.address++]);
                    if (this.address >= 384) {
                        this.logger.warning(this, "CC2420: Warning - RAM position too big - wrapping!");
                        this.address = 0;
                    }
                    return;
                }
            }
            source.byteReceived(oldStatus);
        }
    }

    private void strobe(int data) {
        if (this.DEBUG) {
            this.log("Strobe on: " + Utils.hex8(data) + " => " + (Object)((Object)Reg.values()[data]));
        }
        if (this.stateMachine == RadioState.POWER_DOWN && data != 1) {
            if (this.DEBUG) {
                this.log("Got command strobe: " + data + " in POWER_DOWN.  Ignoring.");
            }
            return;
        }
        switch (data) {
            case 0: {
                if (!this.DEBUG) break;
                this.log("SNOP => " + Utils.hex8(this.status) + " at " + this.cpu.cycles);
                break;
            }
            case 3: {
                if (this.stateMachine == RadioState.IDLE) {
                    this.setState(RadioState.RX_CALIBRATE);
                    if (!this.DEBUG) break;
                    this.log("Strobe RX-ON!!!");
                    break;
                }
                if (!this.DEBUG) break;
                this.log("WARNING: SRXON when not IDLE");
                break;
            }
            case 6: {
                if (this.DEBUG) {
                    this.log("Strobe RXTX-OFF!!! at " + this.cpu.cycles);
                }
                this.setState(RadioState.IDLE);
                break;
            }
            case 4: {
                if (this.stateMachine != RadioState.IDLE && this.stateMachine != RadioState.RX_CALIBRATE && this.stateMachine != RadioState.RX_SFD_SEARCH && this.stateMachine != RadioState.RX_FRAME && this.stateMachine != RadioState.RX_OVERFLOW && this.stateMachine != RadioState.RX_WAIT) break;
                this.status |= 8;
                this.setState(RadioState.TX_CALIBRATE);
                if (this.sendEvents) {
                    this.sendEvent("STXON", null);
                }
                if (!this.DEBUG) break;
                this.log("Strobe STXON - transmit on! at " + this.cpu.cycles);
                break;
            }
            case 5: {
                if (this.stateMachine != RadioState.RX_CALIBRATE && this.stateMachine != RadioState.RX_SFD_SEARCH && this.stateMachine != RadioState.RX_FRAME && this.stateMachine != RadioState.RX_OVERFLOW && this.stateMachine != RadioState.RX_WAIT) break;
                if (this.sendEvents) {
                    this.sendEvent("STXON_CCA", null);
                }
                if (this.cca) {
                    this.status |= 8;
                    this.setState(RadioState.TX_CALIBRATE);
                    if (!this.DEBUG) break;
                    this.log("Strobe STXONCCA - transmit on! at " + this.cpu.cycles);
                    break;
                }
                if (!this.DEBUG) break;
                this.log("STXONCCA Ignored, CCA false");
                break;
            }
            case 8: {
                this.flushRX();
                break;
            }
            case 9: {
                if (this.DEBUG) {
                    this.log("Flushing TXFIFO");
                }
                this.flushTX();
                break;
            }
            case 1: {
                this.startOscillator();
                break;
            }
            case 7: {
                this.stopOscillator();
                break;
            }
            default: {
                if (!this.DEBUG) break;
                this.log("Unknown strobe command: " + data);
            }
        }
    }

    private void shrNext() {
        if (this.shrPos == 5) {
            this.setSFD(true);
            if (this.stateMachine == RadioState.TX_PREAMBLE) {
                this.setState(RadioState.TX_FRAME);
            } else if (this.stateMachine == RadioState.TX_ACK_PREAMBLE) {
                this.setState(RadioState.TX_ACK);
            } else {
                this.log("Can not move to TX_FRAME or TX_ACK after preamble since radio is in wrong mode: " + (Object)((Object)this.stateMachine));
            }
        } else {
            if (this.listener != null) {
                if (this.DEBUG) {
                    this.log("transmitting byte: " + Utils.hex8(this.SHR[this.shrPos]));
                }
                this.listener.receivedByte(this.SHR[this.shrPos]);
            }
            ++this.shrPos;
            this.cpu.scheduleTimeEventMillis(this.shrEvent, 0.032);
        }
    }

    private void txNext() {
        if (this.txfifoPos <= this.memory[0]) {
            if (this.txfifoPos == 0) {
                this.txCrc.setCRC(0);
                int len = this.memory[0] & 0xFF;
                for (int i = 0; i < this.memory[0] - 2; ++i) {
                    this.txCrc.add(this.memory[0 + i] & 0xFF);
                }
                this.memory[0 + len - 1] = this.txCrc.getCRC() >> 8;
                this.memory[0 + len] = this.txCrc.getCRC() & 0xFF;
            }
            if (this.txfifoPos > 127) {
                this.log("Warning: packet size too large - repeating packet bytes txfifoPos: " + this.txfifoPos);
            }
            if (this.listener != null) {
                if (this.DEBUG) {
                    this.log("transmitting byte: " + Utils.hex8(this.memory[0 + (this.txfifoPos & 0x7F)] & 0xFF));
                }
                this.listener.receivedByte((byte)(this.memory[0 + (this.txfifoPos & 0x7F)] & 0xFF));
            }
            ++this.txfifoPos;
            this.cpu.scheduleTimeEventMillis(this.sendEvent, 0.032);
        } else {
            if (this.DEBUG) {
                this.log("Completed Transmission.");
            }
            this.status &= 0xFFFFFFF7;
            this.setSFD(false);
            if (this.overflow) {
                this.setState(RadioState.RX_OVERFLOW);
            } else {
                this.setState(RadioState.RX_CALIBRATE);
            }
            this.setMode(1);
            this.txfifoFlush = true;
        }
    }

    private void ackNext() {
        if (this.ackPos < this.ackBuf.length) {
            if (this.listener != null) {
                if (this.DEBUG) {
                    this.log("transmitting byte: " + Utils.hex8(this.memory[0 + (this.txfifoPos & 0x7F)] & 0xFF));
                }
                this.listener.receivedByte((byte)(this.ackBuf[this.ackPos] & 0xFF));
            }
            ++this.ackPos;
            this.cpu.scheduleTimeEventMillis(this.ackEvent, 0.032);
        } else {
            if (this.DEBUG) {
                this.log("Completed Transmission of ACK.");
            }
            this.status &= 0xFFFFFFF7;
            this.setSFD(false);
            this.setState(RadioState.RX_CALIBRATE);
            this.setMode(1);
        }
    }

    private void setSymbolEvent(int symbols) {
        double period = 0.016 * (double)symbols;
        this.cpu.scheduleTimeEventMillis(this.symbolEvent, period);
    }

    private void startOscillator() {
        this.cpu.scheduleTimeEventMillis(this.oscillatorEvent, 1.0);
    }

    private void stopOscillator() {
        this.status &= 0xFFFFFFBF;
        this.setState(RadioState.POWER_DOWN);
        if (this.DEBUG) {
            this.log("Oscillator Off.");
        }
        this.setFIFOP(false);
    }

    private void flushRX() {
        if (this.DEBUG) {
            this.log("Flushing RX len = " + this.rxfifoLen);
        }
        this.rxfifoReadPos = 0;
        this.rxfifoWritePos = 0;
        this.rxfifoLen = 0;
        this.setSFD(false);
        this.setFIFOP(false);
        this.setFIFO(false);
        this.overflow = false;
        if (this.stateMachine == RadioState.RX_CALIBRATE || this.stateMachine == RadioState.RX_SFD_SEARCH || this.stateMachine == RadioState.RX_FRAME || this.stateMachine == RadioState.RX_OVERFLOW || this.stateMachine == RadioState.RX_WAIT) {
            this.setState(RadioState.RX_SFD_SEARCH);
        }
    }

    private void flushTX() {
        this.txCursor = 0;
    }

    private void updateCCA() {
        boolean oldCCA = this.cca;
        int ccaMux = this.registers[29] & 0x1F;
        if (ccaMux == 0) {
            this.cca = (this.status & 2) > 0 && this.rssi < -95;
        } else if (ccaMux == 24) {
            boolean bl = this.cca = (this.status & 0x40) > 0;
        }
        if (this.cca != oldCCA) {
            this.setInternalCCA(this.cca);
        }
    }

    private void setInternalCCA(boolean clear) {
        this.setCCAPin(clear);
        if (this.DEBUG) {
            this.log("Internal CCA: " + clear);
        }
    }

    private void setSFD(boolean sfd) {
        if ((this.registers[28] & 0x100) == 256) {
            this.sfdPort.setPinState(this.sfdPin, sfd ? 0 : 1);
        } else {
            this.sfdPort.setPinState(this.sfdPin, sfd ? 1 : 0);
        }
        this.currentSFD = sfd;
        if (this.DEBUG) {
            this.log("SFD: " + sfd + "  " + this.cpu.cycles);
        }
    }

    private void setCCAPin(boolean cca) {
        if (this.DEBUG) {
            this.log("Setting CCA to: " + cca);
        }
        if ((this.registers[28] & 0x80) == 128) {
            this.ccaPort.setPinState(this.ccaPin, cca ? 0 : 1);
        } else {
            this.ccaPort.setPinState(this.ccaPin, cca ? 1 : 0);
        }
    }

    private void setFIFOP(boolean fifop) {
        this.fifoP = fifop;
        if (this.DEBUG) {
            this.log(this.getName() + " setting FIFOP to " + fifop);
        }
        if ((this.registers[28] & 0x200) == 512) {
            this.fifopPort.setPinState(this.fifopPin, fifop ? 0 : 1);
        } else {
            this.fifopPort.setPinState(this.fifopPin, fifop ? 1 : 0);
        }
    }

    private void setFIFO(boolean fifo) {
        if (this.DEBUG) {
            this.log(this.getName() + " setting FIFO to " + fifo);
        }
        this.currentFIFO = fifo;
        this.fifoPort.setPinState(this.fifoPin, fifo ? 1 : 0);
    }

    private void setRxOverflow() {
        if (this.DEBUG) {
            this.log("RXFIFO Overflow! Read Pos: " + this.rxfifoReadPos + " Write Pos: " + this.rxfifoWritePos);
        }
        this.setFIFOP(true);
        this.setFIFO(false);
        this.setSFD(false);
        this.overflow = true;
        this.setState(RadioState.RX_OVERFLOW);
    }

    public void updateActiveFrequency() {
        this.activeFrequency = this.registers[24] - 357 + 2405 - 16384;
        this.activeChannel = (this.registers[24] - 357 - 16384) / 5 + 11;
    }

    public int getActiveFrequency() {
        return this.activeFrequency;
    }

    public int getActiveChannel() {
        return this.activeChannel;
    }

    public int getOutputPowerIndicator() {
        return this.registers[21] & 0x1F;
    }

    public void setRSSI(int power) {
        if (this.DEBUG) {
            this.log("external setRSSI to: " + power);
        }
        if (power < -128) {
            power = -128;
        }
        this.rssi = power;
        this.registers[19] = power - RSSI_OFFSET;
        this.updateCCA();
    }

    public int getRSSI() {
        return this.rssi;
    }

    public int getOutputPower() {
        int indicator = this.getOutputPowerIndicator();
        if (indicator >= 31) {
            return 0;
        }
        if (indicator >= 27) {
            return -1;
        }
        if (indicator >= 23) {
            return -3;
        }
        if (indicator >= 19) {
            return -5;
        }
        if (indicator >= 15) {
            return -7;
        }
        if (indicator >= 11) {
            return -10;
        }
        if (indicator >= 7) {
            return -15;
        }
        if (indicator >= 3) {
            return -25;
        }
        return -100;
    }

    @Override
    public void setRFListener(RFListener rf) {
        this.listener = rf;
    }

    public void setVRegOn(boolean newOn) {
        if (this.on == newOn) {
            return;
        }
        if (newOn) {
            this.cpu.scheduleTimeEventMillis(this.vregEvent, 0.1);
            if (this.DEBUG) {
                this.log(this.getName() + ": Scheduling vregEvent at: cyc = " + this.cpu.cycles + " target: " + this.vregEvent.getTime() + " current: " + this.cpu.getTime());
            }
        } else {
            this.on = false;
            this.setState(RadioState.VREG_OFF);
        }
    }

    public void setChipSelect(boolean select) {
        this.chipSelect = select;
        if (!this.chipSelect) {
            this.state = SpiState.WAITING;
        }
        if (this.DEBUG) {
            this.log("setting chipSelect: " + this.chipSelect);
        }
    }

    @Override
    public boolean getChipSelect() {
        return this.chipSelect;
    }

    public void setCCAPort(IOPort port, int pin) {
        this.ccaPort = port;
        this.ccaPin = pin;
    }

    public void setFIFOPPort(IOPort port, int pin) {
        this.fifopPort = port;
        this.fifopPin = pin;
    }

    public void setFIFOPort(IOPort port, int pin) {
        this.fifoPort = port;
        this.fifoPin = pin;
    }

    public void setSFDPort(IOPort port, int pin) {
        this.sfdPort = port;
        this.sfdPin = pin;
    }

    public int getRegister(int register) {
        return this.registers[register];
    }

    public void setRegister(int register, int data) {
        this.registers[register] = data;
    }

    @Override
    public String getName() {
        return "CC2420";
    }

    @Override
    public int getModeMax() {
        return 3;
    }

    @Override
    public String chipinfo() {
        this.updateActiveFrequency();
        return " VREG_ON: " + this.on + " ChipSel: " + this.chipSelect + "\n OSC_Stable: " + ((this.status & 0x40) > 0) + "\n RSSI_Valid: " + ((this.status & 2) > 0) + "  CCA: " + this.cca + "\n FIFOP Polarity: " + ((this.registers[28] & 0x200) == 512) + " FIFOP: " + this.fifoP + " FIFO: " + this.currentFIFO + " SFD: " + this.currentSFD + "\n Radio State: " + (Object)((Object)this.stateMachine) + " rxFifoLen: " + this.rxfifoLen + " rxFifoWritePos: " + this.rxfifoWritePos + " rxFifoReadPos: " + this.rxfifoReadPos + "\n SPI State: " + (Object)((Object)this.state) + "\n Channel: " + this.activeChannel + "\n";
    }

    @Override
    public void stateChanged(int state) {
    }

    public static interface StateListener {
        public void newState(RadioState var1);
    }

    public static enum RadioState {
        VREG_OFF(-1),
        POWER_DOWN(0),
        IDLE(1),
        RX_CALIBRATE(2),
        RX_SFD_SEARCH(3),
        RX_WAIT(14),
        RX_FRAME(16),
        RX_OVERFLOW(17),
        TX_CALIBRATE(32),
        TX_PREAMBLE(34),
        TX_FRAME(37),
        TX_ACK_CALIBRATE(48),
        TX_ACK_PREAMBLE(49),
        TX_ACK(52),
        TX_UNDERFLOW(56);

        private final int state;

        private RadioState(int stateNo) {
            this.state = stateNo;
        }

        public int getFSMState() {
            return this.state;
        }
    }

    public static enum SpiState {
        WAITING,
        WRITE_REGISTER,
        READ_REGISTER,
        RAM_ACCESS,
        READ_RXFIFO,
        WRITE_TXFIFO;

    }

    public static enum Reg {
        SNOP,
        SXOSCON,
        STXCAL,
        SRXON,
        STXON,
        STXONCCA,
        SRFOFF,
        SXOSCOFF,
        SFLUSHRX,
        SFLUSHTX,
        SACK,
        SACKPEND,
        SRXDEC,
        STXENC,
        SAES,
        foo,
        MAIN,
        MDMCTRL0,
        MDMCTRL1,
        RSSI,
        SYNCWORD,
        TXCTRL,
        RXCTRL0,
        RXCTRL1,
        FSCTRL,
        SECCTRL0,
        SECCTRL1,
        BATTMON,
        IOCFG0,
        IOCFG1,
        MANFIDL,
        MANFIDH,
        FSMTC,
        MANAND,
        MANOR,
        AGCCTRL,
        AGCTST0,
        AGCTST1,
        AGCTST2,
        FSTST0,
        FSTST1,
        FSTST2,
        FSTST3,
        RXBPFTST,
        FSMSTATE,
        ADCTST,
        DACTST,
        TOPTST,
        RESERVED,
        RES1,
        RES2,
        RES3,
        RES4,
        RES5,
        RES6,
        RES7,
        RES8,
        RES9,
        RESa,
        RESb,
        RESc,
        RESd,
        TXFIFO,
        RXFIFO;

    }
}

