/*
 * Decompiled with CFR 0.152.
 */
package se.sics.mspsim.chip;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.SourceDataLine;
import se.sics.mspsim.core.IOUnit;

public class Beeper
extends IOUnit {
    private SourceDataLine dataLine;
    private FloatControl volume;
    public static final int SAMPLE_RATE = 44000;
    public static final int FRQ_1 = 2200;
    public static final int WAVE_LEN = 20;
    byte[] buffer = new byte[20];
    byte[] quiet = new byte[20];
    int beepCtr = 0;

    public Beeper() {
        super(null, 0);
        AudioFormat af = new AudioFormat(44000.0f, 8, 1, true, false);
        DataLine.Info dli = new DataLine.Info(SourceDataLine.class, af, 16384);
        try {
            this.dataLine = (SourceDataLine)AudioSystem.getLine(dli);
            if (this.dataLine == null) {
                System.out.println("DataLine: not existing...");
            } else {
                this.dataLine.open(this.dataLine.getFormat(), 16384);
                this.volume = (FloatControl)this.dataLine.getControl(FloatControl.Type.MASTER_GAIN);
            }
        }
        catch (Exception e) {
            System.out.println("Problem while  getting data line " + e);
        }
        double f1 = 0.0;
        int n = 20;
        for (int i = 0; i < n; ++i) {
            f1 = Math.sin((double)i * 3.141592 * 2.0 / 20.0) * 40.0;
            this.buffer[i] = (byte)(f1 += Math.sin((double)i * 3.141592 * 4.0 / 20.0) * 30.0);
        }
        if (this.dataLine != null) {
            this.dataLine.start();
        }
    }

    public void setVolue(int vol) {
        this.volume.setValue(vol);
    }

    public void beepOn(boolean beep) {
        if (beep) {
            this.beepCtr = 7;
        }
    }

    public long ioTick(long cycles) {
        if (this.dataLine != null && this.dataLine.available() > 40) {
            if (this.beepCtr > 0) {
                this.dataLine.write(this.buffer, 0, 20);
                --this.beepCtr;
            } else {
                this.dataLine.write(this.quiet, 0, 20);
            }
        }
        return cycles + 1000L;
    }

    @Override
    public int read(int address, boolean word, long cycler) {
        return 0;
    }

    @Override
    public void write(int address, int data, boolean word, long cycler) {
    }

    @Override
    public String getName() {
        return "Beeper";
    }

    @Override
    public void interruptServiced(int vector) {
    }

    public static void main(String[] args) {
        Beeper beep = new Beeper();
        block0: while (true) {
            int i;
            beep.beepOn(true);
            int n = 1000;
            for (i = 0; i < n; ++i) {
                beep.ioTick(0L);
            }
            beep.beepOn(false);
            i = 0;
            n = 10000;
            while (true) {
                if (i >= n) continue block0;
                beep.ioTick(0L);
                ++i;
            }
            break;
        }
    }
}

