/*
 * Decompiled with CFR 0.152.
 */
package se.sics.mspsim.chip;

import java.io.IOException;
import se.sics.mspsim.core.Chip;
import se.sics.mspsim.core.MSP430Core;
import se.sics.mspsim.core.TimeEvent;
import se.sics.mspsim.core.USART;
import se.sics.mspsim.core.USARTListener;

public abstract class AT45DB
extends Chip
implements USARTListener {
    public static final boolean DEBUG = false;
    public static final int PAGE_SIZE = 264;
    public static final int NUM_PAGES = 2048;
    public static final int SIZE_BYTES = 540672;
    public static final int PAGE_READ = 210;
    public static final int CONTINUOUS_ARRAY_READ_LEGACY = 232;
    public static final int CONTINUOUS_ARRAY_READ_HF = 11;
    public static final int CONTINUOUS_ARRAY_READ_LF = 3;
    public static final int BUFFER1_READ_LF = 209;
    public static final int BUFFER2_READ_LF = 211;
    public static final int BUFFER1_READ = 212;
    public static final int BUFFER2_READ = 214;
    public static final int BUFFER1_WRITE = 132;
    public static final int BUFFER2_WRITE = 135;
    public static final int BUFFER1_TO_PAGE_ERASE = 131;
    public static final int BUFFER2_TO_PAGE_ERASE = 134;
    public static final int BUFFER1_TO_PAGE = 136;
    public static final int BUFFER2_TO_PAGE = 137;
    public static final int PAGE_ERASE = 129;
    public static final int BLOCK_ERASE = 80;
    public static final int SECTOR_ERASE = 124;
    public static final int CHIP_ERASE = 199;
    public static final int CHIP_ERASE1 = 148;
    public static final int CHIP_ERASE2 = 128;
    public static final int CHIP_ERASE3 = 154;
    public static final int PAGE_PROGRAM_THROUGH_BUFFER1 = 130;
    public static final int PAGE_PROGRAM_THROUGH_BUFFER2 = 133;
    public static final int PAGE_TO_BUFFER1 = 83;
    public static final int PAGE_TO_BUFFER2 = 85;
    public static final int PAGE_TO_BUFFER1_COMPARE = 96;
    public static final int PAGE_TO_BUFFER2_COMPARE = 97;
    public static final int AUTO_PAGE_REWRITE_BUFFER1 = 88;
    public static final int AUTO_PAGE_REWRITE_BUFFER2 = 89;
    public static final int DEEP_POWER_DOWN = 185;
    public static final int RESUME_DEEP_POWER_DOWN = 171;
    public static final int STATUS_REGISTER_READ = 215;
    public static final int READ_DEVICE_ID = 159;
    public static final int STATUS_RDY = 128;
    public static final int STATUS_COMP = 64;
    public static final int STATUS_DENSITY = 60;
    public static final int STATUS_PROTECT = 2;
    public static final int STATUS_PAGE_SIZE = 1;
    private static final int STATE_RESET = 0;
    private static final int STATE_IDLE = 1;
    private static final int READ_ADDRESS = 2;
    private int state = 0;
    private int next_state = 0;
    private boolean Reset;
    private boolean chipSelect;
    private int pos;
    private int status = 156;
    private int pageAddress;
    private int bufferAddress;
    private int dummy = 0;
    private byte[] buffer1 = new byte[264];
    private byte[] buffer2 = new byte[264];
    private TimeEvent writeEvent = new TimeEvent(0L){

        @Override
        public void execute(long t) {
            AT45DB.this.setReady(true);
        }
    };
    private MSP430Core cpu;

    public AT45DB(MSP430Core cpu) {
        this.cpu = cpu;
    }

    private void setReady(boolean ready) {
        this.status = ready ? (this.status |= 0x80) : (this.status &= 0xFFFFFF7F);
    }

    @Override
    public void dataReceived(USART source, int data) {
        int buf_num = 1;
        if (this.chipSelect) {
            block0 : switch (this.state) {
                case 2: {
                    ++this.pos;
                    if (this.pos == 1) {
                        this.pageAddress = (data & 0xF) << 7;
                    } else if (this.pos == 2) {
                        this.pageAddress |= (data & 0xFE) >> 1;
                        this.bufferAddress = (data & 1) << 9;
                    } else if (this.pos == 3) {
                        this.bufferAddress |= data;
                        if (this.dummy == 0) {
                            this.state = this.next_state;
                        }
                    } else if (--this.dummy == 0) {
                        this.state = this.next_state;
                    }
                    source.byteReceived(0);
                    break;
                }
                case 212: 
                case 214: {
                    buf_num = this.state == 212 ? 1 : 2;
                    source.byteReceived(this.readBuffer(buf_num, this.bufferAddress++));
                    if (this.bufferAddress < 264) break;
                    System.out.println("AT45DB: ERROR: Buffer Read past buffer size: " + this.bufferAddress);
                    break;
                }
                case 132: 
                case 135: {
                    buf_num = this.state == 132 ? 1 : 2;
                    this.writeBuffer(buf_num, this.bufferAddress++, data);
                    if (this.bufferAddress >= 264) {
                        System.out.println("AT45DB: ERROR: Buffer Write past buffer size: " + this.bufferAddress);
                    }
                    source.byteReceived(0);
                    break;
                }
                case 215: {
                    source.byteReceived(this.status);
                    break;
                }
                case 0: 
                case 1: {
                    switch (data) {
                        case 131: 
                        case 134: {
                            this.pos = 0;
                            this.state = 2;
                            this.next_state = data;
                            this.dummy = 0;
                            this.setReady(false);
                            source.byteReceived(0);
                            break block0;
                        }
                        case 212: 
                        case 214: {
                            this.pos = 0;
                            this.state = 2;
                            this.next_state = data;
                            this.dummy = 1;
                            this.setReady(false);
                            source.byteReceived(0);
                            break block0;
                        }
                        case 132: 
                        case 135: {
                            this.pos = 0;
                            this.state = 2;
                            this.next_state = data;
                            this.dummy = 0;
                            this.setReady(false);
                            source.byteReceived(0);
                            break block0;
                        }
                        case 83: 
                        case 85: {
                            this.pos = 0;
                            this.state = 2;
                            this.next_state = data;
                            this.dummy = 0;
                            this.setReady(false);
                            source.byteReceived(0);
                            break block0;
                        }
                        case 215: {
                            this.state = 215;
                            source.byteReceived(0);
                            break block0;
                        }
                    }
                    System.out.println("AT45DB: WARNING: Command not implemented: " + data);
                    source.byteReceived(0);
                    break;
                }
                default: {
                    source.byteReceived(0);
                }
            }
        }
    }

    private int readBuffer(int num, int address) {
        if (num == 1) {
            return this.buffer1[address & 0x1FF];
        }
        return this.buffer2[address & 0x1FF];
    }

    private void writeBuffer(int num, int address, int data) {
        if (num == 1) {
            this.buffer1[address & 0x1FF] = (byte)data;
        } else {
            this.buffer2[address & 0x1FF] = (byte)data;
        }
    }

    public void setReset(boolean reset) {
        this.Reset = reset;
        if (this.Reset) {
            this.state = 0;
        }
    }

    public void setChipSelect(boolean select) {
        this.chipSelect = select;
        if (!this.chipSelect) {
            switch (this.state) {
                case 131: 
                case 134: {
                    this.bufferToPage(this.state == 131 ? 1 : 2);
                    this.setReady(true);
                    break;
                }
                case 83: 
                case 85: {
                    this.pageToBuffer(this.state == 83 ? 1 : 2);
                    this.setReady(true);
                    break;
                }
                default: {
                    this.setReady(true);
                }
            }
            this.state = 1;
        }
    }

    private void bufferToPage(int buf) {
        try {
            this.seek(this.pageAddress * 264);
            if (buf == 1) {
                this.write(this.buffer1);
            } else {
                this.write(this.buffer2);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void pageToBuffer(int buf) {
        try {
            this.seek(this.pageAddress * 264);
            if (buf == 1) {
                this.read(this.buffer1);
            } else {
                this.read(this.buffer2);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getModeMax() {
        return 0;
    }

    @Override
    public String getName() {
        return "AT45DB: external flash";
    }

    public abstract void seek(long var1) throws IOException;

    public abstract int read(byte[] var1) throws IOException;

    public abstract void write(byte[] var1) throws IOException;
}

