/*
 * Decompiled with CFR 0.152.
 */
package se.sics.mspsim;

import java.io.IOException;
import se.sics.mspsim.platform.GenericNode;
import se.sics.mspsim.util.ArgumentManager;

public class Main {
    public static GenericNode createNode(String className) {
        try {
            Class<GenericNode> nodeClass = Class.forName(className).asSubclass(GenericNode.class);
            return nodeClass.newInstance();
        }
        catch (ClassNotFoundException e) {
        }
        catch (ClassCastException e) {
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return null;
    }

    public static void main(String[] args) throws IOException {
        GenericNode node;
        String nodeType;
        ArgumentManager config = new ArgumentManager();
        config.handleArguments(args);
        String platform = nodeType = config.getProperty("nodeType");
        if (nodeType != null) {
            node = Main.createNode(nodeType);
        } else {
            platform = config.getProperty("platform", "sky");
            nodeType = "se.sics.mspsim.platform." + platform + '.' + Character.toUpperCase(platform.charAt(0)) + platform.substring(1).toLowerCase() + "Node";
            node = Main.createNode(nodeType);
            if (node == null) {
                nodeType = "se.sics.mspsim.platform." + platform + '.' + platform.toUpperCase() + "Node";
                node = Main.createNode(nodeType);
            }
        }
        if (node == null) {
            System.err.println("MSPSim does not currently support the platform '" + platform + "'.");
            System.exit(1);
        }
        node.setupArgs(config);
    }
}

