/*
 * Decompiled with CFR 0.152.
 */
package cck.util;

import java.util.HashMap;

public class VersionTag {
    private static final HashMap tags = new HashMap();
    public final String module;
    public final String prefix;
    public final int major;
    public final int minor;
    public final int commit;
    public final String string;
    public final String suffix;

    public static VersionTag getVersionTag(String module) {
        return (VersionTag)tags.get(module);
    }

    public VersionTag(String mod, String prefix, int maj, int min, int comm) {
        this.module = mod;
        this.prefix = prefix;
        this.major = maj;
        this.minor = min;
        this.commit = comm;
        this.string = this.prefixString(false, ' ') + this.major + '.' + this.minor + '.' + this.commitNumber();
        this.suffix = this.prefixString(true, '-') + this.major + '.' + this.minor + '.' + this.commitNumber();
        tags.put(mod, this);
    }

    public String toString() {
        return this.string;
    }

    private String prefixString(boolean lower, char suffix) {
        if (this.prefix.length() == 0) {
            return "";
        }
        return (lower ? this.prefix.toLowerCase() : this.prefix) + suffix;
    }

    private String commitNumber() {
        if (this.commit < 10) {
            return "00" + this.commit;
        }
        if (this.commit < 100) {
            return "0" + this.commit;
        }
        return Integer.toString(this.commit);
    }

    public boolean isStable() {
        return this.minor % 2 == 0;
    }
}

