/*
 * Decompiled with CFR 0.152.
 */
package cck.util;

import cck.text.StringUtil;
import cck.text.Terminal;
import java.io.File;

public class Util {
    public static InternalError unimplemented() {
        return new InternalError("unimplemented");
    }

    public static InternalError unreachable() {
        return new InternalError("unreachable");
    }

    public static InternalError failure(String s) {
        return new InternalError(s);
    }

    public static void enforce(boolean b, String s) {
        if (!b) {
            throw new InternalError(s);
        }
    }

    public static InternalError failure(String c, String s) {
        return new InternalError(c, s);
    }

    public static void warning(String s) {
        Terminal.print(11, "Internal Warning");
        Terminal.print(": " + s + '\n');
    }

    public static Unexpected unexpected(Throwable t) {
        return new Unexpected(t);
    }

    public static void userError(String s) {
        throw new Error(s);
    }

    public static void userError(String s, String p) {
        throw new Error(s, p);
    }

    public static boolean verifyFilesExist(String[] files) {
        boolean success = true;
        for (int cntr = 0; cntr < files.length; ++cntr) {
            String file = files[cntr];
            if (Util.verifyFileExists(file)) continue;
            success = false;
        }
        return success;
    }

    public static boolean verifyFileExists(String file) {
        File f = new File(file);
        if (!f.exists()) {
            Util.userError("File not found", file);
            return false;
        }
        return true;
    }

    public static class Unexpected
    extends Error {
        public final Throwable thrown;

        public Unexpected(Throwable t) {
            super(StringUtil.quote(t.getClass()));
            this.thrown = t;
        }

        public void report() {
            Terminal.print(1, "Unexpected exception");
            Terminal.print(": " + this.param + '\n');
            this.thrown.printStackTrace();
        }

        public void rethrow() throws Throwable {
            throw this.thrown;
        }
    }

    public static class InternalError
    extends Error {
        private String category;

        public InternalError(String param) {
            super(param);
            this.category = "Internal Error";
        }

        public InternalError(String c, String param) {
            super(param);
            this.category = c;
        }

        public void report() {
            Terminal.print(1, this.category);
            Terminal.print(": " + this.param + '\n');
            this.printStackTrace();
        }
    }

    public static class Error
    extends java.lang.Error {
        protected final String message;
        protected final String param;
        public static boolean STACKTRACES;

        public Error(String p) {
            super(p);
            this.message = "Error";
            this.param = p;
        }

        public Error(String n, String p) {
            super(n);
            this.message = n;
            this.param = p;
        }

        public String getParam() {
            return this.param;
        }

        public void report() {
            Terminal.print(1, this.message);
            Terminal.print(": " + this.param + '\n');
            if (STACKTRACES) {
                this.printStackTrace();
            }
        }
    }
}

