/*
 * Decompiled with CFR 0.152.
 */
package cck.util;

import cck.util.Arithmetic;

public class TimeUtil {
    public static final int[] DENOM = new int[]{24, 60, 60, 1000};
    public static final int[] DAYSECS = new int[]{60, 60};
    public static final int SECS_PER_DAY = 86400;
    public static final int SECS_PER_HOUR = 3600;
    public static final int SECS_PER_MIN = 60;
    public static final long MILLISECS_PER_DAY = 86400000L;
    public static final long MILLISECS_PER_HOUR = 3600000L;
    public static final long MILLISECS_PER_MIN = 60000L;
    public static final long MILLISECS_PER_SEC = 1000L;
    public static final int DAYS = 0;
    public static final int HOURS = 1;
    public static final int MINS = 2;
    public static final int SECS = 3;
    public static final int MILLIS = 4;

    public static String milliToSecs(long millis) {
        long secs = millis / 1000L;
        millis %= 1000L;
        StringBuffer buf = new StringBuffer(10);
        buf.append(secs);
        buf.append('.');
        TimeUtil.zeropad3(millis, buf);
        return buf.toString();
    }

    public static long[] millisToDays(long millis) {
        return Arithmetic.modulus(millis, DENOM);
    }

    public static void appendSecs(StringBuffer buf2, long seconds) {
        long[] res = Arithmetic.modulus(seconds, DAYSECS);
        for (int cntr = 0; cntr < res.length; ++cntr) {
            if (cntr > 0) {
                buf2.append(':');
                TimeUtil.zeropad2(res[cntr], buf2);
                continue;
            }
            buf2.append(res[cntr]);
        }
    }

    public static long millisToCycles(double millis, double hz) {
        return (long)(hz * millis / 1000.0);
    }

    public static double cyclesToMillis(long cycles, double hz) {
        return 1000.0 * (double)cycles / hz;
    }

    public static long secondsToCycles(double secs, double hz) {
        return (long)(hz * secs);
    }

    public static double cyclesToSeconds(long cycles, double hz) {
        return (double)cycles / hz;
    }

    protected static void zeropad3(long v, StringBuffer buf) {
        if (v < 100L) {
            buf.append('0');
        }
        if (v < 10L) {
            buf.append('0');
        }
        buf.append(v);
    }

    protected static void zeropad2(long v, StringBuffer buf) {
        if (v < 10L) {
            buf.append('0');
        }
        buf.append(v);
    }
}

